/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.bw.db.oracle;

import java.io.File;
import java.io.IOException;
import org.smyld.SMYLDObject;
import org.smyld.bw.db.BWDataBase;
import org.smyld.bw.db.DBName;
import org.smyld.bw.db.SMYLDTableRecord;
import org.smyld.io.SMYLDFileOutputStream;

public class SMYLDOraExtTableSaver
extends SMYLDObject
implements DBName {
    private static final long serialVersionUID = 1L;
    String folder;
    String tableName;
    SMYLDFileOutputStream fout;
    BWDataBase bwDB;
    String processName;

    public SMYLDOraExtTableSaver() {
    }

    public SMYLDOraExtTableSaver(String folder, String tableName, BWDataBase bwDataBase) {
        this.setFolder(folder);
        this.setTableName(tableName);
        this.bwDB = bwDataBase;
    }

    public void init() throws Exception {
        this.fout = this.initOutputFile();
    }

    private SMYLDFileOutputStream initOutputFile() throws Exception {
        return new SMYLDFileOutputStream(this.initFile());
    }

    private File initFile() {
        String newPath = this.getFolder();
        newPath = newPath == null ? "" : newPath + File.separator;
        return new File(newPath + this.getTableName() + "_EXT.dat");
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void saveRecord(SMYLDTableRecord record) throws IOException {
        this.fout.writeln(record.printFlatValues());
    }

    public void close() throws Exception {
        this.fout.close();
        int result = this.bwDB.callInsertExternal(this.getTableName(), this.getProcessName());
        if (result == 0) {
            throw new Exception("Error while writing externally to the table " + this.tableName);
        }
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }
}

