/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.bw.util;

import java.util.Date;
import java.util.GregorianCalendar;
import org.smyld.util.DateConverter;
import org.smyld.util.SMYLDDate;

public class BWDateConverter
extends DateConverter {
    private static final long serialVersionUID = 1L;
    SMYLDDate postingDate;
    int acceptedDiffinDays;
    int postingYear;
    long acceptedDiffinMS;
    long negativeDiff;
    GregorianCalendar calendar = new GregorianCalendar();
    private static final int Date_Diff = 28;

    public BWDateConverter() {
        this.setInterval(28);
    }

    public BWDateConverter(String postingDateYear) {
        super(postingDateYear);
        this.setInterval(28);
    }

    public BWDateConverter(String postingDateYear, String targetFormat) {
        super(postingDateYear, targetFormat);
        this.setInterval(28);
    }

    public BWDateConverter(SMYLDDate PostingDate) {
        this(PostingDate, "yyyyMMdd", 28);
    }

    public BWDateConverter(SMYLDDate PostingDate, String TargetFormat) {
        this(PostingDate, TargetFormat, 28);
    }

    public BWDateConverter(SMYLDDate PostingDate, String TargetFormat, int DateDifferenceInterval) {
        this.setPostingDate(PostingDate);
        this.setTargetFormat(TargetFormat);
        this.setInterval(DateDifferenceInterval);
    }

    public SMYLDDate convertOnPostingDate(SMYLDDate currentDate) {
        this.convertDate(currentDate);
        long diff = this.targetDate.getTime() - this.postingDate.getTime();
        int changeValue = 0;
        if (diff > this.acceptedDiffinMS) {
            changeValue = -1;
        } else if (diff < this.negativeDiff) {
            changeValue = 1;
        }
        if (changeValue == -1) {
            this.changeYear(changeValue);
        }
        return this.targetDate;
    }

    private void changeYear(int value) {
        this.calendar.setTime((Date)this.targetDate);
        this.calendar.set(1, this.calendar.get(1) + value);
        this.targetDate.setTime(this.calendar.getTimeInMillis());
    }

    public String convertOnPostingDatetoText(SMYLDDate currentDate) {
        this.convertOnPostingDate(currentDate);
        if (this.targetDate != null) {
            return this.targetDate.toString();
        }
        return null;
    }

    public void setInterval(int days) {
        this.acceptedDiffinDays = days;
        this.acceptedDiffinMS = SMYLDDate.getDaysInMilliseconds((int)this.acceptedDiffinDays);
        this.negativeDiff = SMYLDDate.getDaysInMilliseconds((int)(this.acceptedDiffinDays - 365));
    }

    public void setPostingDate(SMYLDDate newPostingDate) {
        this.postingDate = newPostingDate;
        this.setActiveYear(this.postingDate.toString("yyyy"));
        this.postingYear = Integer.parseInt(this.referenceYear);
    }
}

