/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.bw.util;

import java.io.File;
import org.smyld.io.SMYLDFileFilter;

public class BWFileFilter
extends SMYLDFileFilter {
    private static final long serialVersionUID = 1L;
    String filePatternMask;
    String[] filePatternMasks;
    StringBuffer buffer = new StringBuffer();

    public BWFileFilter(String BWFilePattern, boolean InformOnce) {
        super(BWFilePattern, InformOnce);
        this.createMask();
    }

    public BWFileFilter(String[] BWFilePatterns, boolean InformOnce) {
        super(BWFilePatterns, InformOnce);
        this.createMasks();
    }

    private void createMasks() {
        this.filePatternMasks = new String[this.getFilePatterns().length];
        for (int i = 0; i < this.getFilePatterns().length; ++i) {
            this.filePatternMasks[i] = this.convertToMask(this.getFilePatterns()[i]);
        }
    }

    private void createMask() {
        this.filePatternMask = this.convertToMask(this.getFilePattern());
    }

    private String convertToMask(String pattern) {
        this.buffer.setLength(0);
        boolean insidePattern = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char currentChar = pattern.charAt(i);
            if (currentChar == '<') {
                insidePattern = true;
                continue;
            }
            if (currentChar == '>') {
                insidePattern = false;
                continue;
            }
            if (insidePattern) {
                this.buffer.append('|');
                continue;
            }
            this.buffer.append(currentChar);
        }
        return this.buffer.toString();
    }

    public boolean accept(File dir, String name) {
        if (this.filePatternMask != null) {
            return this.match(name, this.filePatternMask);
        }
        if (this.filePatternMasks != null) {
            for (int i = 0; i < this.filePatternMasks.length; ++i) {
                if (!this.match(name, this.filePatternMasks[i])) continue;
                this.addAcceptedFile(name, this.getFilePatterns()[i]);
                return true;
            }
        }
        return false;
    }

    private boolean match(String name, String mask) {
        if (name.length() == mask.length()) {
            for (int i = 0; i < name.length(); ++i) {
                char maskChar = mask.charAt(i);
                if (maskChar == '|' || maskChar == name.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

