/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import org.smyld.SMYLDObject;
import org.smyld.db.DBConnectionListener;
import org.smyld.db.DBSettings;
import org.smyld.db.Utility;

public class DBConnection
extends SMYLDObject
implements Runnable {
    private static final long serialVersionUID = 1L;
    protected DBSettings settings;
    String ConnectionPath;
    protected boolean reconnecting;
    protected boolean connected;
    protected Connection dbConnection;
    protected Vector<DBConnectionListener> connectionListeners;
    protected Vector<DBConnectionListener> internalConnectionListeners;
    public static final int DB_RECONNECT_SLEEP_TIME = 1000;

    public DBConnection(String newUserName, String newUserPass, String newDBName) {
        this.settings = new DBSettings();
        this.settings.setUserName(newUserName);
        this.settings.setUserPassword(newUserPass);
        this.settings.setName(newDBName);
    }

    public DBConnection(DBSettings settings) {
        this.setSettings(settings);
    }

    public DBConnection(String newUserName, String newUserPass, String newDBName, String newPort, String newHost) {
        this(newUserName, newUserPass, newDBName);
        this.settings.setPort(newPort);
        this.settings.setHost(newHost);
    }

    public DBConnection(String path) {
        this.setConnectionPath(path);
    }

    public DBConnection() {
    }

    public void setSettings(DBSettings newSettings) {
        this.settings = newSettings;
    }

    public DBSettings getSettings() {
        return this.settings;
    }

    private void init() {
    }

    public void releaseConnections() throws SQLException {
        throw new SQLException("Release connection function must be provided");
    }

    public Connection getConnection() {
        return this.dbConnection;
    }

    public synchronized Connection createConnection() throws SQLException {
        return null;
    }

    public synchronized void reconnect() throws SQLException {
        this.dbConnection = this.createConnection();
    }

    public synchronized boolean isReconnecting() {
        return this.reconnecting;
    }

    public static Properties loadDBParams(String path) {
        Properties params = new Properties();
        try {
            File f = new File(path);
            params.load(new FileInputStream(f));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return params;
    }

    public String getConnectionPath() {
        return this.ConnectionPath;
    }

    public void setConnectionPath(String newConnectionPath) {
        this.ConnectionPath = newConnectionPath;
    }

    public Object clone() {
        return new DBConnection();
    }

    public void addInternalDBConnectionListener(DBConnectionListener newConnectionListener) {
        if (this.internalConnectionListeners == null) {
            this.internalConnectionListeners = new Vector();
        }
        this.internalConnectionListeners.add(newConnectionListener);
    }

    public void addInternalDBConnectionListener(DBConnectionListener newConnectionListener, int priorty) {
        if (this.internalConnectionListeners == null) {
            this.internalConnectionListeners = new Vector();
        }
        this.internalConnectionListeners.add(priorty, newConnectionListener);
    }

    public void addDBConnectionListener(DBConnectionListener newConnectionListener, int priorty) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new Vector();
        }
        this.connectionListeners.add(priorty, newConnectionListener);
    }

    public void addDBConnectionListener(DBConnectionListener newConnectionListener) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new Vector();
        }
        this.connectionListeners.add(newConnectionListener);
    }

    public boolean detectConnectionError(Exception ex) {
        if (Utility.getErrorCategory(ex) == 1) {
            if (!this.reconnecting) {
                this.connected = false;
                this.reconnecting = true;
                this.informConnClosed(this.internalConnectionListeners);
                this.informConnClosed(this.connectionListeners);
                new Thread(this).start();
            }
            return true;
        }
        return false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void run() {
        while (!this.connected) {
            try {
                this.reconnect();
                this.connected = true;
                this.reconnecting = false;
                this.informConnResumed(this.internalConnectionListeners);
                this.informConnResumed(this.connectionListeners);
            }
            catch (Exception ex) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception sleepex) {
                    sleepex.printStackTrace();
                }
            }
        }
    }

    private void informConnClosed(Vector<DBConnectionListener> listeners) {
        for (DBConnectionListener connectionListener : listeners) {
            connectionListener.connectionClosed();
        }
    }

    private void informConnResumed(Vector<DBConnectionListener> listeners) {
        for (DBConnectionListener connectionListener : listeners) {
            connectionListener.connectionResumed(this);
        }
    }
}

