/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.smyld.db.DBConnection;
import org.smyld.db.DBErrorHandler;
import org.smyld.db.DBIOException;
import org.smyld.db.SMYLDDataBaseHandler;
import org.smyld.db.SQL;
import org.smyld.db.schema.TableColumn;
import org.smyld.text.TextUtil;

public class DBIOHandler
extends SMYLDDataBaseHandler
implements SQL {
    private static final long serialVersionUID = 1L;
    BufferedReader reader;
    protected PreparedStatement pst;
    String sep;
    String[] data;
    Vector<TableColumn> schemaCols;
    int rejNo;
    int addNo;
    int fldNo;
    int lineNo;
    int offSet;
    boolean isQouted;

    public DBIOHandler(DBErrorHandler e, DBConnection dbConn) {
        super(e, dbConn);
    }

    public void importFile(String dumpKey, String targetTable, String fileName, String separator) throws Exception {
        this.lineNo = 0;
        this.sep = separator;
        String currentLine = null;
        try {
            this.reader = new BufferedReader(new FileReader(fileName));
            this.doInitializeProcess(targetTable);
            while ((currentLine = this.reader.readLine()) != null) {
                ++this.lineNo;
                if (!this.isQouted && currentLine.startsWith("\"")) {
                    this.isQouted = true;
                    this.sep = "\"" + this.sep + "\"";
                }
                if (currentLine.startsWith(dumpKey)) continue;
                this.insertRecord(currentLine);
            }
            this.doClearProcess();
        }
        catch (Exception e) {
            throw new DBIOException(e, currentLine);
        }
    }

    protected void doInitializeProcess(String targetTable) throws Exception {
        String sql = this.dbUtility.createInsertSQL(targetTable);
        this.schemaCols = this.dbUtility.getTableCols(targetTable);
        this.fldNo = this.schemaCols.size();
        this.pst = this.prepareStatement(sql);
    }

    protected void doClearProcess() throws Exception {
        System.out.println(this.getLineNumber() + " line added.");
        this.dbUtility.closeCursor(this.pst);
        this.dbConnection.commit();
    }

    protected PreparedStatement prepareStatement(String sql) throws Exception {
        return this.smyldDBConnection.getConnection().prepareStatement(sql);
    }

    protected void insertRecord(String currentLine) throws Exception {
        this.data = this.readData(currentLine);
        this.insertLine(this.data);
    }

    public String[] getLastDataLine() {
        return this.data;
    }

    protected String createInsertSQL(String tableName) throws SQLException {
        DatabaseMetaData rsmeta = this.smyldDBConnection.getConnection().getMetaData();
        StringBuffer buffer = new StringBuffer();
        buffer.append("Insert into ");
        buffer.append(tableName);
        buffer.append(" (");
        ResultSet rsTableCols = rsmeta.getColumns(null, this.smyldDBConnection.getSettings().getSchemaOwner().toUpperCase(), tableName, null);
        this.fldNo = 0;
        this.schemaCols = new Vector();
        while (rsTableCols.next()) {
            String colName = rsTableCols.getString("COLUMN_NAME");
            int colSize = rsTableCols.getInt("COLUMN_SIZE");
            TableColumn newColumn = new TableColumn();
            newColumn.setName(colName);
            newColumn.setSize(colSize);
            this.schemaCols.add(newColumn);
            buffer.append(colName);
            buffer.append(", ");
            ++this.fldNo;
        }
        buffer.replace(buffer.length() - 2, buffer.length() - 1, ") ");
        buffer.append(" Values (");
        for (int i = 0; i < this.fldNo; ++i) {
            buffer.append("?");
            buffer.append(", ");
        }
        buffer.replace(buffer.length() - 2, buffer.length() - 1, ") ");
        return buffer.toString();
    }

    protected String[] readData(String currentLine) throws Exception {
        String[] data = currentLine.split(this.sep);
        if (this.isQouted) {
            data[0] = data[0].substring(1);
            data[data.length - 1] = data[data.length - 1].substring(0, data[data.length - 1].length() - 2);
        }
        return data;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    protected void insertLine(String[] data) throws Exception {
        for (int i = 0; i < this.fldNo; ++i) {
            this.pst.setString(i + 1, data[i]);
        }
        if (this.pst.execute()) {
            ++this.rejNo;
        } else {
            ++this.addNo;
        }
    }

    protected void fillData(String[] data, int offset) throws Exception {
        if (offset > 0) {
            this.offSet = offset;
        }
        int dataIdx = 0;
        for (int i = offset; i < this.fldNo; ++i) {
            data[dataIdx] = data[dataIdx] != null ? data[dataIdx].trim() : "";
            this.pst.setString(i + 1, data[dataIdx]);
            ++dataIdx;
        }
    }

    public Vector<String> detectSchemaError(String recordLine) {
        String[] dataFlds = recordLine.split(this.sep);
        String curFieldValue = null;
        Vector<String> errorLines = new Vector<String>();
        int dataIdx = 0;
        if (this.schemaCols.size() > dataFlds.length) {
            errorLines.add("There are " + (this.schemaCols.size() - dataFlds.length) + " data info missing!");
        }
        for (int i = this.offSet; i < dataFlds.length; ++i) {
            if (i < this.schemaCols.size()) {
                TableColumn curColumn = this.schemaCols.get(i);
                String string = curFieldValue = dataFlds[dataIdx] != null ? dataFlds[dataIdx].trim() : "";
                if (curFieldValue != null) {
                    if (curColumn.getSize() < curFieldValue.length()) {
                        errorLines.add("Column " + curColumn.getName() + " length is " + curColumn.getSize() + " while data length is " + curFieldValue.length() + " containing (" + dataFlds[dataIdx] + ")");
                    }
                    if (this.isNumeric(curColumn) && (curFieldValue == null || !TextUtil.isDecimal((String)curFieldValue))) {
                        errorLines.add("Column " + curColumn.getName() + " type is " + curColumn.getType() + " while data value (" + curFieldValue + ") do not match");
                    }
                }
            } else {
                errorLines.add("Additional field data detected for the value (" + curFieldValue + ")");
            }
            ++dataIdx;
        }
        if (errorLines.size() == 0) {
            return null;
        }
        return errorLines;
    }

    public void rollback() throws Exception {
        this.dbConnection.rollback();
    }

    public void commit() throws Exception {
        this.dbConnection.commit();
    }

    private boolean isNumeric(TableColumn curColumn) {
        return "'INTEGER','NUMBER'".indexOf(curColumn.getType()) != -1;
    }

    protected void postLine() throws Exception {
        if (this.pst.execute()) {
            ++this.rejNo;
        } else {
            ++this.addNo;
        }
    }
}

