/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import org.smyld.db.DBConnection;
import org.smyld.db.DBErrorHandler;
import org.smyld.db.DBIOHandler;
import org.smyld.db.Field;
import org.smyld.db.oracle.OracleSqlException;
import org.smyld.db.schema.TableColumn;

public class Utility {
    protected Connection dbConnection;
    protected DBConnection smyldDbConnection;
    protected DBIOHandler ioHandler;
    protected DBErrorHandler handler;
    public static final int ERR_CATEGORY_SQL = 0;
    public static final int ERR_CATEGORY_CONNECTION = 1;
    public static final int ERR_CATEGORY_STORED_PROCEDURES_RECOMPILED = 10;
    public static final int ERR_CATEGORY_STORED_PROCEDURES_ERROR = 11;
    public static final int EXCEPTION_CONNECTION_RESET = 17002;
    public static final int EXCEPTION_CONNECTION_SHUT = 1089;
    private static final String COL_MATH_COUNTER = "counter";
    private static final String COL_MATH_MAX_ID = "MaxID";

    public Utility(DBConnection activeDBConnection, DBErrorHandler e) {
        this.smyldDbConnection = activeDBConnection;
        this.dbConnection = this.smyldDbConnection.getConnection();
        this.handler = e;
    }

    public void closeCursor(ResultSet rsRecords) {
        try {
            if (rsRecords != null) {
                rsRecords.close();
                rsRecords.getStatement().close();
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
    }

    public void closeCursor(PreparedStatement stRecords) {
        try {
            if (stRecords != null) {
                stRecords.close();
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doDoubleParamSQL(String firstParam, String secondParam, String sqlText) {
        boolean changeResult = false;
        PreparedStatement stReport = null;
        try {
            stReport = this.dbConnection.prepareStatement(sqlText);
            stReport.setString(1, firstParam);
            stReport.setString(2, secondParam);
            stReport.execute();
            changeResult = true;
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.closeCursor(stReport);
        }
        return changeResult;
    }

    public void setSMYLDConnection(DBConnection activeConnection) {
        this.smyldDbConnection = activeConnection;
        this.dbConnection = this.smyldDbConnection.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doDoubleParamUpdateSQL(String firstParam, String secondParam, String sqlText) {
        int changeResult = 0;
        PreparedStatement stReport = null;
        try {
            stReport = this.dbConnection.prepareStatement(sqlText);
            stReport.setString(1, firstParam);
            stReport.setString(2, secondParam);
            changeResult = stReport.executeUpdate();
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.closeCursor(stReport);
        }
        return changeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doSingleParamSQL(int firstParam, String sqlText) {
        boolean result = false;
        PreparedStatement stReport = null;
        try {
            stReport = this.dbConnection.prepareStatement(sqlText);
            stReport.setInt(1, firstParam);
            stReport.execute();
            result = true;
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.closeCursor(stReport);
        }
        return result;
    }

    public String detectLongFieldError(PreparedStatement st) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        ResultSetMetaData rsm = st.getMetaData();
        ResultSet rs = st.getResultSet();
        for (int i = 0; i < rsm.getColumnCount(); ++i) {
            int stSize;
            int dbSize = rsm.getColumnDisplaySize(i + 1);
            if (dbSize != (stSize = rs.getString(i + 1).length())) {
                buffer.append(rsm.getColumnName(i + 1));
            }
            buffer.append(",");
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doTrippleParamUpdateSQL(String firstParam, String secondParam, String thirdParam, String sqlText) {
        int changeResult = 0;
        PreparedStatement stReport = null;
        try {
            stReport = this.dbConnection.prepareStatement(sqlText);
            stReport.setString(1, firstParam);
            stReport.setString(2, secondParam);
            stReport.setString(3, thirdParam);
            changeResult = stReport.executeUpdate();
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.closeCursor(stReport);
        }
        return changeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doQuadParamUpdateSQL(String firstParam, String secondParam, String thirdParam, String fourthParam, String sqlText) {
        int changeResult = 0;
        PreparedStatement stReport = null;
        try {
            stReport = this.dbConnection.prepareStatement(sqlText);
            stReport.setString(1, firstParam);
            stReport.setString(2, secondParam);
            stReport.setString(3, thirdParam);
            stReport.setString(4, fourthParam);
            changeResult = stReport.executeUpdate();
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.closeCursor(stReport);
        }
        return changeResult;
    }

    public ResultSet getTrippleParamSQL(String firstParam, String secondParam, String thirdParam, String sqlText) {
        ResultSet rsResult = null;
        PreparedStatement stReport = null;
        try {
            stReport = this.dbConnection.prepareStatement(sqlText);
            stReport.setString(1, firstParam);
            stReport.setString(2, secondParam);
            stReport.setString(3, thirdParam);
            rsResult = stReport.executeQuery();
        }
        catch (Exception ex) {
            this.handleDBError(ex);
            this.closeCursor(stReport);
        }
        return rsResult;
    }

    public ResultSet getQuadParamSQL(String firstParam, String secondParam, String thirdParam, String fourthParam, String sqlText) {
        ResultSet rsResult = null;
        PreparedStatement stReport = null;
        try {
            stReport = this.dbConnection.prepareStatement(sqlText);
            stReport.setString(1, firstParam);
            stReport.setString(2, secondParam);
            stReport.setString(3, thirdParam);
            stReport.setString(4, fourthParam);
            rsResult = stReport.executeQuery();
        }
        catch (Exception ex) {
            this.handleDBError(ex);
            this.closeCursor(stReport);
        }
        return rsResult;
    }

    public ResultSet getTrippleParamSQL(int firstParam, int secondParam, String thirdParam, String sqlText) {
        return this.getTrippleParamSQL(Integer.toString(firstParam), Integer.toString(secondParam), thirdParam, sqlText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doSingleParamUpdateSQL(String firstParam, String sqlText) {
        int result = 0;
        PreparedStatement stReport = null;
        try {
            stReport = this.dbConnection.prepareStatement(sqlText);
            stReport.setString(1, firstParam);
            result = stReport.executeUpdate();
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.closeCursor(stReport);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doSingleParamSQL(String firstParam, String sqlText) {
        boolean result = false;
        PreparedStatement stReport = null;
        try {
            stReport = this.dbConnection.prepareStatement(sqlText);
            stReport.setString(1, firstParam);
            stReport.execute();
            result = true;
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.closeCursor(stReport);
        }
        return result;
    }

    public ResultSet executeQuery(String sqlText) {
        ResultSet rsResult = null;
        try {
            PreparedStatement stRecords = this.dbConnection.prepareStatement(sqlText);
            rsResult = stRecords.executeQuery();
        }
        catch (Exception ex) {
            this.handleDBError(ex);
            this.closeCursor(rsResult);
        }
        return rsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSQLData(String sqlText, String columnName) {
        String info = null;
        ResultSet rsData = null;
        try {
            rsData = this.executeQuery(sqlText);
            if (rsData.next()) {
                info = rsData.getString(columnName);
            }
            rsData.close();
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.closeCursor(rsData);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSingleParamSQLData(String firstParam, String sqlText, String columnName) {
        String info = null;
        ResultSet rsData = null;
        try {
            rsData = this.getSingleParamSQL(firstParam, sqlText);
            if (rsData.next()) {
                info = rsData.getString(columnName);
            }
            rsData.close();
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.closeCursor(rsData);
        }
        return info;
    }

    public int getCount(ResultSet rs) {
        try {
            if (rs.next()) {
                int n = rs.getInt("RECORD_COUNT");
                return n;
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.closeCursor(rs);
        }
        return -1;
    }

    public ResultSet getSingleParamSQL(String paramValue, String sqlText) {
        PreparedStatement stReport = null;
        try {
            stReport = this.dbConnection.prepareStatement(sqlText);
            stReport.setString(1, paramValue);
            return stReport.executeQuery();
        }
        catch (Exception ex) {
            this.handleDBError(ex);
            this.closeCursor(stReport);
            return null;
        }
    }

    public ResultSet getSQLResultSet(String sqlText) {
        PreparedStatement stReport = null;
        try {
            stReport = this.dbConnection.prepareStatement(sqlText);
            return stReport.executeQuery();
        }
        catch (Exception ex) {
            this.handleDBError(ex);
            this.closeCursor(stReport);
            return null;
        }
    }

    public ResultSet getDoubleParamSQL(String firstParam, String secondParam, String sqlText) {
        PreparedStatement stReport = null;
        try {
            stReport = this.dbConnection.prepareStatement(sqlText);
            this.setString(stReport, firstParam, 1);
            this.setString(stReport, secondParam, 2);
            stReport.execute();
            return stReport.getResultSet();
        }
        catch (Exception ex) {
            this.handleDBError(ex);
            this.closeCursor(stReport);
            return null;
        }
    }

    private void setString(PreparedStatement pst, String paramValue, int paramIndex) throws SQLException {
        if (paramValue != null) {
            pst.setString(paramIndex, paramValue);
        } else {
            pst.setNull(paramIndex, 12);
        }
    }

    public ResultSet getDoubleParamSQL(int firstParam, String secondParam, String sqlText) {
        return this.getDoubleParamSQL(Integer.toString(firstParam), secondParam, sqlText);
    }

    public ResultSet getDoubleParamSQL(int firstParam, int secondParam, String sqlText) {
        return this.getDoubleParamSQL(Integer.toString(firstParam), Integer.toString(secondParam), sqlText);
    }

    public int getSequentialID(String tableName, String idColName) {
        return this.getSequentialID(tableName, idColName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSequentialID(String tableName, String idColName, String whereColumnName, String whereColumnValue) {
        String nestedSQL = "SELECT MAX(" + idColName + ") as " + COL_MATH_MAX_ID + " from " + tableName;
        if (whereColumnName != null && whereColumnValue != null) {
            nestedSQL = nestedSQL + " where " + whereColumnName + "=" + whereColumnValue;
        }
        ResultSet rsRecord = this.executeQuery(nestedSQL);
        int recordID = 1;
        try {
            if (rsRecord.next()) {
                recordID = rsRecord.getInt(COL_MATH_MAX_ID) + 1;
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
            recordID = -1;
        }
        finally {
            this.closeCursor(rsRecord);
        }
        return recordID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSequenceValue(String seqName) {
        String nestedSQL = "SELECT " + seqName + ".nextval from dual";
        ResultSet rsRecord = this.executeQuery(nestedSQL);
        int recordID = 1;
        try {
            if (rsRecord.next()) {
                recordID = rsRecord.getInt(0) + 1;
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
            recordID = -1;
        }
        finally {
            this.closeCursor(rsRecord);
        }
        return recordID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExist(ResultSet rsRecords) {
        boolean result = false;
        try {
            result = rsRecords.next();
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.closeCursor(rsRecords);
        }
        return result;
    }

    public boolean isSingleExist(String firstParam, String sqlText) {
        ResultSet rsRecords = this.getSingleParamSQL(firstParam, sqlText);
        return this.isExist(rsRecords);
    }

    public boolean isExist(String sqlText) {
        ResultSet rsRecords = this.getSQLResultSet(sqlText);
        return this.isExist(rsRecords);
    }

    public boolean isDoubleExist(String firstParam, String secondParam, String sqlText) {
        ResultSet rsRecords = this.getDoubleParamSQL(firstParam, secondParam, sqlText);
        return this.isExist(rsRecords);
    }

    public boolean isTrippleExist(String firstParam, String secondParam, String thirdParam, String sqlText) {
        ResultSet rsRecords = this.getTrippleParamSQL(firstParam, secondParam, thirdParam, sqlText);
        return this.isExist(rsRecords);
    }

    public ResultSet fetchTableData(String tableName) {
        String sqlStatement = "Select * from " + tableName;
        return this.executeQuery(sqlStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Field> FetchTableFields(String TableName, String FieldName, String FieldValue) {
        ResultSet rsTableData = null;
        HashMap<String, Field> resultFields = null;
        try {
            rsTableData = this.fetchTableData(TableName);
            while (rsTableData.next()) {
                if (resultFields == null) {
                    resultFields = new HashMap<String, Field>();
                }
                String colName = rsTableData.getString(FieldName);
                String colValue = rsTableData.getString(FieldValue);
                Field newField = new Field(colName, colValue);
                resultFields.put(colName, newField);
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
            resultFields = null;
        }
        finally {
            this.closeCursor(rsTableData);
        }
        return resultFields;
    }

    public void FillColumnNames(ResultSetMetaData rsMetaData, HashMap<String, Integer> results) {
        try {
            for (int i = 0; i < rsMetaData.getColumnCount(); ++i) {
                results.put(rsMetaData.getColumnName(i), i);
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
    }

    public static String getStringIndex(int digitWidth, int index) {
        String resultIndex = null;
        if (index > 0) {
            String indexText;
            resultIndex = indexText = Integer.toString(index);
            int indexDigitNo = indexText.length();
            if (indexDigitNo < digitWidth) {
                resultIndex = "";
                for (int i = 0; i < digitWidth - indexDigitNo; ++i) {
                    resultIndex = resultIndex + "0";
                }
                resultIndex = resultIndex + indexText;
                return resultIndex;
            }
        }
        return resultIndex;
    }

    public void handleDBError(Exception ex) {
        if (this.handler != null) {
            this.handler.addError(ex, this.dbConnection);
        } else {
            ex.printStackTrace();
        }
    }

    public static String constructSingleParamProcedureCall(String ProcedureName) {
        return "{call " + ProcedureName + "(?)}";
    }

    public static String constructDoubleParamProcedureCall(String ProcedureName) {
        return "{call " + ProcedureName + "(?,?)}";
    }

    public static String constructTrippleParamProcedureCall(String ProcedureName) {
        return "{call " + ProcedureName + "(?,?,?)}";
    }

    public static String constructSingleParamFunctionCall(String functionName) {
        return "{? = call " + functionName + " (?)}";
    }

    public static String constructDoubleParamFunctionCall(String functionName) {
        return "{? = call " + functionName + " (?,?)}";
    }

    public static String constructTrippleParamFunctionCall(String functionName) {
        return "{? = call " + functionName + " (?,?,?)}";
    }

    public static String constructMultiParamFunctionCall(String functionName, int paramsNo) {
        return "{? = call " + functionName + Utility.getParamsText(paramsNo) + "}";
    }

    public static String constructMultiParamProcedureCall(String ProcedureName, int paramsNo) {
        return "{call " + ProcedureName + Utility.getParamsText(paramsNo) + "}";
    }

    protected static String getParamsText(int paramsNo) {
        char[] result = new char[2 * paramsNo + 1];
        int arrayCount = 0;
        result[arrayCount] = 40;
        for (int i = 0; i < paramsNo; ++i) {
            result[++arrayCount] = 63;
            result[++arrayCount] = 44;
        }
        result[result.length - 1] = 41;
        return new String(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDoubleParamFunction(String function, String param1, String param2) {
        CallableStatement cstmt = null;
        try {
            cstmt = this.dbConnection.prepareCall(Utility.constructDoubleParamFunctionCall(function));
            cstmt.registerOutParameter(1, 4);
            cstmt.setString(2, param1);
            cstmt.setString(3, param2);
            cstmt.execute();
            this.closeCursor(cstmt);
        }
        catch (Exception ex) {
            try {
                this.handleDBError(ex);
                this.closeCursor(cstmt);
            }
            catch (Throwable throwable) {
                this.closeCursor(cstmt);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTrippleParamFunction(String function, String param1, String param2, String param3) {
        CallableStatement cstmt = null;
        try {
            cstmt = this.dbConnection.prepareCall(Utility.constructTrippleParamFunctionCall(function));
            cstmt.registerOutParameter(1, 4);
            cstmt.setString(2, param1);
            cstmt.setString(3, param2);
            cstmt.setString(4, param3);
            cstmt.execute();
            this.closeCursor(cstmt);
        }
        catch (Exception ex) {
            try {
                this.handleDBError(ex);
                this.closeCursor(cstmt);
            }
            catch (Throwable throwable) {
                this.closeCursor(cstmt);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDoubleParamFunction(String function, int param1, int param2) {
        CallableStatement cstmt = null;
        try {
            cstmt = this.dbConnection.prepareCall(Utility.constructDoubleParamFunctionCall(function));
            cstmt.registerOutParameter(1, 4);
            cstmt.setInt(2, param1);
            cstmt.setInt(3, param2);
            cstmt.execute();
            this.closeCursor(cstmt);
        }
        catch (Exception ex) {
            try {
                this.handleDBError(ex);
                this.closeCursor(cstmt);
            }
            catch (Throwable throwable) {
                this.closeCursor(cstmt);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeMultiParamProcedure(String procedure, String[] params) {
        int paramNo = params.length;
        CallableStatement cstmt = null;
        try {
            String resultantCall = Utility.constructMultiParamProcedureCall(procedure, paramNo);
            cstmt = this.dbConnection.prepareCall(resultantCall);
            for (int i = 1; i < paramNo + 1; ++i) {
                cstmt.setString(i, params[i - 1]);
            }
            cstmt.execute();
            this.closeCursor(cstmt);
        }
        catch (Exception ex) {
            try {
                this.handleDBError(ex);
                this.closeCursor(cstmt);
            }
            catch (Throwable throwable) {
                this.closeCursor(cstmt);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDoubleParamProcedure(String procedure, int param1, int param2) {
        CallableStatement cstmt = null;
        try {
            cstmt = this.dbConnection.prepareCall(Utility.constructDoubleParamProcedureCall(procedure));
            cstmt.setInt(1, param1);
            cstmt.setInt(2, param2);
            cstmt.execute();
            this.closeCursor(cstmt);
        }
        catch (Exception ex) {
            try {
                this.handleDBError(ex);
                this.closeCursor(cstmt);
            }
            catch (Throwable throwable) {
                this.closeCursor(cstmt);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDoubleParamProcedure(String procedure, String param1, String param2) {
        CallableStatement cstmt = null;
        try {
            cstmt = this.dbConnection.prepareCall(Utility.constructDoubleParamProcedureCall(procedure));
            cstmt.setString(1, param1);
            cstmt.setString(2, param2);
            cstmt.execute();
            this.closeCursor(cstmt);
        }
        catch (Exception ex) {
            try {
                this.handleDBError(ex);
                this.closeCursor(cstmt);
            }
            catch (Throwable throwable) {
                this.closeCursor(cstmt);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTrippleParamProcedure(String procedure, String param1, int param2, int param3) {
        CallableStatement cstmt = null;
        try {
            cstmt = this.dbConnection.prepareCall(Utility.constructTrippleParamProcedureCall(procedure));
            cstmt.setString(1, param1);
            cstmt.setInt(2, param2);
            cstmt.setInt(3, param3);
            cstmt.execute();
            this.closeCursor(cstmt);
        }
        catch (Exception ex) {
            try {
                this.handleDBError(ex);
                this.closeCursor(cstmt);
            }
            catch (Throwable throwable) {
                this.closeCursor(cstmt);
                throw throwable;
            }
        }
    }

    public Connection getConnection() {
        return this.dbConnection;
    }

    public void importFile(String targetTable, String fileName) throws Exception {
        this.ioHandler = new DBIOHandler(this.handler, this.smyldDbConnection);
    }

    public static int getErrorCategory(Exception ex) {
        int result = 0;
        OracleSqlException oraExc = new OracleSqlException((Exception)ex);
        result = oraExc.getExceptionCategory();
        ex = oraExc;
        return result;
    }

    public String createInsertSQL(String tableName) throws SQLException {
        DatabaseMetaData rsmeta = this.dbConnection.getMetaData();
        StringBuffer buffer = new StringBuffer();
        buffer.append("Insert into ");
        buffer.append(tableName);
        buffer.append(" (");
        ResultSet rsTableCols = rsmeta.getColumns(null, this.smyldDbConnection.getSettings().getSchemaOwner().toUpperCase(), tableName, null);
        int fldNo = 0;
        while (rsTableCols.next()) {
            String colName = rsTableCols.getString("COLUMN_NAME");
            buffer.append(colName);
            buffer.append(", ");
            ++fldNo;
        }
        buffer.replace(buffer.length() - 2, buffer.length() - 1, ") ");
        buffer.append(" Values (");
        for (int i = 0; i < fldNo; ++i) {
            buffer.append("?");
            buffer.append(", ");
        }
        buffer.replace(buffer.length() - 2, buffer.length() - 1, ") ");
        return buffer.toString();
    }

    public Vector<TableColumn> getTableCols(String tableName) throws SQLException {
        DatabaseMetaData rsmeta = this.dbConnection.getMetaData();
        ResultSet rsTableCols = rsmeta.getColumns(null, this.smyldDbConnection.getSettings().getSchemaOwner().toUpperCase(), tableName, null);
        Vector<TableColumn> schemaCols = new Vector<TableColumn>();
        while (rsTableCols.next()) {
            String colName = rsTableCols.getString("COLUMN_NAME");
            int colSize = rsTableCols.getInt("COLUMN_SIZE");
            String dataType = rsTableCols.getString("TYPE_NAME");
            TableColumn newColumn = new TableColumn();
            newColumn.setName(colName);
            newColumn.setSize(colSize);
            newColumn.setType(dataType);
            schemaCols.add(newColumn);
        }
        return schemaCols;
    }
}

