/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import org.smyld.db.DBConnection;
import org.smyld.db.DBSettings;
import org.smyld.db.mysql.MySQLConstants;

public class SMYLDMySQLConnection
extends DBConnection
implements MySQLConstants {
    private static final long serialVersionUID = 1L;

    public SMYLDMySQLConnection(DBSettings dbSettings) throws Exception {
        super(dbSettings);
        this.init();
    }

    public SMYLDMySQLConnection(Connection DBConnection2) {
        this.dbConnection = DBConnection2;
    }

    public SMYLDMySQLConnection(String newUserName, String newUserPass, String newDBName, String newPort, String newHost) throws Exception {
        super(newUserName, newUserPass, newDBName, newPort, newHost);
        this.init();
    }

    private void init() throws Exception {
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        this.dbConnection = DriverManager.getConnection(this.getDBURL());
        this.connected = this.dbConnection != null;
    }

    public String getDBURL() {
        String lsReturn = "jdbc:mysql://" + this.settings.getHost() + ":" + this.getPortNumber() + "/" + this.settings.getName() + "?user=" + this.settings.getUserName() + "&password=" + this.settings.getUserPassword();
        return lsReturn;
    }

    private String getPortNumber() {
        return this.settings.getPort() != null ? this.settings.getPort() : "3306";
    }
}

