/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.odbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.smyld.db.DBConnection;
import org.smyld.db.DBSettings;

public class SMYLDODBCConnection
extends DBConnection {
    private static final long serialVersionUID = 1L;

    public SMYLDODBCConnection(String newUserName, String newUserPass, String newDBName) {
        super(newUserName, newUserPass, newDBName);
    }

    public SMYLDODBCConnection(String path) {
        this.setConnectionPath(path);
        Properties param = SMYLDODBCConnection.loadDBParams(this.getConnectionPath());
        this.settings = new DBSettings();
        this.settings.setName(param.getProperty("DBNAME"));
        this.settings.setUserName(param.getProperty("UID"));
        this.settings.setUserPassword(param.getProperty("PWD"));
    }

    @Override
    public Connection getConnection() {
        return this.dbConnection;
    }

    @Override
    public synchronized Connection createConnection() throws SQLException {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            this.dbConnection = DriverManager.getConnection(this.getDB_URL());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.dbConnection;
    }

    public String getDB_URL() {
        String myStr = "jdbc:odbc:" + this.settings.getName() + ";UID=" + this.settings.getUserName() + ";PWD=" + this.settings.getUserPassword();
        System.out.println("DBURL:" + myStr);
        return myStr;
    }
}

