/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.smyld.db.oracle.DBChangeListener;

public class DBChangeManager
implements Runnable {
    String targetTable;
    DBChangeListener listener;
    long interval = 0L;
    long timeOut = 0L;
    long startTime = 0L;
    Connection conn;
    boolean active = false;
    boolean timeOutCheck = false;
    PreparedStatement pst;
    HashMap<String, Integer> operationMapper = new HashMap();
    HashMap<String, PreparedStatement> tables = new HashMap();

    public DBChangeManager(Connection dbConnection, long checkInterval) {
        this(dbConnection);
        this.setInterval(checkInterval);
        this.init();
    }

    public DBChangeManager(Connection dbConnection, long checkInterval, long timeOut) {
        this(dbConnection);
        this.timeOut = timeOut;
        this.timeOutCheck = true;
        this.setInterval(checkInterval);
        this.init();
    }

    private void init() {
        this.operationMapper.put("I", 2);
        this.operationMapper.put("U", 3);
        this.operationMapper.put("D", 1);
    }

    public DBChangeManager(Connection dbConnection) {
        this.conn = dbConnection;
    }

    public void addChangeListener(String[] targetTables, DBChangeListener listener) throws SQLException {
        for (String curTable : targetTables) {
            String sql = "Select " + curTable + ".*,versions_operation,VERSIONS_STARTTIME,rowid from " + curTable + " VERSIONS BETWEEN TIMESTAMP systimestamp-interval '" + (float)this.interval / 1000.0f + "' second AND systimestamp where versions_operation is not null order by VERSIONS_STARTTIME";
            this.pst = this.conn.prepareStatement(sql, 1004, 1007, 1);
            this.tables.put(curTable, this.pst);
        }
        this.listener = listener;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void activate() throws SQLException {
        this.active = true;
        if (this.timeOutCheck) {
            this.startTime = System.currentTimeMillis();
        }
        new Thread(this).start();
    }

    public void stop() {
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.active) {
            if (this.timeOutCheck && System.currentTimeMillis() - this.startTime > this.timeOut) {
                this.active = false;
                this.listener.timeOut();
            }
            try {
                HashMap<String, ResultSet> changes = null;
                for (String curTable : this.tables.keySet()) {
                    ResultSet rs = this.tables.get(curTable).executeQuery();
                    if (!rs.next() || this.listener == null) continue;
                    if (changes == null) {
                        changes = new HashMap<String, ResultSet>();
                    }
                    rs.previous();
                    changes.put(curTable, rs);
                }
                if (changes == null) continue;
                this.listener.newChanges(changes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

