/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.oracle;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import org.smyld.db.DBConnection;
import org.smyld.db.DBErrorHandler;
import org.smyld.db.DBIOHandler;

public class OraDBIOHandler
extends DBIOHandler {
    private static final long serialVersionUID = 1L;
    int cashSize;
    int commitSize;
    int commitIdx;

    public OraDBIOHandler(DBErrorHandler e, DBConnection dbConn, int batchSize, int commitValue) {
        super(e, dbConn);
        this.setCashSize(batchSize);
        this.setCommitSize(commitValue);
    }

    public OraDBIOHandler(DBErrorHandler e, DBConnection dbConn) {
        super(e, dbConn);
    }

    private void initilize() {
        try {
            ((OracleConnection)this.smyldDBConnection.getConnection()).setAutoCommit(false);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private void deInitilize() {
        try {
            ((OracleConnection)this.smyldDBConnection.getConnection()).setAutoCommit(true);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void importFile(String dumpKey, String targetTable, String fileName, String separator) throws Exception {
        this.initilize();
        super.importFile(dumpKey, targetTable, fileName, separator);
        this.deInitilize();
    }

    @Override
    protected PreparedStatement prepareStatement(String sql) throws Exception {
        PreparedStatement curStatement = super.prepareStatement(sql);
        ((OraclePreparedStatement)curStatement).setExecuteBatch(this.getCashSize());
        return curStatement;
    }

    public int getCashSize() {
        return this.cashSize;
    }

    public void setCashSize(int cashSize) {
        this.cashSize = cashSize;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    @Override
    public void postLine() throws Exception {
        this.pst.executeUpdate();
        ++this.commitIdx;
        if (this.getCommitSize() != -1 && this.commitIdx >= this.getCommitSize()) {
            this.dbConnection.commit();
            this.commitIdx = 0;
        }
    }
}

