/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.oracle;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;
import org.smyld.db.DBConnection;
import org.smyld.db.DBSettings;
import org.smyld.db.oracle.OracleSqlException;
import org.smyld.db.oracle.SMYLDOraConCashImpl;
import org.smyld.text.TextUtil;

public class SMYLDOracleConnection
extends DBConnection {
    private static final long serialVersionUID = 1L;
    int currentDriver = 1;
    SMYLDOraConCashImpl occim;
    OracleConnectionPoolDataSource ocpds;
    OracleDataSource ods;
    String dbURL;
    OraclePooledConnection pooledConnection;
    Vector<Connection> openedConnections = new Vector();
    boolean poolingConnections;
    public static final String TXT_DRIVER_THIN = "thin";
    public static final String TXT_DRIVER_OCI = "oci";
    public static final String TXT_DRIVER_SERVER = "server";
    public static final String TXT_DRIVER_DEFAULT = "thin";
    public static final int DRIVER_THIN = 1;
    public static final int DRIVER_OCI = 2;
    public static final int DRIVER_SERVER = 3;

    public SMYLDOracleConnection(String path) throws Exception {
        super(path);
        Properties props = SMYLDOracleConnection.loadDBParams(this.getConnectionPath());
        DBSettings newDBSettings = new DBSettings();
        newDBSettings.setHost(props.getProperty("HOST"));
        newDBSettings.setName(props.getProperty("SERVICE"));
        newDBSettings.setUserName(props.getProperty("NAME"));
        newDBSettings.setUserPassword(props.getProperty("PWD"));
        newDBSettings.setPort(props.getProperty("PORT"));
        this.setSettings(newDBSettings);
        this.init();
    }

    public static int getDriverType(DBSettings oraDBSett) {
        if (oraDBSett.getDriver().equals(TXT_DRIVER_SERVER)) {
            return 3;
        }
        if (oraDBSett.getDriver().equals("thin")) {
            return 1;
        }
        return 2;
    }

    public SMYLDOracleConnection(Connection DBConnection2) {
        this.dbConnection = DBConnection2;
    }

    public SMYLDOracleConnection(String newUserName, String newUserPass, String newDBName, String newPort, String newHost) throws Exception {
        super(newUserName, newUserPass, newDBName, newPort, newHost);
        this.init();
    }

    public SMYLDOracleConnection(int driver, String newUserName, String newUserPass, String newDBName, String newPort, String newHost) throws Exception {
        super(newUserName, newUserPass, newDBName, newPort, newHost);
        this.currentDriver = driver;
        this.init();
    }

    public SMYLDOracleConnection(int driver, DBSettings newSettings) throws Exception {
        super(newSettings);
        this.currentDriver = driver;
        this.init();
    }

    public SMYLDOracleConnection(DBSettings newSettings, boolean withPooling) throws Exception {
        super(newSettings);
        this.poolingConnections = withPooling;
        this.currentDriver = newSettings.getDriver() != null ? SMYLDOracleConnection.getDriverType(newSettings) : 1;
        this.init();
    }

    public SMYLDOracleConnection(DBSettings newSettings) throws Exception {
        this(newSettings, false);
    }

    public SMYLDOracleConnection() throws Exception {
        this.init();
    }

    public void setClientID(String connectionClientID) throws SQLException {
        SMYLDOracleConnection.setClientIDValue(this.dbConnection, connectionClientID);
    }

    public void clearClientID() throws SQLException {
        SMYLDOracleConnection.setClientIDValue(this.dbConnection, "");
    }

    public static void setClientIDValue(Connection conn, String value) throws SQLException {
        CallableStatement st = conn.prepareCall("{call SYS.DBMS_SESSION.SET_IDENTIFIER(?)}");
        st.setString(1, value);
        st.executeQuery();
        st.close();
    }

    private void init() throws Exception {
        try {
            switch (this.currentDriver) {
                case 2: {
                    if (!TextUtil.isEmpty((String)this.settings.getID())) {
                        this.dbURL = this.getOCIDBTNSURL();
                        break;
                    }
                    this.dbURL = this.getOCIDBURL();
                    break;
                }
                case 3: {
                    this.dbURL = this.getInternalServerDBURL();
                    break;
                }
                default: {
                    this.dbURL = this.getThinDBURL();
                }
            }
            if (this.poolingConnections) {
                this.ocpds = new OracleConnectionPoolDataSource();
                this.ocpds.setURL(this.dbURL);
                this.ocpds.setUser(this.settings.getUserName());
                this.ocpds.setPassword(this.settings.getUserPassword());
                this.pooledConnection = (OraclePooledConnection)this.ocpds.getPooledConnection();
                this.dbConnection = this.pooledConnection.getConnection();
            } else {
                this.ods = new OracleDataSource();
                this.ods.setURL(this.dbURL);
                this.ods.setUser(this.settings.getUserName());
                this.ods.setPassword(this.settings.getUserPassword());
                this.dbConnection = this.ods.getConnection();
            }
            this.openedConnections.add(this.dbConnection);
            this.connected = true;
        }
        catch (Exception ex) {
            OracleSqlException oraException = new OracleSqlException(ex);
            throw oraException;
        }
    }

    public void setImplicitCachingEnabled(boolean enable) throws SQLException {
        this.ocpds.setImplicitCachingEnabled(enable);
    }

    public void setExplicitCachingEnabled(boolean enable) throws SQLException {
        this.ocpds.setExplicitCachingEnabled(enable);
    }

    @Override
    public void releaseConnections() throws SQLException {
        System.out.println("ocpds.getPooledConnection().close();");
        if (this.pooledConnection != null) {
            this.pooledConnection.close();
        } else {
            for (Connection curConn : this.openedConnections) {
                curConn.close();
            }
        }
    }

    private void handleConnectionErrors(ConnectionEvent cevt) {
        System.out.println("Data base error occured : " + cevt.getSQLException());
        Connection errConn = (Connection)cevt.getSource();
    }

    @Override
    public Connection getConnection() {
        return this.dbConnection;
    }

    @Override
    public synchronized Connection createConnection() throws SQLException {
        Connection newConn = null;
        newConn = this.poolingConnections ? this.ocpds.getPooledConnection().getConnection() : this.ods.getConnection();
        this.openedConnections.add(newConn);
        return newConn;
    }

    @Override
    public Object clone() {
        try {
            return new SMYLDOracleConnection(this.currentDriver, this.settings);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String getDB_URL() {
        String myStr = "jdbc:oracle:thin:" + this.settings.getUserName() + "/" + this.settings.getUserPassword() + "@" + this.settings.getHost() + ":" + this.getPortNumber() + ":" + this.settings.getName();
        return myStr;
    }

    public String getInternalServerDBURL() {
        String lsReturn = "jdbc:oracle:kprb:@" + this.settings.getHost();
        return lsReturn;
    }

    public String getOCIDBURL() {
        String lsReturn = "jdbc:oracle:oci:@(description=(address=(host=" + this.settings.getHost() + ")(protocol=tcp)(port=" + this.getPortNumber() + "))(connect_data=(sid=" + this.settings.getName() + ")(server=DEDICATED)))";
        return lsReturn;
    }

    public String getOCIDBTNSURL() {
        String lsReturn = "jdbc:oracle:oci:@" + this.settings.getID();
        return lsReturn;
    }

    public String getThinDBURL() {
        String myStr = "jdbc:oracle:thin:" + this.settings.getUserName() + "/" + this.settings.getUserPassword() + "@" + this.settings.getHost() + ":" + this.getPortNumber() + ":" + this.settings.getName();
        return myStr;
    }

    private String getPortNumber() {
        return this.settings.getPort() != null ? this.settings.getPort() : "1521";
    }
}

