/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.oracle;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.HashMap;
import org.smyld.SMYLDObject;
import org.smyld.db.DBSettings;
import org.smyld.io.FileSystem;

public class TNSNamesParser
extends SMYLDObject {
    private static final long serialVersionUID = 1L;

    public HashMap<String, DBSettings> parseConnections(String tnsNamesFile) {
        HashMap<String, DBSettings> conns = null;
        String contents = FileSystem.readStringFile((String)tnsNamesFile);
        if (contents != null) {
            conns = new HashMap<String, DBSettings>();
            this.doParse(contents, conns);
        }
        return conns;
    }

    private void doParse(String contents, HashMap<String, DBSettings> conns) {
        LineNumberReader reader = new LineNumberReader(new StringReader(contents));
        String curLine = null;
        StringBuffer buffer = new StringBuffer();
        try {
            while ((curLine = reader.readLine()) != null) {
                if (curLine.trim().length() == 0) {
                    if (!buffer.toString().startsWith("#")) {
                        this.parseConnection(buffer.toString(), conns);
                    }
                    buffer.setLength(0);
                }
                buffer.append(curLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseConnection(String conTxt, HashMap<String, DBSettings> conns) {
        DBSettings newConn = new DBSettings();
        String connName = conTxt.substring(0, conTxt.indexOf("="));
        int startConnection = conTxt.indexOf("=", 0) + 1;
        String host = this.getParam(conTxt, "HOST", startConnection);
        String sid = this.getParam(conTxt, "SID", startConnection);
        if (sid == null) {
            sid = this.getParam(conTxt, "SERVICE_NAME", startConnection);
        }
        String port = this.getParam(conTxt, "PORT", startConnection);
        newConn.setHost(host);
        newConn.setName(sid);
        newConn.setPort(port);
        conns.put(connName, newConn);
    }

    private String getParam(String txt, String name, int fromIndex) {
        int endIndex;
        int startIndex;
        String paramName = name + " = ";
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if ((startIndex = txt.indexOf(paramName, fromIndex)) != -1 && (endIndex = txt.indexOf(")", startIndex += paramName.length())) != -1) {
            return txt.substring(startIndex, endIndex);
        }
        return null;
    }
}

