/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.schema;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Vector;
import org.smyld.db.DBConnection;
import org.smyld.db.DBErrorHandler;
import org.smyld.db.SMYLDDataBaseHandler;
import org.smyld.db.schema.ForeignKey;
import org.smyld.db.schema.PrimaryKey;
import org.smyld.db.schema.ProcedureColumn;
import org.smyld.db.schema.ProceduresPackage;
import org.smyld.db.schema.SchemaObject;
import org.smyld.db.schema.StoredProcedure;
import org.smyld.db.schema.Table;
import org.smyld.db.schema.TableColumn;

public class DBSchemaReader
extends SMYLDDataBaseHandler {
    private static final long serialVersionUID = 1L;
    protected DatabaseMetaData dbMetaData;
    protected HashMap<String, Table> dbTables;
    protected Vector<Object> dbStoredProcedures;
    protected HashMap<String, ProceduresPackage> dbPackages;

    public DBSchemaReader(DBErrorHandler e, DBConnection conn) {
        super(e, conn);
    }

    public void readSchemaTables(HashMap<String, String> tables) throws Exception {
        this.dbMetaData = this.dbConnection.getMetaData();
        String schemaOwner = this.smyldDBConnection.getSettings().getSchemaOwner();
        ResultSet rsTables = this.dbMetaData.getTables(null, schemaOwner, null, null);
        this.dbTables = new HashMap();
        while (rsTables.next()) {
            String curTableName = rsTables.getString("TABLE_NAME");
            if (!tables.containsKey(curTableName)) continue;
            Table newTable = this.createTable();
            newTable.setName(curTableName);
            ResultSet rsTableCols = this.dbMetaData.getColumns(null, schemaOwner, curTableName, null);
            newTable.setCols(this.readCols(rsTableCols));
            ResultSet rsKeyCols = this.dbMetaData.getPrimaryKeys(null, schemaOwner, curTableName);
            newTable.setPrimaryKeys(this.readPKeys(rsKeyCols));
            ResultSet rsIKeys = this.dbMetaData.getImportedKeys(null, schemaOwner, curTableName);
            newTable.setForeignKeys(this.readFKeys(rsIKeys));
            this.dbTables.put(curTableName, newTable);
        }
        rsTables.close();
    }

    protected Table createTable() {
        return new Table();
    }

    private HashMap<String, SchemaObject> readPKeys(ResultSet rsKeyCols) throws Exception {
        HashMap<String, PrimaryKey> keys = null;
        while (rsKeyCols.next()) {
            if (keys == null) {
                keys = new HashMap<String, PrimaryKey>();
            }
            PrimaryKey newKey = new PrimaryKey();
            newKey.setName(rsKeyCols.getString("PK_NAME"));
            newKey.setSequence(rsKeyCols.getInt("KEY_SEQ"));
            newKey.setColumnName(rsKeyCols.getString("COLUMN_NAME"));
            keys.put(newKey.getColumnName(), newKey);
        }
        rsKeyCols.close();
        return keys;
    }

    private HashMap<String, SchemaObject> readFKeys(ResultSet rsKeyCols) throws Exception {
        HashMap<String, ForeignKey> keys = null;
        while (rsKeyCols.next()) {
            if (keys == null) {
                keys = new HashMap<String, ForeignKey>();
            }
            ForeignKey newKey = new ForeignKey();
            newKey.setName(rsKeyCols.getString("FK_NAME"));
            newKey.setTable(rsKeyCols.getString("PKTABLE_NAME"));
            newKey.setColumnName(rsKeyCols.getString("PKCOLUMN_NAME"));
            PrimaryKey ref = new PrimaryKey();
            ref.setColumnName(rsKeyCols.getString("FKCOLUMN_NAME"));
            newKey.setPrimaryKey(ref);
            keys.put(newKey.getName(), newKey);
        }
        rsKeyCols.close();
        return keys;
    }

    private HashMap<String, SchemaObject> readCols(ResultSet rsTableCols) throws Exception {
        HashMap<String, TableColumn> cols = null;
        while (rsTableCols.next()) {
            if (cols == null) {
                cols = new HashMap<String, TableColumn>();
            }
            TableColumn newCol = new TableColumn();
            newCol.setName(rsTableCols.getString("COLUMN_NAME"));
            newCol.setType(rsTableCols.getString("TYPE_NAME"));
            newCol.setSize(rsTableCols.getInt("COLUMN_SIZE"));
            String colNull = rsTableCols.getString("IS_NULLABLE");
            newCol.setNullable("YES".equals(colNull));
            cols.put(newCol.getName(), newCol);
        }
        rsTableCols.close();
        return cols;
    }

    public void readSchemaStoredProcedures(DBConnection conn) throws Exception {
        this.dbMetaData = this.dbConnection.getMetaData();
        ResultSet rs = this.dbMetaData.getProcedures(null, this.smyldDBConnection.getSettings().getSchemaOwner(), null);
        if (this.dbPackages == null) {
            this.dbPackages = new HashMap();
        } else {
            this.dbPackages.clear();
        }
        if (this.dbStoredProcedures == null) {
            this.dbStoredProcedures = new Vector();
        } else {
            this.dbStoredProcedures.removeAllElements();
        }
        ProceduresPackage curPackage = null;
        while (rs.next()) {
            String procPack = rs.getString("PROCEDURE_CAT");
            if (procPack != null) {
                if (this.dbPackages.containsKey(procPack)) {
                    curPackage = this.dbPackages.get(procPack);
                } else {
                    curPackage = new ProceduresPackage();
                    curPackage.setName(procPack);
                    this.dbPackages.put(procPack, curPackage);
                }
                curPackage.addProcedure(this.creatProcedure(rs, procPack));
                continue;
            }
            this.dbStoredProcedures.add((Object)this.creatProcedure(rs, procPack));
        }
        if (this.dbPackages != null && this.dbPackages.size() > 0 && this.dbStoredProcedures != null && this.dbStoredProcedures.size() > 0) {
            this.dbStoredProcedures.addAll(this.dbPackages.values());
        }
    }

    private StoredProcedure creatProcedure(ResultSet rs, String packName) throws Exception {
        StoredProcedure newProcedure = new StoredProcedure();
        newProcedure.setName(rs.getString("PROCEDURE_NAME"));
        newProcedure.setPack(packName);
        ResultSet rsCols = this.dbMetaData.getProcedureColumns(null, this.smyldDBConnection.getSettings().getSchemaOwner(), newProcedure.getName(), null);
        newProcedure.setParams(this.readProcCols(rsCols));
        return newProcedure;
    }

    private HashMap<String, ProcedureColumn> readProcCols(ResultSet rsProcCols) throws Exception {
        HashMap<String, ProcedureColumn> cols = null;
        while (rsProcCols.next()) {
            if (cols == null) {
                cols = new HashMap<String, ProcedureColumn>();
            }
            ProcedureColumn newCol = new ProcedureColumn();
            newCol.setName(rsProcCols.getString("COLUMN_NAME"));
            newCol.setType(rsProcCols.getString("TYPE_NAME"));
            newCol.setDirection(rsProcCols.getInt("COLUMN_TYPE"));
            newCol.setSize(rsProcCols.getInt("LENGTH"));
            String colNull = rsProcCols.getString("NULLABLE");
            newCol.setNullable("1".equals(colNull));
            cols.put(newCol.getName(), newCol);
        }
        rsProcCols.close();
        return cols;
    }

    public HashMap<String, Table> getTables() {
        return this.dbTables;
    }

    public Vector<Object> getStoredProcedures() {
        return this.dbStoredProcedures;
    }
}

