/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.schema;

import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Vector;
import org.smyld.SMYLDObject;
import org.smyld.db.schema.SchemaLog;
import org.smyld.db.schema.Table;

public class SchemaComparator
extends SMYLDObject {
    private static final long serialVersionUID = 1L;
    boolean debug;

    public boolean compare(HashMap<String, Table> origTables, HashMap<String, Table> compTables) throws Exception {
        boolean result = true;
        HashMap<String, Vector<Object>> logs = new HashMap<String, Vector<Object>>();
        if (origTables == null || compTables == null) {
            return false;
        }
        for (String tableName : origTables.keySet()) {
            this.addDebug("Comparing table " + tableName);
            Table compTab = compTables.get(tableName);
            Table origTab = origTables.get(tableName);
            result = origTab.equals(compTab);
            if (result) continue;
            logs.put(tableName, origTab.getCompareLogs());
        }
        System.out.println(logs.size());
        if (logs.size() > 0) {
            this.dumpLogsTo(logs, "d:/temp/schemaCompareResults.txt");
        }
        return result;
    }

    public void dumpLogsTo(HashMap<String, Vector<Object>> logs, String fileName) throws Exception {
        FileOutputStream fout = new FileOutputStream(fileName);
        for (String tableName : logs.keySet()) {
            fout.write(("Table " + tableName + " has the following differences " + OS_NEW_LINE).getBytes());
            Vector<Object> diffLogs = logs.get(tableName);
            for (Object diffObject : diffLogs) {
                if (!(diffObject instanceof SchemaLog)) continue;
                SchemaLog diffItem = (SchemaLog)((Object)diffObject);
                fout.write(("\t" + diffItem.getOriginalObject().getSchemaType() + " " + diffItem.getID() + OS_NEW_LINE).getBytes());
                fout.write(("\t\tOriginal " + diffItem.getOriginalObject().printSchemaData() + OS_NEW_LINE).getBytes());
                fout.write(("\t\tCompared " + diffItem.getComparedObject().printSchemaData() + OS_NEW_LINE).getBytes());
            }
        }
        fout.close();
    }

    private void addDebug(String message) {
        if (this.debug) {
            System.out.println(message);
        }
    }

    public void setDebug(boolean debugActive) {
        this.debug = debugActive;
    }
}

