/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.util.alias;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import org.smyld.db.DBConnectionFactory;
import org.smyld.lang.script.java.JavaInterface;
import org.smyld.text.TextUtil;
import org.smyld.util.alias.AliasClassSettings;
import org.smyld.util.alias.AliasEngineSettings;
import org.smyld.util.alias.AliasGenerator;
import org.smyld.util.alias.AliasSource;
import org.smyld.util.alias.DBAliasGenerator;
import org.smyld.util.alias.DBAliasSource;
import org.smyld.util.alias.DBXMLAliasSettingsReader;
import org.smyld.util.alias.XMLAliasGenerator;
import org.smyld.util.alias.XMLAliasSource;
import org.smyld.util.alias.XMLFieldsAliasGenerator;

public class AliasBuilder {
    AliasEngineSettings engineSett;
    DBConnectionFactory dbConnFactory;
    DBAliasGenerator dbAlGenerator;
    XMLAliasGenerator xmlAlGenerator;
    XMLFieldsAliasGenerator xmlFieldsAliasGenerator;

    public void build(String XMLAliasDocument) {
        try {
            this.dbConnFactory = new DBConnectionFactory();
            DBXMLAliasSettingsReader dbXMLReader = new DBXMLAliasSettingsReader(XMLAliasDocument);
            this.engineSett = dbXMLReader.getEngineSettings();
            this.dbAlGenerator = new DBAliasGenerator(this.engineSett.getClasses());
            this.xmlAlGenerator = new XMLAliasGenerator(this.engineSett.getClasses());
            this.xmlFieldsAliasGenerator = new XMLFieldsAliasGenerator(this.engineSett.getClasses());
            this.doInitObjects();
            this.processAliasSource(this.engineSett.getDbSources(), this.dbAlGenerator);
            this.processAliasSource(this.engineSett.getXmlSources(), this.xmlAlGenerator);
            this.processAliasSource(this.engineSett.getXmlSources(), this.xmlFieldsAliasGenerator);
            this.exportClasses();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processAliasSource(HashMap<String, AliasSource> alSrcs, AliasGenerator generator) throws Exception {
        if (alSrcs != null && alSrcs.size() > 0) {
            for (AliasSource curSource : alSrcs.values()) {
                generator.processSource(curSource, this.engineSett.getAliasSettings());
            }
        }
    }

    private void doInitObjects() throws Exception {
        this.createClasses();
        if (this.engineSett.getDbSources() != null) {
            this.createDBConnections();
        }
        if (this.engineSett.getXmlSources() != null) {
            this.checkXMLSources();
        }
    }

    private boolean isClassReferenced(String className) {
        boolean classReferenced = false;
        if (this.engineSett.getDbSources() != null) {
            for (AliasSource curSource : this.engineSett.getDbSources().values()) {
                classReferenced = curSource.containsTarget(className);
            }
        }
        if (!classReferenced && this.engineSett.getXmlSources() != null) {
            for (AliasSource curSource : this.engineSett.getXmlSources().values()) {
                classReferenced = curSource.containsTarget(className);
            }
        }
        return classReferenced;
    }

    private void createClasses() {
        Iterator<AliasClassSettings> itr = this.engineSett.getClasses().values().iterator();
        while (itr.hasNext()) {
            AliasClassSettings curClass = itr.next();
            if (this.isClassReferenced(curClass.getId())) {
                curClass.ActivateClass();
                this.addShortingsComment(curClass.getActiveClass());
                continue;
            }
            System.out.println("Class ID (" + curClass.getId() + ") is not referenced in the sources ..!");
            itr.remove();
        }
    }

    private void createDBConnections() {
        Iterator<AliasSource> itr = this.engineSett.getDbSources().values().iterator();
        while (itr.hasNext()) {
            DBAliasSource dbSrc = (DBAliasSource)itr.next();
            if (dbSrc.containsTargets()) {
                try {
                    dbSrc.setRs2DBConnection(this.dbConnFactory.createDBConnection(dbSrc.getDbConnSettings()));
                }
                catch (Exception e) {
                    System.out.println("Database source ID (" + dbSrc.getId() + ") connection can not be established ..!");
                    itr.remove();
                }
                continue;
            }
            System.out.println("Database source ID (" + dbSrc.getId() + ") contains no Targets ..!");
            itr.remove();
        }
    }

    private void checkXMLSources() {
        Iterator<AliasSource> itr = this.engineSett.getXmlSources().values().iterator();
        while (itr.hasNext()) {
            XMLAliasSource xmlSrc = (XMLAliasSource)itr.next();
            if (xmlSrc.containsTargets()) {
                if (new File(xmlSrc.getName()).exists()) continue;
                System.out.println("XML source ID (" + xmlSrc.getId() + ") does not exists ..!");
                itr.remove();
                continue;
            }
            System.out.println("XML source ID (" + xmlSrc.getId() + ") contains no Targets ..!");
            itr.remove();
        }
    }

    protected void addShortingsComment(JavaInterface newClass) {
        newClass.addSingleCommentLine(" Shorting word used list : ");
        for (String word : this.engineSett.getAliasSettings().getShortings().keySet()) {
            String shortCut = this.engineSett.getAliasSettings().getShortings().get(word);
            shortCut = TextUtil.fillRightSide((String)shortCut, (int)4, (char)' ');
            newClass.addSingleCommentLine(shortCut + "  :  " + word);
        }
    }

    private void exportClasses() throws Exception {
        for (AliasClassSettings curClass : this.engineSett.getClasses().values()) {
            curClass.exportClass();
        }
    }
}

