/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.util.alias;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.smyld.db.DBSettings;
import org.smyld.util.alias.AliasClassSettings;
import org.smyld.util.alias.AliasEngineSettings;
import org.smyld.util.alias.AliasSettings;
import org.smyld.util.alias.AliasSource;
import org.smyld.util.alias.DBAliasSource;
import org.smyld.util.alias.DBAliasTable;
import org.smyld.util.alias.XMLAliasConstants;
import org.smyld.util.alias.XMLAliasSource;
import org.smyld.xml.XMLUtil;

public class DBXMLAliasSettingsReader
implements XMLAliasConstants {
    AliasEngineSettings engineSettings;
    String curTarget;
    String curSchema;
    Element dbXMLSettings;
    Element application;
    Element buildApplication;
    DBSettings dbSettings;

    public DBXMLAliasSettingsReader(String xmlDocument) throws Exception {
        this.init(xmlDocument);
    }

    public DBSettings loadDBSettings() {
        return this.dbSettings;
    }

    private void init(String xmlDocument) throws Exception {
        Element classes;
        this.engineSettings = new AliasEngineSettings();
        this.application = new SAXBuilder().build(new File(xmlDocument)).getRootElement();
        Element dbAlias = this.application.getChild("alias");
        if (dbAlias != null) {
            this.engineSettings.setAliasSettings(this.doLoadAlias(dbAlias));
        }
        if ((classes = this.getClasses(this.application.getChild("build"))) == null) {
            throw new Exception("No target classes available ... ");
        }
        this.engineSettings.setClasses(this.doLoadClasses(classes));
        Element sources = this.application.getChild("sources");
        if (sources != null) {
            boolean sourcesAvailable = true;
            Element xmlSources = sources.getChild("xml");
            if (xmlSources != null) {
                this.engineSettings.setXmlSources(this.doLoadXMLSources(xmlSources));
            } else {
                sourcesAvailable = false;
            }
            Element dbSources = sources.getChild("db");
            if (dbSources != null) {
                this.engineSettings.setDbSources(this.doLoadDBSources(dbSources));
            } else if (!sourcesAvailable) {
                throw new Exception("No sources available ... ");
            }
        } else {
            throw new Exception("No sources available ... ");
        }
    }

    private Element getClasses(Element build) {
        Element classes;
        if (build != null && (classes = build.getChild("classes")) != null) {
            return classes;
        }
        return null;
    }

    private AliasSettings doLoadAlias(Element al) {
        HashMap<String, String> prefixes = new HashMap<String, String>(4);
        AliasSettings newSett = new AliasSettings();
        Element prefix = al.getChild("prefix");
        if (prefix != null) {
            prefixes.put("table", XMLUtil.getChildValue((Element)prefix, (String)"table"));
            prefixes.put("column", XMLUtil.getChildValue((Element)prefix, (String)"column"));
            prefixes.put("tag", XMLUtil.getChildValue((Element)prefix, (String)"tag"));
            prefixes.put("attribute", XMLUtil.getChildValue((Element)prefix, (String)"attribute"));
            newSett.setPrefixes(prefixes);
        }
        newSett.setNameSeparator(XMLUtil.getChildValue((Element)al, (String)"nameseparator"));
        Element shortings = al.getChild("shortings");
        if (shortings != null) {
            newSett.setShortings(this.loadShortings(shortings));
        }
        return newSett;
    }

    private HashMap<String, String> loadShortings(Element shortingsNode) {
        HashMap<String, String> shortings = new HashMap<String, String>();
        for (Element curSHorting : shortingsNode.getChildren()) {
            String curWord = curSHorting.getChild("word").getText();
            String curShort = curSHorting.getChild("short").getText();
            shortings.put(curWord, curShort);
        }
        return shortings;
    }

    private HashMap<String, AliasClassSettings> doLoadClasses(Element classes) {
        HashMap<String, AliasClassSettings> newClasses = new HashMap<String, AliasClassSettings>();
        List clsList = classes.getChildren("class");
        for (Element curClass : clsList) {
            AliasClassSettings newClass = this.loadClass(curClass);
            if (newClass == null) continue;
            newClasses.put(newClass.getId(), newClass);
        }
        return newClasses;
    }

    private AliasClassSettings loadClass(Element cls) {
        AliasClassSettings newClass = new AliasClassSettings();
        newClass.setId(cls.getAttributeValue("id"));
        newClass.setName(XMLUtil.getChildValue((Element)cls, (String)"name"));
        newClass.setClassPackage(XMLUtil.getChildValue((Element)cls, (String)"package"));
        newClass.setClassPath(XMLUtil.getChildValue((Element)cls, (String)"path"));
        return newClass;
    }

    private void loadTargets(Element srcEl, AliasSource src) {
        List trgts = srcEl.getChildren("target");
        if (trgts != null && trgts.size() > 0) {
            Iterator itr = trgts.iterator();
            while (itr.hasNext()) {
                String newTarget = ((Element)itr.next()).getText();
                src.addClass(newTarget);
            }
        }
    }

    private HashMap<String, AliasSource> doLoadXMLSources(Element xmls) {
        HashMap<String, AliasSource> xmlSrcs = new HashMap<String, AliasSource>();
        List srcs = xmls.getChildren("source");
        for (Element curSrc : srcs) {
            XMLAliasSource newXMLSrc = this.loadXMLSource(curSrc);
            if (newXMLSrc != null) {
                xmlSrcs.put(newXMLSrc.getId(), newXMLSrc);
            }
            this.loadTargets(curSrc, newXMLSrc);
        }
        return xmlSrcs;
    }

    private XMLAliasSource loadXMLSource(Element xmlSrc) {
        XMLAliasSource newSrc = new XMLAliasSource();
        newSrc.setId(xmlSrc.getAttributeValue("id"));
        String schemaType = xmlSrc.getAttributeValue("schematype");
        newSrc.setSchemaType(1);
        if (schemaType != null && schemaType.toLowerCase().equals("fields")) {
            newSrc.setSchemaType(2);
        }
        newSrc.setTarget(XMLUtil.getChildValue((Element)xmlSrc, (String)"target"));
        newSrc.setName(XMLUtil.getChildValue((Element)xmlSrc, (String)"srcFile"));
        return newSrc;
    }

    private HashMap<String, AliasSource> doLoadDBSources(Element srcs) {
        HashMap<String, AliasSource> dbSrces = new HashMap<String, AliasSource>();
        List srcsList = srcs.getChildren("source");
        for (Element curSrc : srcsList) {
            DBAliasSource newDBSrc = this.loadDBSource(curSrc);
            if (newDBSrc != null) {
                dbSrces.put(newDBSrc.getId(), newDBSrc);
            }
            this.loadTargets(curSrc, newDBSrc);
        }
        return dbSrces;
    }

    private DBAliasSource loadDBSource(Element src) {
        DBAliasSource newDB = new DBAliasSource();
        newDB.setDbConnSettings(this.loadConnection(src.getChild("dbconnection")));
        newDB.setId(src.getAttributeValue("id"));
        newDB.setTables(this.loadTables(src.getChild("tables")));
        newDB.fillSchemas();
        return newDB;
    }

    private DBSettings loadConnection(Element conn) {
        DBSettings dbSettings = new DBSettings();
        dbSettings.setHost(conn.getChild("host").getText());
        dbSettings.setVendor(XMLUtil.getChildValue((Element)conn, (String)"vendor"));
        dbSettings.setName(conn.getChild("name").getText());
        dbSettings.setPort(conn.getChild("port").getText());
        dbSettings.setUserName(conn.getChild("username").getText());
        dbSettings.setUserPassword(conn.getChild("userpass").getText());
        return dbSettings;
    }

    private HashMap<String, DBAliasTable> loadTables(Element tables) {
        HashMap<String, DBAliasTable> tabls = new HashMap<String, DBAliasTable>();
        List schemasList = tables.getChildren("schema");
        for (Element curSchemaEl : schemasList) {
            this.curSchema = curSchemaEl.getAttributeValue("name").toLowerCase();
            if (curSchemaEl.getAttributeValue("target") != null) {
                this.curTarget = curSchemaEl.getAttributeValue("target");
            }
            tabls = this.loadTableNames(curSchemaEl, tabls);
        }
        return tabls;
    }

    private HashMap<String, DBAliasTable> loadTableNames(Element tablesNode, HashMap<String, DBAliasTable> tabls) {
        Iterator itr = tablesNode.getChildren().iterator();
        while (itr.hasNext()) {
            DBAliasTable newTable = new DBAliasTable();
            Element curTable = (Element)itr.next();
            String curTableName = curTable.getText().toLowerCase();
            if (curTable.getAttributeValue("target") != null) {
                newTable.setTarget(curTable.getAttributeValue("target"));
            } else {
                newTable.setTarget(this.curTarget);
            }
            newTable.setName(curTableName);
            newTable.setSchema(this.curSchema);
            tabls.put(newTable.createKey(), newTable);
        }
        return tabls;
    }

    public AliasEngineSettings getEngineSettings() {
        return this.engineSettings;
    }

    public void setEngineSettings(AliasEngineSettings engineSettings) {
        this.engineSettings = engineSettings;
    }
}

