/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.util.alias;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.smyld.util.alias.AliasClassSettings;
import org.smyld.util.alias.AliasGenerator;
import org.smyld.util.alias.AliasSettings;
import org.smyld.util.alias.AliasSource;
import org.smyld.util.alias.XMLAliasSource;
import org.smyld.xml.XMLUtil;

public class XMLAliasGenerator
extends AliasGenerator {
    private static final long serialVersionUID = 1L;
    String tagPrefix;
    String attPrefix;

    public XMLAliasGenerator(HashMap<String, AliasClassSettings> classes) {
        super(classes);
    }

    @Override
    public void processSource(AliasSource alSrc, AliasSettings alSettings) throws Exception {
        super.processSource(alSrc, alSettings);
        XMLAliasSource xmlSrc = (XMLAliasSource)alSrc;
        if (xmlSrc.getSchemaType() == 1) {
            Element root = XMLUtil.getRootNode((String)xmlSrc.getName());
            this.tagPrefix = alSettings.getPrefixes().get("tag");
            this.attPrefix = alSettings.getPrefixes().get("attribute");
            this.addComment(" ******************************** Constants XML source from \"" + xmlSrc.getName() + "\" file  ******************************** ");
            this.processTag(root);
        }
    }

    private void processTag(Element newTag) {
        String newTagName = this.addXMLElement(null, newTag.getName(), this.tagPrefix);
        List atts = newTag.getAttributes();
        if (atts != null && atts.size() > 0) {
            Iterator attItr = atts.iterator();
            while (attItr.hasNext()) {
                this.addXMLElement(newTagName, ((Attribute)attItr.next()).getName(), this.attPrefix);
            }
        }
        if (XMLUtil.hasChildren((Element)newTag)) {
            Iterator childItr = newTag.getChildren().iterator();
            while (childItr.hasNext()) {
                this.processTag((Element)childItr.next());
            }
        }
    }

    private String addXMLElement(String parentEl, String newEl, String prefix) {
        String newTagName = this.convertName(newEl);
        if (parentEl != null) {
            this.addConstant(prefix + this.settings.getNameSeparator() + parentEl + this.settings.getNameSeparator() + newTagName, newEl);
        } else {
            this.addConstant(prefix + this.settings.getNameSeparator() + newTagName, newEl);
        }
        return newTagName;
    }
}

