/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.util.multilang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.smyld.SMYLDObject;
import org.smyld.db.DBConnection;
import org.smyld.util.Translator;
import org.smyld.util.multilang.LangNotFoundException;
import org.smyld.util.multilang.MultiLangConstants;
import org.smyld.xml.XMLUtil;

public class MultiLangSource
extends SMYLDObject
implements MultiLangConstants {
    private static final long serialVersionUID = 1L;
    boolean xmlSource = false;
    DBConnection dbConnection;
    Element rootElement;

    public MultiLangSource(String xmlSourceFile) throws IOException, JDOMException {
        this(new File(xmlSourceFile));
    }

    public MultiLangSource(File xmlSourceFile) throws IOException, JDOMException {
        this.xmlSource = true;
        this.rootElement = XMLUtil.getRootNode((File)xmlSourceFile);
    }

    public MultiLangSource(InputStream xmlSourceStream) throws IOException, JDOMException {
        this.xmlSource = true;
        this.rootElement = XMLUtil.getRootNode((InputStream)xmlSourceStream);
    }

    public MultiLangSource(URL xmlURL) throws IOException, JDOMException {
        this.xmlSource = true;
        this.rootElement = XMLUtil.getRootNode((URL)xmlURL);
    }

    public MultiLangSource(DBConnection dbSourceConnection) throws Exception {
        this.dbConnection = dbSourceConnection;
    }

    public Translator loadLanguage(String language) throws LangNotFoundException {
        if (this.xmlSource) {
            return this.loadXMLLanguage(language);
        }
        return this.loadDBLanguage(language);
    }

    private Translator loadDBLanguage(String language) throws LangNotFoundException {
        return null;
    }

    private Translator loadXMLLanguage(String language) throws LangNotFoundException {
        List langs = this.rootElement.getChildren("language");
        for (Element curElement : langs) {
            if (!language.equals(curElement.getAttributeValue("name"))) continue;
            return this.buildXML(curElement);
        }
        throw new LangNotFoundException(language);
    }

    private HashMap<String, Translator> loadXMLLanguages() {
        HashMap<String, Translator> result = null;
        List langs = this.rootElement.getChildren("language");
        Iterator itr = langs.iterator();
        if (langs.size() > 0) {
            result = new HashMap<String, Translator>();
        }
        while (itr.hasNext()) {
            Element curElement = (Element)itr.next();
            Translator newTranslator = this.buildXML(curElement);
            if (newTranslator == null) continue;
            result.put(newTranslator.getLanguage(), newTranslator);
        }
        return result;
    }

    private Translator buildXML(Element langaugeElement) {
        Translator newTranslator = null;
        String language = langaugeElement.getAttributeValue("name");
        List words = langaugeElement.getChildren("word");
        if (words.size() > 0) {
            newTranslator = new Translator(language);
        }
        for (Element currentWord : words) {
            String wordID = currentWord.getAttributeValue("id");
            String wordMOD = currentWord.getAttributeValue("module");
            String wordText = currentWord.getAttributeValue("translate");
            newTranslator.addWord(wordMOD, wordID, wordText);
        }
        return newTranslator;
    }

    public HashMap<String, Translator> loadLanguages() {
        if (this.xmlSource) {
            return this.loadXMLLanguages();
        }
        return null;
    }
}

