/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db;

import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.smyld.SMYLDObject;
import org.smyld.db.DBConnection;
import org.smyld.db.DBConnectionListener;
import org.smyld.db.DBConstants;
import org.smyld.db.DBErrorHandler;
import org.smyld.db.SMYLDDBUtility;
import org.smyld.db.Utility;
import org.smyld.db.oracle.SMYLDOracleConnection;

public class SMYLDDataBaseHandler
extends SMYLDObject
implements DBConstants {
    private static final long serialVersionUID = 1L;
    protected Connection dbConnection = null;
    protected DBConnection smyldDBConnection;
    protected SMYLDDBUtility dbUtility = null;
    private DBErrorHandler handler;
    public static final String DB_VAL_NoParentFieldValue = "0";
    public static final int DB_SEQUENTIAL_NO_WIDTH = 11;

    public SMYLDDataBaseHandler(DBErrorHandler e) {
        this.init(e, null);
    }

    public SMYLDDataBaseHandler(DBErrorHandler e, DBConnection connection) {
        try {
            this.smyldDBConnection = connection;
            this.dbConnection = this.smyldDBConnection.getConnection();
            this.smyldDBConnection.addInternalDBConnectionListener(new DBConnectionListener(){

                @Override
                public void connectionClosed() {
                }

                @Override
                public void connectionResumed(DBConnection newConnection) {
                    SMYLDDataBaseHandler.this.setSMYLDConnection(newConnection);
                }
            });
            this.init(e, connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SMYLDDataBaseHandler(DBErrorHandler e, String userName, String userPassword, String host, String port, String dbname) {
        try {
            this.smyldDBConnection = new SMYLDOracleConnection(userName, userPassword, dbname, port, host);
            this.dbConnection = this.smyldDBConnection.getConnection();
            this.init(e, this.smyldDBConnection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SMYLDDataBaseHandler(int driver, DBErrorHandler e, String userName, String userPassword, String host, String port, String dbname) {
        try {
            this.smyldDBConnection = new SMYLDOracleConnection(driver, userName, userPassword, dbname, port, host);
            this.dbConnection = this.smyldDBConnection.getConnection();
            this.init(e, this.smyldDBConnection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void init(DBErrorHandler e, DBConnection activeDBConnection) {
        try {
            if (this.dbUtility == null && activeDBConnection != null) {
                this.dbUtility = new SMYLDDBUtility(activeDBConnection, e, this, true);
                this.setDBConnection(activeDBConnection);
            }
        }
        catch (Exception ex) {
            this.dbUtility.handleDBError(ex);
            ex.printStackTrace();
        }
    }

    public void setSMYLDConnection(DBConnection newActiveConnection) {
        this.smyldDBConnection = newActiveConnection;
        this.dbConnection = this.smyldDBConnection.getConnection();
        this.dbUtility.setSMYLDConnection(newActiveConnection);
    }

    public Utility getUtility() {
        return this.dbUtility;
    }

    public boolean isConnected() {
        return this.smyldDBConnection.isConnected();
    }

    public DBConnection getSMYLDConnection() {
        return this.smyldDBConnection;
    }

    public void closeConnection() throws SQLException {
        this.dbConnection.close();
    }

    public synchronized void doCommit() {
        try {
            this.dbConnection.commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void doRollBack() {
        try {
            this.dbConnection.rollback();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addDBConnectionListener(DBConnectionListener newConnectionListener) {
        this.smyldDBConnection.addDBConnectionListener(newConnectionListener);
    }

    public void addDBConnectionListener(DBConnectionListener newConnectionListener, int priorty) {
        this.smyldDBConnection.addDBConnectionListener(newConnectionListener, priorty);
    }

    public synchronized void executeDoubleParamFunction(String function, String param1, String param2) {
        this.dbUtility.executeDoubleParamFunction(function, param1, param2);
    }

    public synchronized void executeDoubleParamFunction(String function, int param1, int param2) {
        this.dbUtility.executeDoubleParamFunction(function, param1, param2);
    }

    public synchronized void executeTrippleParamFunction(String function, String param1, String param2, String param3) {
        this.dbUtility.executeTrippleParamFunction(function, param1, param2, param3);
    }

    public synchronized void executeDoubleParamProcedure(String procedure, int param1, int param2) {
        this.dbUtility.executeDoubleParamProcedure(procedure, param1, param2);
    }

    public synchronized void executeTrippleParamProcedure(String procedure, String param1, int param2, int param3) {
        this.dbUtility.executeTrippleParamProcedure(procedure, param1, param2, param3);
    }

    public synchronized Array executeSingleParamOraArrayFun(String function, String arrayTypeName, int param1) {
        return this.dbUtility.executeSingleParamArrayFunction(function, arrayTypeName, param1);
    }

    public synchronized void executeMultiParamProcedure(String procedureName, String[] params) {
        this.dbUtility.executeMultiParamProcedure(procedureName, params);
    }

    protected synchronized ResultSet executeQuery(String sql) {
        return this.dbUtility.executeQuery(sql);
    }

    public void setDBConnection(DBConnection newActiveDBConnection) {
        this.smyldDBConnection = newActiveDBConnection;
    }

    protected synchronized void handleDBError(Exception ex) {
        this.dbUtility.handleDBError(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTableTotalRecordsNumber(String tableName) {
        int recNo = 0;
        ResultSet rs = this.dbUtility.executeQuery("select count(rownum) from " + tableName);
        try {
            if (rs.next()) {
                recNo = rs.getInt(1);
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.dbUtility.closeCursor(rs);
        }
        return recNo;
    }
}

