/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.oracle;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.sql.ARRAY;
import oracle.sql.StructDescriptor;
import org.smyld.db.DBConnection;
import org.smyld.db.DBErrorHandler;
import org.smyld.db.SMYLDSQLException;
import org.smyld.db.Utility;
import org.smyld.db.oracle.OraConstants;
import org.smyld.db.oracle.OracleSqlException;
import org.smyld.db.schema.Table;
import org.smyld.db.schema.TableColumn;

public class OracleDBUtil
extends Utility
implements OraConstants {
    public OracleDBUtil(DBConnection activeConnection, DBErrorHandler handler) {
        super(activeConnection, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ARRAY executeSingleParamArrayFunction(String function, String arrayTypeName, int param1) {
        ARRAY aRRAY;
        CallableStatement cstmt = null;
        try {
            ARRAY resultantArray;
            cstmt = this.dbConnection.prepareCall(OracleDBUtil.constructDoubleParamProcedureCall(function));
            if (arrayTypeName != null) {
                cstmt.registerOutParameter(2, 2003, arrayTypeName);
            } else {
                cstmt.registerOutParameter(2, 2003);
            }
            cstmt.setInt(1, param1);
            cstmt.execute();
            aRRAY = resultantArray = (ARRAY)cstmt.getArray(2);
        }
        catch (Exception ex) {
            try {
                this.handleDBError(ex);
            }
            catch (Throwable throwable) {
                this.closeCursor(cstmt);
                throw throwable;
            }
            this.closeCursor(cstmt);
            return null;
        }
        this.closeCursor(cstmt);
        return aRRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ARRAY executeSingleParamProcedure(String procedure, String paramValue, int paramNo) {
        ARRAY aRRAY;
        CallableStatement cstmt = null;
        try {
            ARRAY resultantArray;
            cstmt = this.dbConnection.prepareCall(OracleDBUtil.constructDoubleParamProcedureCall(procedure));
            cstmt.registerOutParameter(2, 2003);
            cstmt.setInt(1, paramNo);
            cstmt.execute();
            aRRAY = resultantArray = (ARRAY)cstmt.getArray(2);
        }
        catch (Exception ex) {
            try {
                this.handleDBError(ex);
            }
            catch (Throwable throwable) {
                this.closeCursor(cstmt);
                throw throwable;
            }
            this.closeCursor(cstmt);
            return null;
        }
        this.closeCursor(cstmt);
        return aRRAY;
    }

    @Override
    public Connection getConnection() {
        return this.dbConnection;
    }

    public StructDescriptor getStructDescriptor(String structTypeName) {
        try {
            return StructDescriptor.createDescriptor((String)structTypeName, (Connection)this.dbConnection);
        }
        catch (Exception ex) {
            this.handleDBError(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSingleParamFunctionStringReturnString(String function, String param1) {
        String result = null;
        CallableStatement cstmt = null;
        try {
            cstmt = this.dbConnection.prepareCall(OracleDBUtil.constructSingleParamFunctionCall(function));
            cstmt.registerOutParameter(1, 12);
            cstmt.setString(2, param1);
            cstmt.execute();
            result = cstmt.getString(1);
        }
        catch (Exception ex) {
            try {
                this.handler.addError(ex, this.dbConnection);
            }
            catch (Throwable throwable) {
                this.closeCursor(cstmt);
                throw throwable;
            }
            this.closeCursor(cstmt);
        }
        this.closeCursor(cstmt);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDoubleParamFunctionStringReturnString(String function, String param1, String param2) {
        String result = null;
        CallableStatement cstmt = null;
        try {
            cstmt = this.dbConnection.prepareCall(OracleDBUtil.constructDoubleParamFunctionCall(function));
            cstmt.registerOutParameter(1, 12);
            cstmt.setString(2, param1);
            cstmt.setString(3, param2);
            cstmt.execute();
            result = cstmt.getString(1);
        }
        catch (Exception ex) {
            try {
                this.handler.addError(ex, this.dbConnection);
            }
            catch (Throwable throwable) {
                this.closeCursor(cstmt);
                throw throwable;
            }
            this.closeCursor(cstmt);
        }
        this.closeCursor(cstmt);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSingleParamFunctionString(String function, String param1) {
        String result = null;
        CallableStatement cstmt = null;
        try {
            cstmt = this.dbConnection.prepareCall(OracleDBUtil.constructSingleParamFunctionCall(function));
            cstmt.registerOutParameter(1, 4);
            cstmt.setString(2, param1);
            cstmt.execute();
            result = cstmt.getString(1);
        }
        catch (Exception ex) {
            try {
                this.handler.addError(ex, this.dbConnection);
            }
            catch (Throwable throwable) {
                this.closeCursor(cstmt);
                throw throwable;
            }
            this.closeCursor(cstmt);
        }
        this.closeCursor(cstmt);
        return result;
    }

    public SMYLDSQLException parseSqlException(SQLException ex) {
        return new OracleSqlException(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> getTablesContainingFieldName(String fieldName) {
        ResultSet rs = null;
        HashMap<Object, Object> tables = new HashMap<Object, Object>();
        try {
            Object currentTableName;
            while (rs.next()) {
                currentTableName = rs.getString(1);
                tables.put(currentTableName, currentTableName);
            }
            currentTableName = tables;
            return currentTableName;
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.closeCursor(rs);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Table> getTablesContainingFieldNames(String[] fieldNames) {
        ResultSet rs = null;
        HashMap<String, Table> tables = new HashMap<String, Table>();
        try {
            for (String curField : fieldNames) {
                while (rs.next()) {
                    String currentTableName = rs.getString(1);
                    Table curTable = tables.get(currentTableName);
                    if (curTable == null) {
                        curTable = new Table();
                        curTable.setName(currentTableName);
                    }
                    TableColumn newField = new TableColumn();
                    newField.setName(curField);
                    curTable.addColumn(newField);
                    tables.put(currentTableName, curTable);
                }
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.closeCursor(rs);
        }
        return tables;
    }

    public String getOracleDirectory(String directoryName) {
        return this.getSingleParamSQLData(directoryName, "Select * from DBA_DIRECTORIES Where DIRECTORY_NAME=?", "DIRECTORY_PATH");
    }

    public static void main(String[] args) {
        try {
            DBConnection conn = new DBConnection("bw3", "bw3data", "smyldbw", "1521", "192.168.12.180");
            OracleDBUtil instance = new OracleDBUtil(conn, new DBErrorHandler(){

                @Override
                public boolean addError(Exception e, Connection c) {
                    e.printStackTrace();
                    return true;
                }
            });
            String[] cols = new String[]{"CARD_NUMBER", "PARENT_CARD_NUMBER"};
            HashMap<String, Table> result = instance.getTablesContainingFieldNames(cols);
            for (Table curTable : result.values()) {
                System.out.println("=============================================");
                System.out.println(curTable.getName() + " : contains (" + curTable.getCols().size() + ") col(s) ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

