/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.schema;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.smyld.SMYLDObject;
import org.smyld.db.DBConnection;
import org.smyld.db.schema.DBSchemaReader;
import org.smyld.db.schema.SchemaComparator;
import org.smyld.db.schema.Table;
import org.smyld.db.schema.XMLSchemaReader;
import org.smyld.db.schema.XMLSchemaWriter;

public class DBSchemaHandler
extends SMYLDObject {
    private static final long serialVersionUID = 1L;
    DBConnection dbConn;
    DatabaseMetaData dbMetaData;
    FileOutputStream fout;
    boolean debug;

    public DBSchemaHandler(DBConnection conn) {
        this.dbConn = conn;
    }

    public void generateXMLSchemaDocument(HashMap<String, String> tables, String targetFileName) throws Exception {
        this.generateXMLSchemaDocument(tables, new FileOutputStream(targetFileName));
    }

    public void generateXMLSchemaDocument(HashMap<String, String> tables, OutputStream out) throws Exception {
        DBSchemaReader reader = new DBSchemaReader(null, this.dbConn);
        XMLSchemaWriter writer = new XMLSchemaWriter();
        reader.readSchemaTables(tables);
        HashMap<String, Table> dbTables = reader.getTables();
        if (tables != null && tables.size() > 0) {
            writer.setTables(dbTables);
            writer.writeFileToStream(out);
        }
    }

    public boolean compare(HashMap<String, String> tables, String xmlFileName) throws Exception {
        XMLSchemaReader xmlReader = new XMLSchemaReader();
        DBSchemaReader dbReader = new DBSchemaReader(null, this.dbConn);
        xmlReader.readSchemaTables(xmlFileName);
        dbReader.readSchemaTables(tables);
        SchemaComparator comparator = new SchemaComparator();
        comparator.setDebug(this.isDebug());
        return comparator.compare(xmlReader.getTables(), dbReader.getTables());
    }

    public void generateSchemaDocument(HashMap<String, String> tables, String targetFileName) throws Exception {
        this.fout = new FileOutputStream("d:/temp/dbSchema.txt");
        this.dbMetaData = this.dbConn.getConnection().getMetaData();
        ResultSet rsCatalogs = this.dbMetaData.getTables(null, this.dbConn.getSettings().getSchemaOwner(), null, null);
        while (rsCatalogs.next()) {
            String curTableName = rsCatalogs.getString("TABLE_NAME");
            if (!tables.containsKey(curTableName)) continue;
            this.addLine("create table " + curTableName + "(");
            ResultSet rsTableCols = this.dbMetaData.getColumns(null, this.dbConn.getSettings().getSchemaOwner(), curTableName, null);
            this.printCols(rsTableCols);
            ResultSet rsKeyCols = this.dbMetaData.getPrimaryKeys(null, this.dbConn.getSettings().getSchemaOwner(), curTableName);
            this.printKeys(rsKeyCols);
            ResultSet rsIKeys = this.dbMetaData.getImportedKeys(null, this.dbConn.getSettings().getSchemaOwner(), curTableName);
            this.printFKeys(rsIKeys);
            this.addLine(")");
        }
        rsCatalogs.close();
    }

    private void printKeys(ResultSet rsKeyCols) throws Exception {
        StringBuffer buffer = new StringBuffer();
        String pkName = null;
        Vector<String> keys = new Vector<String>(0);
        while (rsKeyCols.next()) {
            String keyName = rsKeyCols.getString("COLUMN_NAME");
            int keySeq = rsKeyCols.getInt("KEY_SEQ");
            pkName = rsKeyCols.getString("PK_NAME");
            if (keySeq > keys.size()) {
                keys.setSize(keySeq);
            }
            keys.add(keySeq, keyName);
        }
        buffer.append("\t\tconstraint ");
        buffer.append(pkName);
        buffer.append(" primary key (");
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String curKey = (String)itr.next();
            if (curKey == null) continue;
            buffer.append(curKey);
            if (!itr.hasNext()) continue;
            buffer.append(",");
        }
        buffer.append("),");
        this.addLine(buffer.toString());
        rsKeyCols.close();
    }

    private void printFKeys(ResultSet rsKeyCols) throws Exception {
        while (rsKeyCols.next()) {
            String keyName = rsKeyCols.getString("PKCOLUMN_NAME");
            String keyF = rsKeyCols.getString("FKCOLUMN_NAME");
            String tableF = rsKeyCols.getString("PKTABLE_NAME");
            String fkName = rsKeyCols.getString("FK_NAME");
            this.addLine("\t\tconstraint " + fkName + " foreign key (" + keyF + ") reference " + tableF + "(" + keyName + "),");
        }
        rsKeyCols.close();
    }

    private void printCols(ResultSet rsTableCols) throws Exception {
        while (rsTableCols.next()) {
            String colName = rsTableCols.getString("COLUMN_NAME");
            String colType = rsTableCols.getString("TYPE_NAME");
            String colSize = rsTableCols.getString("COLUMN_SIZE");
            String colNull = rsTableCols.getString("IS_NULLABLE");
            colNull = "NO".equals(colNull) ? "\t\tnot null" : "";
            this.addLine("\t" + colName + "\t" + colType + "(" + colSize + ")" + colNull + ",");
        }
        rsTableCols.close();
    }

    private void printall(ResultSet rs) throws Exception {
        ResultSetMetaData meta = rs.getMetaData();
        while (rs.next()) {
            for (int i = 1; i < meta.getColumnCount() + 1; ++i) {
                System.out.print(rs.getString(i) + ",");
            }
            System.out.println("");
        }
    }

    private void printRSMeta(ResultSetMetaData meta) throws Exception {
        int size = meta.getColumnCount();
        for (int i = 1; i < size + 1; ++i) {
            System.out.println(meta.getColumnName(i));
        }
    }

    private void printSchemas(ResultSet rs) throws Exception {
        while (rs.next()) {
            System.out.println(rs.getString("TABLE_SCHEM"));
        }
    }

    private void printProcedures(ResultSet rs) throws Exception {
        this.addLine("Procedures details :");
        String lastPack = null;
        while (rs.next()) {
            String procPack = rs.getString("PROCEDURE_CAT");
            String procName = rs.getString("PROCEDURE_NAME");
            if (lastPack == null && procPack != null) {
                lastPack = procPack;
            } else if (lastPack != null && !lastPack.equals(procPack)) {
                this.addLine("\tPackage (" + procPack + ") : ");
                lastPack = procPack;
            }
            if (procPack == null) continue;
            this.addLine("\t\tProcedure (" + procName + ")");
        }
    }

    private void addLine(String line) throws Exception {
        this.fout.write((line + OS_NEW_LINE).getBytes());
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

