/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.util.alias;

import java.util.HashMap;
import org.smyld.SMYLDObject;
import org.smyld.lang.script.java.JavaVariable;
import org.smyld.lang.script.util.Variable;
import org.smyld.text.TextTokenizer;
import org.smyld.util.alias.AliasClassSettings;
import org.smyld.util.alias.AliasSettings;
import org.smyld.util.alias.AliasSource;
import org.smyld.util.alias.XMLAliasConstants;

public class AliasGenerator
extends SMYLDObject
implements XMLAliasConstants {
    private static final long serialVersionUID = 1L;
    StringBuffer buffer = new StringBuffer();
    AliasSettings settings;
    AliasSource alSource;
    HashMap<String, AliasClassSettings> classes;

    public AliasGenerator(HashMap<String, AliasClassSettings> classes) {
        this.classes = classes;
    }

    public void processSource(AliasSource alSrc, AliasSettings alSettings) throws Exception {
        this.alSource = alSrc;
        this.settings = alSettings;
    }

    protected String convertName(String curName) {
        this.buffer.setLength(0);
        TextTokenizer tockenz = new TextTokenizer(curName, this.settings.getNameSeparator());
        String[] nameParts = tockenz.parseTokens();
        for (int i = 0; i < nameParts.length; ++i) {
            if (this.settings.getShortings().containsKey(nameParts[i])) {
                nameParts[i] = this.settings.getShortings().get(nameParts[i]);
            }
            this.buffer.append(nameParts[i]);
            if (i >= nameParts.length - 1) continue;
            this.buffer.append(this.settings.getNameSeparator());
        }
        return this.buffer.toString().toUpperCase();
    }

    protected void addConstant(String constName, String constValue) {
        for (String classID : this.alSource.classRef.keySet()) {
            AliasClassSettings curClass = this.classes.get(classID);
            JavaVariable newTableVariable = new JavaVariable(constName, "public", "String", "\"" + constValue + "\"");
            newTableVariable.addModifier("final");
            newTableVariable.addModifier("static");
            curClass.getActiveClass().addVariable((Variable)newTableVariable);
        }
    }

    protected void addComment(String comment) {
        for (String classID : this.alSource.classRef.keySet()) {
            AliasClassSettings curClass = this.classes.get(classID);
            curClass.getActiveClass().addSingleCommentLine(comment);
        }
    }
}

