/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.util.alias;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.HashMap;
import org.smyld.util.alias.AliasClassSettings;
import org.smyld.util.alias.AliasGenerator;
import org.smyld.util.alias.AliasSettings;
import org.smyld.util.alias.AliasSource;
import org.smyld.util.alias.DBAliasSource;
import org.smyld.util.alias.DBAliasTable;

public class DBAliasGenerator
extends AliasGenerator {
    private static final long serialVersionUID = 1L;
    DatabaseMetaData dbMetaData;

    public DBAliasGenerator(HashMap<String, AliasClassSettings> classes) {
        super(classes);
    }

    @Override
    public void processSource(AliasSource alSrc, AliasSettings alSettings) throws Exception {
        super.processSource(alSrc, alSettings);
        boolean commentAdded = false;
        DBAliasSource dbSrc = (DBAliasSource)alSrc;
        this.dbMetaData = dbSrc.getRs2DBConnection().getConnection().getMetaData();
        HashMap<String, String> schema = dbSrc.getSchemaList();
        String tablePrefix = alSettings.getPrefixes().get("table");
        String columnPrefix = alSettings.getPrefixes().get("column");
        if (schema != null) {
            for (String curSchema : schema.keySet()) {
                curSchema = curSchema.toUpperCase();
                ResultSet rsCatalogs = this.dbMetaData.getTables(null, curSchema, null, null);
                while (rsCatalogs.next()) {
                    String curTableName = rsCatalogs.getString("TABLE_NAME");
                    if (!dbSrc.getTables().containsKey(DBAliasTable.createKey(curSchema, curTableName.toLowerCase()))) continue;
                    if (!commentAdded) {
                        this.addComment(" ******************************** Constants DB source from \"" + dbSrc.getDbConnSettings().getName() + "\" data base  ******************************** ");
                        commentAdded = true;
                    }
                    String newTableName = this.convertName(curTableName);
                    this.addComment(" **** Table (" + curTableName + ") **** ");
                    this.addConstant(tablePrefix + this.settings.getNameSeparator() + newTableName, curTableName);
                    ResultSet rsTableCols = this.dbMetaData.getColumns(null, curSchema, curTableName, null);
                    while (rsTableCols.next()) {
                        String colName = rsTableCols.getString("COLUMN_NAME");
                        String newColName = newTableName + this.settings.getNameSeparator() + this.convertName(colName);
                        this.addConstant(columnPrefix + this.settings.getNameSeparator() + newColName, colName);
                    }
                    rsTableCols.close();
                }
                rsCatalogs.close();
            }
        }
    }
}

