/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.schema;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.smyld.SMYLDObject;
import org.smyld.db.schema.ForeignKey;
import org.smyld.db.schema.PrimaryKey;
import org.smyld.db.schema.SchemaConstants;
import org.smyld.db.schema.SchemaObject;
import org.smyld.db.schema.Table;
import org.smyld.db.schema.TableColumn;

public class XMLSchemaReader
extends SMYLDObject
implements SchemaConstants {
    private static final long serialVersionUID = 1L;
    HashMap<String, Table> tables;
    Element root;

    public void readSchemaTables(String sourceFile) throws Exception {
        this.root = new SAXBuilder().build(new File(sourceFile)).getRootElement();
        this.readTables(this.root.getChild("tables"));
    }

    private void readTables(Element tablesNode) {
        if (tablesNode == null) {
            return;
        }
        if (this.tables == null) {
            this.tables = new HashMap();
        } else {
            this.tables.clear();
        }
        List tableList = tablesNode.getChildren("table");
        for (Element curTable : tableList) {
            this.readTable(curTable);
        }
    }

    private void readTable(Element tableNode) {
        Element fkeysNode;
        Element pkeysNode;
        if (tableNode == null) {
            return;
        }
        Table newTable = new Table();
        newTable.setName(tableNode.getAttributeValue("name"));
        Element colsNode = tableNode.getChild("columns");
        List colList = colsNode.getChildren("column");
        if (colsNode != null && colList != null) {
            HashMap<String, SchemaObject> cols = new HashMap<String, SchemaObject>();
            Iterator itr = colList.iterator();
            while (itr.hasNext()) {
                TableColumn newCol = new TableColumn();
                Element colNode = (Element)itr.next();
                this.readCol(colNode, newCol);
                cols.put(newCol.getName(), newCol);
            }
            newTable.setCols(cols);
        }
        if ((pkeysNode = tableNode.getChild("primarykeys")) != null && pkeysNode.getChildren("key") != null) {
            List pkeysList = pkeysNode.getChildren("key");
            HashMap<String, SchemaObject> pkeys = new HashMap<String, SchemaObject>();
            Iterator itr = pkeysList.iterator();
            while (itr.hasNext()) {
                PrimaryKey newKey = new PrimaryKey();
                Element keyNode = (Element)itr.next();
                this.readPrimaryKey(keyNode, newKey);
                pkeys.put(newKey.getColumnName(), newKey);
            }
            newTable.setPrimaryKeys(pkeys);
        }
        if ((fkeysNode = tableNode.getChild("foreignkeys")) != null && fkeysNode.getChildren("key") != null) {
            List fkeysList = fkeysNode.getChildren("key");
            HashMap<String, SchemaObject> fkeys = new HashMap<String, SchemaObject>();
            Iterator itr = fkeysList.iterator();
            while (itr.hasNext()) {
                ForeignKey newKey = new ForeignKey();
                Element keyNode = (Element)itr.next();
                this.readForeignKey(keyNode, newKey);
                fkeys.put(newKey.getName(), newKey);
            }
            newTable.setForeignKeys(fkeys);
        }
        this.tables.put(newTable.getName(), newTable);
    }

    private void readCol(Element colNode, TableColumn newCol) {
        newCol.setName(colNode.getAttributeValue("name"));
        newCol.setType(colNode.getAttributeValue("type"));
        newCol.setSize(Integer.parseInt(colNode.getAttributeValue("size")));
        newCol.setNullable("true".equals(colNode.getAttributeValue("nullable")));
    }

    private void readPrimaryKey(Element keyNode, PrimaryKey newKey) {
        newKey.setName(keyNode.getAttributeValue("name"));
        newKey.setColumnName(keyNode.getAttributeValue("column"));
        newKey.setSequence(Integer.parseInt(keyNode.getAttributeValue("sequence")));
    }

    private void readForeignKey(Element keyNode, ForeignKey newKey) {
        newKey.setName(keyNode.getAttributeValue("name"));
        newKey.setColumnName(keyNode.getAttributeValue("column"));
        newKey.setTable(keyNode.getAttributeValue("table"));
        PrimaryKey ref = new PrimaryKey();
        ref.setColumnName(keyNode.getAttributeValue("column"));
        newKey.setPrimaryKey(ref);
    }

    public HashMap<String, Table> getTables() {
        return this.tables;
    }
}

