/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.oracle;

import org.smyld.SMYLDObject;
import org.smyld.db.oracle.OraConstants;
import org.smyld.text.TextUtil;

public class OracleErrorStack
extends SMYLDObject
implements OraConstants {
    private static final long serialVersionUID = 1L;
    String errorLine;
    String errorObject;
    int errorNumber;

    public OracleErrorStack(String errorLine) {
        this.errorLine = errorLine;
        this.doParseError();
    }

    private void doParseError() {
        int startIndex = this.errorLine.indexOf("ORA-");
        if (startIndex != -1) {
            int semiColon = this.errorLine.indexOf(":", startIndex += 4);
            if (semiColon != -1) {
                String errorNoText = this.errorLine.substring(startIndex, semiColon);
                this.errorNumber = Integer.parseInt(errorNoText);
                this.processObjectError(semiColon);
            }
        } else {
            this.errorNumber = -1;
        }
    }

    private void processObjectError(int index) {
        if (OracleErrorStack.containsObjectName(this.errorNumber)) {
            this.errorObject = TextUtil.getSectionText((String)this.errorLine, (String)"\"", (String)"\"", (int)index);
        }
    }

    public String getErrorObjectName() {
        return this.errorObject;
    }

    public static boolean containsObjectName(int errorNumber) {
        switch (errorNumber) {
            case 4061: 
            case 4063: {
                return true;
            }
        }
        return false;
    }

    public String getErrorLine() {
        return this.errorLine;
    }

    public int getErrorNumber() {
        return this.errorNumber;
    }
}

