/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.schema;

import java.util.HashMap;
import java.util.Vector;
import org.smyld.db.schema.SchemaLog;
import org.smyld.db.schema.SchemaObject;
import org.smyld.db.schema.TableColumn;

public class Table
extends SchemaObject {
    private static final long serialVersionUID = 1L;
    HashMap<String, SchemaObject> cols;
    HashMap<String, SchemaObject> primaryKeys;
    HashMap<String, SchemaObject> foreignKeys;
    protected Vector<Object> logs;

    public Table() {
        this.setSchemaType("table");
    }

    public HashMap<String, SchemaObject> getCols() {
        return this.cols;
    }

    public void setCols(HashMap<String, SchemaObject> cols) {
        this.cols = cols;
    }

    public HashMap<String, SchemaObject> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(HashMap<String, SchemaObject> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public HashMap<String, SchemaObject> getForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(HashMap<String, SchemaObject> foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    public boolean equals(Object compTable) {
        if (compTable instanceof Table) {
            Table table = (Table)compTable;
            this.compareColumns(table.getCols());
            this.comparePKeys(table.getPrimaryKeys());
            this.compareFKeys(table.getForeignKeys());
        }
        return this.logs.size() == 0;
    }

    private boolean compareColumns(HashMap<String, SchemaObject> cols) {
        return this.compare(this.cols, cols, "Columns");
    }

    private boolean comparePKeys(HashMap<String, SchemaObject> pkeys) {
        return this.compare(this.primaryKeys, pkeys, "Primary Keys");
    }

    private boolean compareFKeys(HashMap<String, SchemaObject> fkeys) {
        return this.compare(this.foreignKeys, fkeys, "Foreign Keys");
    }

    private boolean compare(HashMap<String, SchemaObject> orig, HashMap<String, SchemaObject> comp, String keyword) {
        if (comp == null && orig != null) {
            this.logs.add(keyword + " do not exsit !!");
            return false;
        }
        if (comp == null && orig == null) {
            return true;
        }
        boolean result = true;
        for (String key : orig.keySet()) {
            SchemaObject origObj = orig.get(key);
            SchemaObject compObj = comp.get(key);
            result = origObj == null && compObj == null ? true : (origObj != null && compObj != null ? origObj.equals(compObj) : false);
            if (result) continue;
            this.addSchemaLog(origObj, compObj);
        }
        return result;
    }

    public void addColumn(TableColumn newCol) {
        if (this.cols == null) {
            this.cols = new HashMap();
        }
        this.cols.put(newCol.getName(), newCol);
    }

    public TableColumn getColumn(String colName) {
        if (this.cols != null) {
            return (TableColumn)this.cols.get(colName);
        }
        return null;
    }

    protected void addSchemaLog(SchemaObject origObj, SchemaObject compObj) {
        if (this.logs == null) {
            this.logs = new Vector();
        }
        SchemaLog newLog = new SchemaLog();
        newLog.setID(origObj.getName());
        newLog.setOriginalObject(origObj);
        newLog.setComparedObject(compObj);
        this.logs.add((Object)newLog);
    }

    public Vector<Object> getCompareLogs() {
        return this.logs;
    }
}

