/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.util.alias;

import java.util.HashMap;
import org.smyld.db.DBConnection;
import org.smyld.db.DBSettings;
import org.smyld.util.alias.AliasSource;
import org.smyld.util.alias.DBAliasTable;

public class DBAliasSource
extends AliasSource {
    private static final long serialVersionUID = 1L;
    HashMap<String, DBAliasTable> tables;
    HashMap<String, String> schemas;
    DBSettings dbConnSettings;
    DBConnection smyldDBConnection;

    public DBAliasSource() {
        super(1);
    }

    public DBSettings getDbConnSettings() {
        return this.dbConnSettings;
    }

    public void setDbConnSettings(DBSettings dbConnSettings) {
        this.dbConnSettings = dbConnSettings;
    }

    public HashMap<String, DBAliasTable> getTables() {
        return this.tables;
    }

    public void setTables(HashMap<String, DBAliasTable> tables) {
        this.tables = tables;
    }

    public void fillSchemas() {
        if (this.tables != null && this.tables.size() > 0) {
            this.schemas = new HashMap();
            for (DBAliasTable curTable : this.tables.values()) {
                String curSchema = curTable.getSchema();
                if (this.schemas.containsKey(curSchema)) continue;
                this.schemas.put(curSchema, curSchema);
            }
        }
    }

    public HashMap<String, String> getSchemaList() {
        if (this.schemas != null && this.schemas.size() > 0) {
            return this.schemas;
        }
        return null;
    }

    public DBConnection getRs2DBConnection() {
        return this.smyldDBConnection;
    }

    public void setRs2DBConnection(DBConnection smyldDBConnection) {
        this.smyldDBConnection = smyldDBConnection;
    }
}

