/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.schema;

import java.util.HashMap;
import org.jdom2.Content;
import org.jdom2.Element;
import org.smyld.db.schema.ForeignKey;
import org.smyld.db.schema.PrimaryKey;
import org.smyld.db.schema.SchemaConstants;
import org.smyld.db.schema.SchemaObject;
import org.smyld.db.schema.Table;
import org.smyld.db.schema.TableColumn;
import org.smyld.xml.XMLFileWriter;

public class XMLSchemaWriter
extends XMLFileWriter
implements SchemaConstants {
    private static final long serialVersionUID = 1L;
    HashMap<String, Table> tables;

    public void compose() {
        this.rootElement = new Element("database");
        if (this.tables != null && this.tables.size() > 0) {
            Element tablesNode = new Element("tables");
            for (String tableName : this.tables.keySet()) {
                Table curTable = this.tables.get(tableName);
                Element tableNode = new Element("table");
                tableNode.setAttribute("name", curTable.getName());
                this.addTable(curTable, tableNode);
                tablesNode.addContent((Content)tableNode);
            }
            this.rootElement.addContent((Content)tablesNode);
        }
    }

    private void addTable(Table curTable, Element tableNode) {
        HashMap<String, SchemaObject> fkeys;
        HashMap<String, SchemaObject> pkeys;
        HashMap<String, SchemaObject> cols = curTable.getCols();
        if (cols != null && cols.size() > 0) {
            Element colsNode = new Element("columns");
            for (String string : cols.keySet()) {
                TableColumn curCol = (TableColumn)cols.get(string);
                Element colNode = new Element("column");
                this.addColumn(curCol, colNode);
                colsNode.addContent((Content)colNode);
            }
            tableNode.addContent((Content)colsNode);
        }
        if ((pkeys = curTable.getPrimaryKeys()) != null && pkeys.size() > 0) {
            Element pkeysNode = new Element("primarykeys");
            for (String keyName : pkeys.keySet()) {
                PrimaryKey curKey = (PrimaryKey)pkeys.get(keyName);
                Element keyNode = new Element("key");
                this.addPKey(curKey, keyNode);
                pkeysNode.addContent((Content)keyNode);
            }
            tableNode.addContent((Content)pkeysNode);
        }
        if ((fkeys = curTable.getForeignKeys()) != null && fkeys.size() > 0) {
            Element element = new Element("foreignkeys");
            for (String keyName : fkeys.keySet()) {
                ForeignKey curKey = (ForeignKey)fkeys.get(keyName);
                Element keyNode = new Element("key");
                this.addFKey(curKey, keyNode);
                element.addContent((Content)keyNode);
            }
            tableNode.addContent((Content)element);
        }
    }

    private void addFKey(ForeignKey curkey, Element keyNode) {
        keyNode.setAttribute("name", curkey.getName());
        keyNode.setAttribute("column", curkey.getColumnName());
        keyNode.setAttribute("table", curkey.getTable());
        keyNode.setAttribute("refcolumn", curkey.getPrimaryKey().getColumnName());
    }

    private void addPKey(PrimaryKey curkey, Element keyNode) {
        keyNode.setAttribute("name", curkey.getName());
        keyNode.setAttribute("column", curkey.getColumnName());
        keyNode.setAttribute("sequence", Integer.toString(curkey.getSequence()));
    }

    private void addColumn(TableColumn curCol, Element colNode) {
        colNode.setAttribute("name", curCol.getName());
        colNode.setAttribute("type", curCol.getType());
        colNode.setAttribute("nullable", Boolean.toString(curCol.isNullable()));
        colNode.setAttribute("size", Integer.toString(curCol.getSize()));
    }

    public HashMap<String, Table> getTables() {
        return this.tables;
    }

    public void setTables(HashMap<String, Table> tables) {
        this.tables = tables;
    }
}

