/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.schema.oracle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.smyld.db.DBConnection;
import org.smyld.db.DBErrorHandler;
import org.smyld.db.oracle.OraConstants;
import org.smyld.db.schema.DBSchemaHandler;
import org.smyld.db.schema.DBSchemaReader;
import org.smyld.db.schema.ProceduresPackage;
import org.smyld.db.schema.StoredProcedure;
import org.smyld.db.schema.Table;
import org.smyld.db.schema.oracle.OraTable;
import org.smyld.db.schema.oracle.OraTableSpace;
import org.smyld.io.SMYLDFileOutputStream;
import org.smyld.text.TextUtil;
import org.smyld.util.jar.SMYLDJARWriter;

public class OraDBSchemaReader
extends DBSchemaReader
implements OraConstants {
    private static final long serialVersionUID = 1L;
    DBConnection conn;
    PreparedStatement stPackage;
    PreparedStatement stSource;
    PreparedStatement stPackageDpnd;
    PreparedStatement stTable;
    SMYLDFileOutputStream fout;
    HashMap<String, String> refTypes;
    HashMap<String, String> refObjects = new HashMap();

    public OraDBSchemaReader(DBErrorHandler e, DBConnection connection) {
        super(e, connection);
    }

    @Override
    public void readSchemaStoredProcedures(DBConnection conn) throws Exception {
        this.conn = conn;
        if (this.dbStoredProcedures != null && this.dbStoredProcedures.size() > 0) {
            PreparedStatement st = this.dbConnection.prepareStatement("Select TEXT from USER_SOURCE Where TYPE=? AND NAME=? Order By LINE");
            for (Object curProc : this.dbStoredProcedures) {
                Vector<String> vector;
                if (curProc instanceof StoredProcedure) {
                    StoredProcedure sp = (StoredProcedure)((Object)curProc);
                    vector = this.getSourceText(sp.getName(), "PROCEDURE");
                    continue;
                }
                ProceduresPackage pack = (ProceduresPackage)((Object)curProc);
                vector = this.getSourceText(pack.getName(), "PACKAGE BODY");
            }
        }
    }

    @Override
    protected Table createTable() {
        return new OraTable();
    }

    @Override
    public void readSchemaTables(HashMap<String, String> tables) throws Exception {
        super.readSchemaTables(tables);
        if (this.dbTables != null && this.dbTables.size() > 0) {
            for (Table parentTable : this.dbTables.values()) {
                OraTable curTable = (OraTable)parentTable;
                ResultSet rsTable = this.dbUtility.getSingleParamSQL(curTable.getName(), "Select * from USER_TABLES Where TABLE_NAME=?");
                if (!rsTable.next()) continue;
                OraTableSpace newTableSpace = new OraTableSpace();
                newTableSpace.setName(rsTable.getString("TABLESPACE_NAME"));
                newTableSpace.setInitialExtent(rsTable.getInt("INITIAL_EXTENT"));
                newTableSpace.setNextExtent(rsTable.getInt("NEXT_EXTENT"));
                newTableSpace.setMinExtent(rsTable.getInt("MIN_EXTENTS"));
                newTableSpace.setMaxExtent(rsTable.getInt("MAX_EXTENTS"));
                newTableSpace.setSpaceManagement(rsTable.getString("SEGMENT_SPACE_MANAGEMENT"));
                newTableSpace.setLogging("LOGGING".equals(rsTable.getString("LOGGING")));
                curTable.setTableSpace(newTableSpace);
            }
        }
    }

    private ResultSet getTable(String tableName) throws Exception {
        if (this.stTable == null) {
            this.stTable = this.dbConnection.prepareStatement("Select * from USER_TABLES Where TABLE_NAME=?");
        }
        this.stTable.setString(1, tableName);
        return this.stTable.executeQuery();
    }

    public void exportStoredProcedures(Vector<String> procedures, String exportFile) throws Exception {
        this.fout = new SMYLDFileOutputStream("d:/temp/dependencies.txt");
        this.fout.setWithIndent(true);
        this.refTypes = new HashMap();
        SMYLDJARWriter writer = new SMYLDJARWriter(exportFile);
        for (String pckgName : procedures) {
            pckgName = pckgName.toUpperCase();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.exportPackage(pckgName, bout);
            writer.addStreamFile((InputStream)new ByteArrayInputStream(bout.toByteArray()), pckgName + ".pkg");
        }
        HashMap<String, String> tableList = this.getReferencedTables(procedures);
        ByteArrayOutputStream xmlSchema = new ByteArrayOutputStream();
        DBSchemaHandler handler = new DBSchemaHandler(this.smyldDBConnection);
        handler.generateXMLSchemaDocument(tableList, xmlSchema);
        writer.addStreamFile((InputStream)new ByteArrayInputStream(xmlSchema.toByteArray()), "Schema.xml");
        writer.close();
        this.fout.writeln("All Referenced Types :", 0);
        this.fout.setIndentLevel(1);
        for (String curRef : this.refTypes.keySet()) {
            this.fout.writeln(curRef);
        }
    }

    public void exportPackage(String packageName, OutputStream out) throws Exception {
        Vector<String> pckLines = this.getSourceText(packageName, "PACKAGE");
        Vector<String> bodLines = this.getSourceText(packageName, "PACKAGE BODY");
        out.write(("******* SMYLD Package Export Utility *******" + OS_NEW_LINE).getBytes());
        out.write(("* Package : " + packageName + OS_NEW_LINE).getBytes());
        out.write(("* Date    : " + new Date().toString() + OS_NEW_LINE).getBytes());
        out.write(("******************************************" + OS_NEW_LINE).getBytes());
        out.write((OS_NEW_LINE + "####### Header #######" + OS_NEW_LINE).getBytes());
        this.addCodeLines(out, pckLines);
        out.write((OS_NEW_LINE + "####### Body   #######" + OS_NEW_LINE).getBytes());
        this.addCodeLines(out, bodLines);
    }

    private void addCodeLines(OutputStream out, Vector<String> lines) throws Exception {
        if (lines == null) {
            return;
        }
        for (String curLine : lines) {
            out.write((curLine + OS_NEW_LINE).getBytes());
        }
    }

    public HashMap<String, String> getReferencedTables(Vector<String> procedures) throws Exception {
        HashMap<String, String> dependencies = new HashMap<String, String>();
        PreparedStatement st = this.dbConnection.prepareStatement("Select TEXT, TYPE from USER_SOURCE Where NAME=? Order By TYPE, LINE");
        for (String pckgName : procedures) {
            pckgName = pckgName.toUpperCase();
            this.readDependency(pckgName, dependencies);
        }
        System.out.println("Total tables referenced : " + dependencies.size());
        return dependencies;
    }

    public void analyseDependency(String procedure) throws Exception {
        String code = this.getSourceTextAsString(procedure, "PACKAGE BODY");
        Vector sects = TextUtil.getAllSectionText((String)code, (String)"from", (String)"where");
        if (sects != null && sects.size() > 0) {
            for (String curLine : sects) {
                System.out.println(curLine);
            }
        }
    }

    public void readDependency(String procedure, HashMap<String, String> dependencies) throws Exception {
        int refNo = 0;
        this.refObjects.put(procedure, procedure);
        PreparedStatement stDP = this.dbConnection.prepareStatement("Select REFERENCED_TYPE, REFERENCED_NAME, DEPENDENCY_TYPE from USER_DEPENDENCIES Where NAME=? AND TYPE IN ('PACKAGE', 'PACKAGE BODY') ");
        stDP.setString(1, procedure);
        this.fout.setIndentLevel(1);
        this.fout.writeln(procedure + ":");
        this.fout.setIndentLevel(2);
        ResultSet rs = stDP.executeQuery();
        while (rs.next()) {
            String refType = rs.getString("REFERENCED_TYPE");
            String refName = rs.getString("REFERENCED_NAME");
            System.out.println("Package (" + procedure + ") refrencing " + refType + " (" + refName + ")");
            if (!this.refTypes.containsKey(refType)) {
                this.refTypes.put(refType, refType);
            }
            if (refType.equals("TABLE")) {
                dependencies.put(refName, refName);
                this.readDependency(refName, "TABLE", dependencies);
                ++refNo;
                continue;
            }
            if (refType.equals("VIEW")) {
                this.readDependency(refName, "VIEW", dependencies);
                continue;
            }
            if (!refType.equals("PACKAGE") || refName.equals("STANDARD") || refType.equals("NON-EXISTENT") || refName.equals(procedure) || this.isReferenced(refName)) continue;
            this.readDependency(refName, dependencies);
        }
        this.fout.setIndentLevel(3);
        this.fout.writeln(procedure + " referenced (" + refNo + ") table");
    }

    private boolean isReferenced(String objectName) {
        return this.refObjects.containsKey(objectName);
    }

    public void readDependency(String objectName, String objectType, HashMap<String, String> dependencies) throws Exception {
        this.refObjects.put(objectName, objectName);
        int refNo = 0;
        PreparedStatement stDpnd = this.dbConnection.prepareStatement("Select REFERENCED_TYPE, REFERENCED_NAME, DEPENDENCY_TYPE from USER_DEPENDENCIES Where NAME=? AND TYPE IN ('PACKAGE', 'PACKAGE BODY') ");
        stDpnd.setString(1, objectName);
        stDpnd.setString(1, objectType);
        this.fout.setIndentLevel(1);
        this.fout.writeln(objectName + ":");
        this.fout.setIndentLevel(2);
        ResultSet rs = stDpnd.executeQuery();
        while (rs.next()) {
            String refType = rs.getString("REFERENCED_TYPE");
            String refName = rs.getString("REFERENCED_NAME");
            String dpType = rs.getString("DEPENDENCY_TYPE");
            System.out.println(objectType + " (" + objectName + ") refrencing " + refType + " (" + refName + ")");
            if (!this.refTypes.containsKey(refType)) {
                this.refTypes.put(refType, refType);
            }
            if (refType.equals("TABLE")) {
                dependencies.put(refName, refName);
                this.readDependency(refName, "TABLE", dependencies);
                ++refNo;
                continue;
            }
            if (refType.equals("PACKAGE") && !refName.equals("STANDARD") && !refType.equals("NON-EXISTENT")) {
                this.readDependency(refName, dependencies);
                continue;
            }
            if (!refType.equals("TYPE")) continue;
            this.readDependency(refName, "VIEW", dependencies);
        }
        this.fout.setIndentLevel(3);
        this.fout.writeln(objectName + " referenced (" + refNo + ") table");
    }

    private Vector<String> getSourceText(String name, String type) throws Exception {
        if (this.stSource == null) {
            this.stSource = this.dbConnection.prepareStatement("Select TEXT from USER_SOURCE Where TYPE=? AND NAME=? Order By LINE");
        }
        Vector<String> textLines = null;
        this.stSource.setString(1, type);
        this.stSource.setString(2, name);
        ResultSet rs = this.stSource.executeQuery();
        while (rs.next()) {
            if (textLines == null) {
                textLines = new Vector<String>();
            }
            textLines.add(rs.getString(1));
        }
        return textLines;
    }

    private String getSourceTextAsString(String name, String type) throws Exception {
        if (this.stSource == null) {
            this.stSource = this.conn.getConnection().prepareStatement("Select TEXT from USER_SOURCE Where TYPE=? AND NAME=? Order By LINE");
        }
        StringBuffer buffer = new StringBuffer();
        this.stSource.setString(1, type);
        this.stSource.setString(2, name);
        ResultSet rs = this.stSource.executeQuery();
        while (rs.next()) {
            buffer.append(rs.getString(1));
        }
        return buffer.toString();
    }
}

