/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.util.alias;

import java.util.HashMap;
import java.util.Iterator;
import org.jdom2.Element;
import org.smyld.util.alias.AliasClassSettings;
import org.smyld.util.alias.AliasGenerator;
import org.smyld.util.alias.AliasSettings;
import org.smyld.util.alias.AliasSource;
import org.smyld.util.alias.XMLAliasSource;
import org.smyld.xml.XMLUtil;

public class XMLFieldsAliasGenerator
extends AliasGenerator {
    private static final long serialVersionUID = 1L;
    String tagPrefix;
    String attPrefix;

    public XMLFieldsAliasGenerator(HashMap<String, AliasClassSettings> classes) {
        super(classes);
    }

    @Override
    public void processSource(AliasSource alSrc, AliasSettings alSettings) throws Exception {
        super.processSource(alSrc, alSettings);
        XMLAliasSource xmlSrc = (XMLAliasSource)alSrc;
        if (xmlSrc.getSchemaType() == 2) {
            Element root = XMLUtil.getRootNode((String)xmlSrc.getName());
            this.addComment(" ******************************** Constants XML source from \"" + xmlSrc.getName() + "\" file  ******************************** ");
            this.processTag(root);
        }
    }

    private void processTag(Element newTag) {
        String idValue;
        String tagName = newTag.getName();
        if (tagName != null && tagName.toLowerCase().equals("field") && (idValue = newTag.getAttributeValue("id")) != null) {
            this.addConstant(this.convertName(idValue), idValue);
        }
        if (XMLUtil.hasChildren((Element)newTag)) {
            Iterator childItr = newTag.getChildren().iterator();
            while (childItr.hasNext()) {
                this.processTag((Element)childItr.next());
            }
        }
    }
}

