/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.oracle;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Vector;
import org.smyld.db.SMYLDSQLException;
import org.smyld.db.oracle.OraConstants;
import org.smyld.db.oracle.OracleErrorStack;

public class OracleSqlException
extends SMYLDSQLException
implements OraConstants {
    private static final long serialVersionUID = 1L;
    Vector<OracleErrorStack> errorStack;
    String errorObjectName;

    public OracleSqlException() {
    }

    public OracleSqlException(Exception exception) {
        super(exception);
    }

    public int getExceptionCategory() {
        return this.getExceptionCategory(this.getErrorNumber());
    }

    public String getErrorObjectName() {
        return this.errorObjectName;
    }

    public int getExceptionCategory(int errNo) {
        switch (errNo) {
            case 2: 
            case 1017: 
            case 1033: 
            case 1089: 
            case 17002: {
                return 1;
            }
            case 4068: {
                this.errorObjectName = this.getErrorStack(1).getErrorObjectName();
                if (this.getErrorNumber(1) == 4061 && this.getErrorNumber(2) == 4065) {
                    return 10;
                }
                if (this.getErrorNumber(1) != 4063) break;
                return 11;
            }
        }
        return 0;
    }

    public OracleErrorStack getErrorStack(int stackIndex) {
        if (stackIndex <= this.errorStack.size()) {
            return this.errorStack.get(stackIndex);
        }
        return null;
    }

    public int getErrorNumber(int stackIndex) {
        if (stackIndex <= this.errorStack.size()) {
            return this.errorStack.get(stackIndex).getErrorNumber();
        }
        return -1;
    }

    @Override
    public void doParseError(Exception exception) {
        super.doParseError(exception);
        this.setOriginalMessage(exception.getMessage());
        LineNumberReader reader = new LineNumberReader(new StringReader(this.getOriginalMessage()));
        String currentErrorLine = null;
        try {
            while ((currentErrorLine = reader.readLine()) != null) {
                if (this.errorStack == null) {
                    this.errorStack = new Vector();
                }
                OracleErrorStack currStack = new OracleErrorStack(currentErrorLine);
                this.errorStack.add(currStack);
            }
            if (this.errorStack != null && this.errorStack.size() > 0) {
                this.errorNumber = this.errorStack.get(0).getErrorNumber();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Vector<OracleErrorStack> getOracleErrorStack() {
        return this.errorStack;
    }
}

