/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.db.oracle;

import java.io.File;
import java.util.HashMap;
import org.smyld.SMYLDObject;
import org.smyld.db.DBSettings;
import org.smyld.db.oracle.OraConstants;
import org.smyld.db.oracle.TNSNamesParser;
import org.smyld.io.FileSystem;

public class OracleUtility
extends SMYLDObject
implements OraConstants {
    private static final long serialVersionUID = 1L;

    public static HashMap<String, DBSettings> readOracleConnectionsSettings() {
        String fileName = OracleUtility.getTNSNamesFile();
        if (fileName != null) {
            return OracleUtility.parseOracleConnectionsSettings(fileName);
        }
        return null;
    }

    public static HashMap<String, DBSettings> parseOracleConnectionsSettings(String tnsNamesFile) {
        TNSNamesParser parser = new TNSNamesParser();
        return parser.parseConnections(tnsNamesFile);
    }

    public static String getTNSNamesFile() {
        Object oraclePath = FileSystem.getEnvVariable((String)"ORACLE_HOME");
        if (oraclePath != null) {
            oraclePath = (String)oraclePath + "/network/admin" + File.separator + "tnsnames.ora";
        }
        return oraclePath;
    }
}

