/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui;

import java.awt.Component;
import javax.swing.UIManager;
import org.smyld.gui.SMYLDXYLayout;
import org.smyld.gui.layout.SMYLDRCConstraints;
import org.smyld.gui.layout.SMYLDXYConstraints;

public class SMYLDRCLayout
extends SMYLDXYLayout {
    private static final long serialVersionUID = 1L;
    public static final int x_ratio = 12;
    public static int y_ratio = 20;
    public static int y_gap = 5;
    public static final int y_margin = 35;
    int topMargin = 35;

    public SMYLDRCLayout() {
        this.specifyHeight();
    }

    private void specifyHeight() {
        y_ratio = UIManager.getLookAndFeel() != null && UIManager.getLookAndFeel().getName().toLowerCase().equals("nimbus") ? 25 : 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            this.specifyHeight();
            SMYLDRCConstraints rcConst = (SMYLDRCConstraints)((Object)constraints);
            if (rcConst != null) {
                int newX = rcConst.getColumn() * 12;
                int newY = (rcConst.getRow() - 1) * y_gap + (rcConst.getRow() - 1) * y_ratio + this.topMargin;
                int newW = rcConst.getWidth() * 12;
                int newH = rcConst.getHeight() * y_ratio;
                super.addLayoutComponent(comp, (Object)new SMYLDXYConstraints(newX, newY, newW, newH));
            }
        }
    }

    public void setYRatio(int newValue) {
        y_ratio = newValue;
    }

    public void setYGap(int newValue) {
        y_gap = newValue;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }
}

