/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import org.smyld.gui.SMYLDFrame;

public class SMYLDSplashScreen
extends JWindow
implements Runnable {
    private static final long serialVersionUID = 1L;
    Frame owner;
    JPanel contents;
    ImageIcon image;
    int showTime;

    public SMYLDSplashScreen() {
        this.init();
    }

    public SMYLDSplashScreen(ImageIcon splashImage) {
        this.image = splashImage;
        this.init();
    }

    public SMYLDSplashScreen(ImageIcon splashImage, int showTime) {
        this.showTime = showTime;
        this.image = splashImage;
        this.init();
    }

    public SMYLDSplashScreen(Frame ownerFrame) {
        super(ownerFrame);
        this.owner = ownerFrame;
        this.init();
    }

    public SMYLDSplashScreen(Frame ownerFrame, int showTime) {
        super(ownerFrame);
        this.showTime = showTime;
        this.owner = ownerFrame;
        this.init();
    }

    public SMYLDSplashScreen(JPanel contentsPanel) {
        this.contents = contentsPanel;
        this.init();
    }

    public SMYLDSplashScreen(JPanel contentsPanel, int showTime) {
        this.showTime = showTime;
        this.contents = contentsPanel;
        this.init();
    }

    private void init() {
        if (this.contents != null) {
            this.getContentPane().add((Component)this.contents, "Center");
        } else if (this.image != null) {
            this.getContentPane().add((Component)new JLabel(this.image), "Center");
        }
        this.pack();
        if (this.owner == null) {
            SMYLDFrame.centerComponentInScreen(this);
        }
        this.setVisible(true);
        if (this.showTime != 0) {
            this.processTime();
        }
    }

    private void processTime() {
        try {
            Thread.sleep(this.showTime * 1000);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dispose();
    }

    @Override
    public void run() {
        this.setVisible(true);
        if (this.showTime != 0) {
            this.processTime();
        }
    }
}

