/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import org.smyld.gui.GUIAction;
import org.smyld.gui.SMYLDButton;
import org.smyld.gui.SMYLDComboBox;
import org.smyld.gui.SMYLDFrame;
import org.smyld.gui.SMYLDToolbar;
import org.smyld.gui.edit.DocTextPart;
import org.smyld.gui.edit.EditorPopupItem;
import org.smyld.gui.edit.EditorPopupModel;
import org.smyld.gui.edit.EditorPopupPanel;
import org.smyld.gui.edit.EditorUserField;
import org.smyld.gui.edit.Formula;
import org.smyld.gui.event.ActionHandler;
import org.smyld.resources.Resource;

public class SMYLDTextEditor
extends JTextPane {
    private SMYLDTextEditor instance;
    private EditorPopupPanel popPan;
    private Word curWord;
    private EditorPopupModel model;
    private int popWidth = 150;
    private int popHeight = 200;
    private EditMode emode = EditMode.Normal;
    Vector<EditorUserField> userFields = new Vector();
    Vector<DocTextPart> formHlParts = new Vector();
    private int curUFieldInd = 0;
    private int curUFieldPos = 0;
    private Formula curFormula;
    private Vector<Formula> formulaCashe = new Vector();
    private SimpleAttributeSet userFieldsStyle;
    private SimpleAttributeSet formulasStyle;
    private SimpleAttributeSet templateStyle;
    private SimpleAttributeSet formulaFieldStyle;
    private SimpleAttributeSet defaultTextStyle;
    private StyledDocument stDoc;
    static SMYLDTextEditor editor;
    private static final char[] WORD_SEPARATORS;

    public SMYLDTextEditor(EditorPopupModel model) {
        this.model = model;
        this.init();
    }

    private void init() {
        this.instance = this;
        this.curWord = new Word();
        this.stDoc = (StyledDocument)this.getDocument();
        this.setEventManagement();
        this.activateAttributes();
    }

    private void activateAttributes() {
        this.defaultTextStyle = new SimpleAttributeSet();
        StyleConstants.setFontFamily(this.defaultTextStyle, "Monospaced");
        StyleConstants.setFontSize(this.defaultTextStyle, 12);
        StyleConstants.setBackground(this.defaultTextStyle, Color.WHITE);
        StyleConstants.setForeground(this.defaultTextStyle, Color.BLACK);
        StyleConstants.setBold(this.defaultTextStyle, false);
        StyleConstants.setItalic(this.defaultTextStyle, false);
        this.userFieldsStyle = new SimpleAttributeSet();
        StyleConstants.setFontFamily(this.userFieldsStyle, "Monospaced");
        StyleConstants.setFontSize(this.userFieldsStyle, 12);
        StyleConstants.setBackground(this.userFieldsStyle, new Color(232, 242, 254));
        StyleConstants.setForeground(this.userFieldsStyle, Color.BLUE);
        StyleConstants.setBold(this.userFieldsStyle, false);
        StyleConstants.setItalic(this.userFieldsStyle, false);
        this.formulaFieldStyle = new SimpleAttributeSet();
        StyleConstants.setFontFamily(this.formulaFieldStyle, "Monospaced");
        StyleConstants.setFontSize(this.formulaFieldStyle, 12);
        StyleConstants.setBackground(this.formulaFieldStyle, Color.WHITE);
        StyleConstants.setForeground(this.formulaFieldStyle, Color.BLUE);
        StyleConstants.setBold(this.formulaFieldStyle, true);
        StyleConstants.setItalic(this.formulaFieldStyle, false);
        this.formulasStyle = new SimpleAttributeSet();
        StyleConstants.setFontFamily(this.formulasStyle, "Monospaced");
        StyleConstants.setFontSize(this.formulasStyle, 12);
        StyleConstants.setBackground(this.formulasStyle, Color.WHITE);
        StyleConstants.setForeground(this.formulasStyle, Color.RED);
        StyleConstants.setBold(this.formulasStyle, true);
        StyleConstants.setItalic(this.formulasStyle, false);
        this.templateStyle = new SimpleAttributeSet();
        StyleConstants.setFontFamily(this.templateStyle, "Monospaced");
        StyleConstants.setFontSize(this.templateStyle, 12);
        StyleConstants.setAlignment(this.templateStyle, 2);
        StyleConstants.setBackground(this.templateStyle, Color.WHITE);
        StyleConstants.setForeground(this.templateStyle, Color.BLACK);
        StyleConstants.setBold(this.templateStyle, false);
        StyleConstants.setItalic(this.templateStyle, false);
    }

    @Override
    public void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        super.paintComponent(g);
        if (this.userFields.size() > 0) {
            this.paintEditorFields(g);
        }
        if (this.popPan != null && this.popPan.isVisible()) {
            this.paintShadow(g);
        }
    }

    private void paintShadow(Graphics2D g) {
        Rectangle rect = this.popPan.getBounds();
        int steps = 5;
        int trans = 30;
        int block = trans / steps;
        for (int i = 0; i < steps; ++i) {
            rect.setLocation(rect.x + 1, rect.y + 1);
            g.setColor(new Color(0, 0, 0, trans - i * block));
            g.fill(rect);
        }
    }

    private void setEventManagement() {
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 2), "controlEspace");
        this.getInputMap().put(KeyStroke.getKeyStroke(36, 2), "home");
        this.getInputMap().put(KeyStroke.getKeyStroke(35, 2), "end");
        this.getActionMap().put("controlEspace", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("I must be popped ..!");
                SMYLDTextEditor.this.processWordListPopup();
                SMYLDTextEditor.this.instance.repaint();
            }
        });
        this.getActionMap().put("home", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.getActionMap().put("end", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (SMYLDTextEditor.this.popPan != null && SMYLDTextEditor.this.popPan.isVisible()) {
                    SMYLDTextEditor.this.hidePopup();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                switch (SMYLDTextEditor.this.emode) {
                    case Formula: 
                    case Template: {
                        if (e.getKeyCode() == 9) {
                            SMYLDTextEditor.this.moveToNextUserField(true);
                            e.consume();
                            break;
                        }
                        if (e.getKeyCode() != 10) break;
                        if (SMYLDTextEditor.this.emode == EditMode.Formula) {
                            SMYLDTextEditor.this.closeFormula();
                            e.consume();
                        }
                        if (SMYLDTextEditor.this.emode != EditMode.Template) break;
                        SMYLDTextEditor.this.closeTemplate();
                        break;
                    }
                    default: {
                        if (e.getKeyCode() != 9 || !SMYLDTextEditor.this.checkFormulaActivation(SMYLDTextEditor.this.getCaretPosition())) break;
                        e.consume();
                    }
                }
                if (SMYLDTextEditor.this.popPan != null && SMYLDTextEditor.this.popPan.isVisible()) {
                    if (e.getKeyCode() == 10) {
                        SMYLDTextEditor.this.itemSelected(SMYLDTextEditor.this.popPan.getSelected());
                        e.consume();
                    } else if (e.getKeyCode() == 40) {
                        SMYLDTextEditor.this.popPan.moveDown();
                        e.consume();
                    } else if (e.getKeyCode() == 38) {
                        SMYLDTextEditor.this.popPan.moveUp();
                        e.consume();
                    } else if (e.getKeyCode() == 34) {
                        SMYLDTextEditor.this.popPan.movePageDown();
                        e.consume();
                    } else if (e.getKeyCode() == 33) {
                        SMYLDTextEditor.this.popPan.movePageUp();
                        e.consume();
                    } else if (e.getKeyCode() == 27) {
                        if (SMYLDTextEditor.this.popPan.isVisible()) {
                            SMYLDTextEditor.this.hidePopup();
                        }
                    } else if (e.getKeyCode() == 9) {
                        if (SMYLDTextEditor.this.checkFormulaActivation(SMYLDTextEditor.this.getCaretPosition())) {
                            e.consume();
                        }
                    } else {
                        SMYLDTextEditor.this.scrollPopupToTypedWord();
                    }
                }
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (SMYLDTextEditor.this.popPan != null && SMYLDTextEditor.this.popPan.isVisible()) {
                    int beginIndex = e.getOffset();
                    int endIndex = beginIndex + e.getLength();
                    String newCharacters = SMYLDTextEditor.this.getText().substring(beginIndex, endIndex);
                    for (int i = 0; i < WORD_SEPARATORS.length; ++i) {
                        if (newCharacters.indexOf(WORD_SEPARATORS[i]) == -1) continue;
                        SMYLDTextEditor.this.curWord.setBounds(-1, 0);
                        SMYLDTextEditor.this.repaint();
                        return;
                    }
                    SMYLDTextEditor.this.curWord.increaseLength(e.getLength());
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (SMYLDTextEditor.this.popPan != null && SMYLDTextEditor.this.popPan.isVisible()) {
                    SMYLDTextEditor.this.curWord.decreaseLength(e.getLength());
                    if (SMYLDTextEditor.this.curWord.getLength() == 0) {
                        SMYLDTextEditor.this.popPan.setVisible(false);
                        SMYLDTextEditor.this.repaint();
                        return;
                    }
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    private void scrollPopupToTypedWord() {
        Word curWord = this.getCurrentTypedWord();
        if (curWord != null && curWord.getLength() > 0) {
            this.popPan.scrollOnSearchText(curWord.toString());
        } else {
            this.popPan.setSelectedIndex(0);
        }
    }

    public void itemSelected(Object selectedItem) {
        if (selectedItem instanceof String) {
            String newValue = (String)selectedItem;
            this.processWordChange(newValue);
        } else if (selectedItem instanceof EditorPopupItem) {
            EditorPopupItem curItem = (EditorPopupItem)selectedItem;
            if (curItem.getCategory() != null && curItem.getCategory().doNeedProcessing()) {
                this.processPopupContents(curItem);
            } else {
                this.processWordChange(curItem.getContents());
            }
        }
    }

    private void closeFormula() {
        this.closeTemplate();
        this.formHlParts.removeAllElements();
        this.formulaCashe.add(this.curFormula);
        this.curFormula = null;
    }

    private void closeTemplate() {
        this.emode = EditMode.Normal;
        this.deHightlightUserFields();
        this.userFields.removeAllElements();
    }

    private boolean checkFormulaActivation(int curPos) {
        if (this.formulaCashe.size() > 0) {
            for (int i = 0; i < this.formulaCashe.size(); ++i) {
                Formula formula = this.formulaCashe.get(this.formulaCashe.size() - i - 1);
                DocTextPart formParam = formula.getParamAtPos(curPos);
                if (formParam == null) continue;
                this.checkFormulaFieldValueChange(formParam, formula);
                this.updateFormula(formula);
                return true;
            }
        }
        return false;
    }

    private void hidePopup() {
        this.popPan.setVisible(false);
        this.remove(this.popPan);
        this.repaint();
    }

    private void processPopupContents(EditorPopupItem item) {
        int formIndex;
        System.out.println("Should be processing the template now ... ");
        int crtPos = this.getCaretPosition();
        this.processWordChange(this.processEL(item.getContents()));
        if (this.curFormula != null && (formIndex = this.getText().indexOf(this.curFormula.getFieldValue(), crtPos)) != -1) {
            this.stDoc.setCharacterAttributes(formIndex, this.curFormula.getFieldValue().length(), this.formulasStyle, true);
            this.curFormula.setFieldPos(this.doCreatePosition(formIndex));
        }
    }

    private Position doCreatePosition(int index) {
        try {
            return this.getDocument().createPosition(index);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String processEL(String value) {
        this.curFormula = null;
        this.userFields.removeAllElements();
        this.formHlParts.removeAllElements();
        StringBuilder sb = new StringBuilder(value);
        int start = 0;
        int end = 0;
        while ((start = value.indexOf("${")) != -1) {
            String elVariable;
            String varValue;
            end = value.indexOf("}", start + 2);
            if (end == -1 || (varValue = this.getELValue(elVariable = value.substring(start + 2, end))) == null) continue;
            sb.replace(start, end + 1, varValue);
            value = sb.toString();
        }
        if (this.curFormula != null) {
            for (DocTextPart curPart : this.formHlParts) {
                if (this.curFormula.containsParameter(curPart.getFieldID())) continue;
                this.formHlParts.remove(curPart);
                break;
            }
            this.curFormula.importDocParams(this.formHlParts);
        }
        return sb.toString();
    }

    private String getELValue(String src) {
        int sepPos = src.indexOf(58);
        if (sepPos != -1) {
            String itemName;
            String categID = src.substring(0, sepPos);
            EditorPopupItem item = this.model.getItemForCategory(categID, itemName = src.substring(sepPos + 1));
            if (item != null) {
                this.formHlParts.add(new DocTextPart(item.getContents()));
                return item.getContents();
            }
            switch (PopupCategory.evaluate(categID)) {
                case User: {
                    EditorUserField newFld = new EditorUserField(itemName);
                    newFld.setFieldIndex(this.userFields.size());
                    this.userFields.add(newFld);
                    this.formHlParts.add(newFld);
                    return itemName;
                }
                case Formula: {
                    this.parseFormula(itemName);
                    return this.curFormula.getFieldID();
                }
                case Editor: {
                    return this.processEditorCommands(itemName);
                }
            }
        }
        return src;
    }

    private String processEditorCommands(String commandValue) {
        if (commandValue != null && !commandValue.isEmpty()) {
            EditorCommand command = EditorCommand.evaluate(commandValue);
            switch (command) {
                case Cursor: {
                    EditorUserField newFld = new EditorUserField("|", DocTextPart.Type.Editor);
                    newFld.setFieldIndex(this.userFields.size());
                    this.userFields.add(newFld);
                    return "|";
                }
            }
        }
        return null;
    }

    private void parseFormula(String formText) {
        String formName = formText.substring(0, formText.indexOf(40));
        String allParamTxt = formText.substring(formText.indexOf(40) + 1, formText.indexOf(41));
        this.curFormula = new Formula(formName, "");
        this.curFormula.setFieldValue(formName);
        for (String curParam : allParamTxt.split(",")) {
            String paramValue = this.model.getFormulaParameterValue(curParam);
            this.curFormula.addParameter(curParam, paramValue);
        }
    }

    private void processWordChange(String newValue) {
        try {
            Word curWrd = this.getCurrentTypedWord();
            int insertPos = this.getCaretPosition();
            if (this.curWord.getLength() > 0) {
                this.getDocument().remove(curWrd.getStart(), curWrd.getLength());
                insertPos = curWrd.getStart();
            }
            this.getDocument().insertString(insertPos, newValue, this.templateStyle);
            if (this.curFormula != null && this.formHlParts.size() > 0) {
                this.highlightFormulaFields(insertPos);
                this.emode = EditMode.Formula;
            }
            if (this.userFields.size() > 0) {
                this.highlightUserFields(insertPos);
                this.filterEditorFields();
                if (this.emode == EditMode.Normal) {
                    this.emode = EditMode.Template;
                }
            }
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        this.popPan.setVisible(false);
        this.remove(this.popPan);
        this.repaint();
    }

    private void filterEditorFields() throws BadLocationException {
        for (DocTextPart docTextPart : this.userFields) {
            if (docTextPart.getType() != DocTextPart.Type.Editor || !docTextPart.getFieldValue().equals("|")) continue;
            this.getDocument().remove(docTextPart.getFieldPos().getOffset(), 1);
        }
    }

    private void highlightFormulaFields(int start) {
        for (DocTextPart curField : this.formHlParts) {
            int userFieldPos = this.getText().indexOf(curField.fieldValue, start);
            if (userFieldPos == -1) continue;
            this.stDoc.setCharacterAttributes(userFieldPos, curField.fieldValue.length(), this.formulaFieldStyle, true);
            try {
                curField.fieldPos = this.getDocument().createPosition(userFieldPos);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getText() {
        return this.doFilterExtraChars(super.getText());
    }

    private String doFilterExtraChars(String curValue) {
        System.out.println("Filtering");
        StringBuilder sb = new StringBuilder();
        for (char curChar : curValue.toCharArray()) {
            if (curChar == '\r') continue;
            sb.append(curChar);
        }
        return sb.toString();
    }

    private void paintEditorFields(Graphics2D g) {
        if (this.userFields.size() > 0) {
            for (EditorUserField curField : this.userFields) {
                if (curField.getType() != DocTextPart.Type.Editor || !curField.getFieldValue().equals("|")) continue;
                try {
                    Rectangle rect = this.getUI().modelToView(this, curField.getFieldPos().getOffset());
                    g.setColor(new Color(0, 0, 250, 80));
                    g.draw(rect);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void highlightUserFields(int start) {
        boolean firstLocate = true;
        int firstPos = 0;
        int firstLength = 0;
        for (EditorUserField curField : this.userFields) {
            int userFieldPos = this.getText().indexOf(curField.fieldValue, start);
            if (userFieldPos == -1) continue;
            if (curField.getType() != DocTextPart.Type.Editor) {
                this.stDoc.setCharacterAttributes(userFieldPos, curField.fieldValue.length(), this.userFieldsStyle, true);
            }
            try {
                curField.fieldPos = this.getDocument().createPosition(userFieldPos);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            if (!firstLocate) continue;
            firstPos = userFieldPos;
            firstLength = curField.fieldValue.length();
            firstLocate = false;
        }
        this.curUFieldInd = 0;
        this.curUFieldPos = firstPos;
        this.setSelectedText(firstPos, firstLength);
    }

    private void deHightlightUserFields() {
        for (EditorUserField curField : this.userFields) {
            this.stDoc.setCharacterAttributes(curField.getFieldPos().getOffset(), curField.fieldValue.length(), this.defaultTextStyle, true);
        }
    }

    private void setSelectedText(int firstPos, int length) {
        this.setCaretPosition(firstPos);
        this.setSelectionStart(firstPos);
        this.setSelectionEnd(firstPos + length);
    }

    private void setSelectedUserField(EditorUserField usrFld) {
        switch (usrFld.getType()) {
            case Editor: {
                if (!usrFld.fieldValue.equals("|")) break;
                this.setCaretPosition(usrFld.fieldPos.getOffset());
                break;
            }
            default: {
                this.setSelectedText(usrFld.fieldPos.getOffset(), usrFld.fieldValue.length());
            }
        }
    }

    private void moveToNextUserField(boolean forward) {
        EditorUserField prevField = this.userFields.get(this.curUFieldInd);
        if (this.emode == EditMode.Formula) {
            this.checkFormulaFieldValueChange(prevField, this.curFormula);
        }
        if (this.emode == EditMode.Template) {
            this.updateFieldValue(prevField);
        }
        if (this.curUFieldInd + 1 < this.userFields.size()) {
            ++this.curUFieldInd;
        } else if (this.curUFieldInd + 1 == this.userFields.size()) {
            this.curUFieldInd = 0;
        }
        EditorUserField nxtField = this.userFields.get(this.curUFieldInd);
        this.setSelectedUserField(nxtField);
    }

    private void checkFormulaFieldValueChange(DocTextPart frmFld, Formula targeFormula) {
        if (this.updateFieldValue(frmFld) && targeFormula != null && targeFormula.containsParameter(frmFld.fieldID)) {
            targeFormula.addParameter(frmFld.fieldID, frmFld.fieldValue);
            this.updateFormula(targeFormula);
        }
    }

    private boolean updateFieldValue(DocTextPart part) {
        try {
            String curDocVal = null;
            curDocVal = part.fieldPos.getOffset() + part.fieldValue.length() > this.getText().length() ? this.getText(part.fieldPos.getOffset(), this.getText().length() - part.fieldPos.getOffset()) : this.getText(part.fieldPos.getOffset(), part.fieldValue.length());
            if (curDocVal == null || !curDocVal.equals(part.fieldValue)) {
                StringBuilder sb = new StringBuilder();
                char curChar = ' ';
                int index = part.fieldPos.getOffset();
                while (true) {
                    char c = this.getText().charAt(--index);
                    curChar = c;
                    if (c == ' ' || SMYLDTextEditor.isWordSeparator(curChar)) break;
                    sb.insert(0, curChar);
                }
                System.out.println("New Value is : " + sb.toString());
                part.fieldValue = sb.toString();
                part.fieldPos = this.getDocument().createPosition(index + 1);
                return true;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void updateFormula(Formula targetFormula) {
        try {
            int oldOffset = targetFormula.getFieldPos().getOffset();
            this.getDocument().remove(oldOffset, targetFormula.getFieldValue().length());
            targetFormula.setFieldValue(this.model.processFormula(targetFormula));
            this.getDocument().insertString(targetFormula.getFieldPos().getOffset(), targetFormula.getFieldValue(), this.formulasStyle);
            targetFormula.setFieldPos(this.doCreatePosition(oldOffset));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void processWordListPopup() {
        this.curWord = this.getCurrentTypedWord();
        if (this.popPan == null) {
            this.popPan = new EditorPopupPanel(this, this.model);
        }
        if (!this.popPan.isVisible()) {
            int index = this.getCaretPosition();
            if (this.curWord.getLength() > 0) {
                index = this.curWord.getStart();
            }
            Rectangle rect = null;
            try {
                rect = this.getUI().modelToView(this, index);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            if (rect == null) {
                System.out.println("The rect is null !! :(");
                return;
            }
            System.out.println("The rect position is : " + rect.toString());
            this.popPan.setLocation(rect.x + rect.width, rect.y + rect.height);
            this.popPan.setSize(this.popWidth, this.popHeight);
            this.scrollPopupToTypedWord();
            this.add(this.popPan);
            this.popPan.setVisible(true);
        }
    }

    public void setOwner(Window owner) {
        owner.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                SMYLDTextEditor.this.popPan.setVisible(false);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                if (SMYLDTextEditor.this.popPan.isVisible()) {
                    // empty if block
                }
            }
        });
    }

    private static boolean isWordSeparator(char aChar) {
        for (int i = 0; i < WORD_SEPARATORS.length; ++i) {
            if (aChar != WORD_SEPARATORS[i]) continue;
            return true;
        }
        return false;
    }

    private Word getCurrentTypedWord() {
        Word word = new Word();
        int position = this.getCaretPosition();
        if (position == 0) {
            return word;
        }
        int index = position - 1;
        boolean found = false;
        while (index > 0 && !found) {
            char current = this.getText().charAt(index);
            if (SMYLDTextEditor.isWordSeparator(current)) {
                found = true;
                ++index;
                continue;
            }
            --index;
        }
        word.setBounds(index, position - index);
        return word;
    }

    private static void testChar() {
        String chk = "\f";
        for (char curChar : chk.toCharArray()) {
            System.out.println("Cur Char Value : " + curChar);
        }
    }

    public EditorPopupModel getModel() {
        return this.model;
    }

    public void setModel(EditorPopupModel model) {
        this.model = model;
    }

    static Point convertScreenLocationToParent(Container parent, int x, int y) {
        for (Container p = parent; p != null; p = p.getParent()) {
            if (!(p instanceof Window)) continue;
            Point point = new Point(x, y);
            SwingUtilities.convertPointFromScreen(point, parent);
            return point;
        }
        throw new Error("convertScreenLocationToParent: no window ancestor");
    }

    public void serviceCommand(FormatCommand command) {
        switch (command) {
            default: 
        }
    }

    private static void testComponent() {
        SMYLDFrame testFrame = new SMYLDFrame("SMYLD Text Editor");
        testFrame.setSize(800, 600);
        testFrame.setDefaultCloseOperation(3);
        SMYLDTextEditor.addToolBar(testFrame);
        testFrame.add((Component)editor, "Center");
        testFrame.setLocationRelativeTo(null);
        testFrame.setVisible(true);
    }

    private static void addToolBar(SMYLDFrame frame) {
        Resource res = Resource.getInstance();
        SMYLDToolbar toolbar = new SMYLDToolbar();
        toolbar.add((Component)SMYLDTextEditor.createButton(FormatCommand.AlignLeft.name(), "format-justify-left.png", new StyledEditorKit.AlignmentAction("left-justify", 0)), "cmdAlignLeft");
        toolbar.add((Component)SMYLDTextEditor.createButton(FormatCommand.AlignCenter.name(), "format-justify-center-horizontal.png", new StyledEditorKit.AlignmentAction("center-justify", 1)), "cmdAlignCenter");
        toolbar.add((Component)SMYLDTextEditor.createButton(FormatCommand.AlignRight.name(), "format-justify-right.png", new StyledEditorKit.AlignmentAction("right-justify", 2)), "cmdAlignRight");
        toolbar.addSeparator();
        toolbar.add((Component)SMYLDTextEditor.createButton(FormatCommand.Bold.name(), "format-text-bold.png", new StyledEditorKit.BoldAction()), "cmdBold");
        toolbar.add((Component)SMYLDTextEditor.createButton(FormatCommand.Italic.name(), "format-text-italic.png", new StyledEditorKit.ItalicAction()), "cmdItalic");
        Object[] fontSizes = new String[]{"8", "10", "12", "14", "16", "18", "24", "36", "48"};
        final SMYLDComboBox size = new SMYLDComboBox(fontSizes);
        toolbar.add((Component)size, "fontSizeCombo");
        Object[] fonts = new String[]{"Times New Roman", "Arial", "Arial Black"};
        final SMYLDComboBox fontsCombo = new SMYLDComboBox(fonts);
        size.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setFontSize(attr, Integer.parseInt((String)size.getSelectedItem()));
                editor.setCharacterAttributes(attr, false);
            }
        });
        fontsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setFontFamily(attr, (String)fontsCombo.getSelectedItem());
                editor.setCharacterAttributes(attr, false);
            }
        });
        toolbar.add((Component)fontsCombo, "fontsCombo");
        toolbar.addSeparator();
        toolbar.addSeparator();
        SMYLDButton fntColorBut = SMYLDTextEditor.createButton(FormatCommand.FontColor.name(), "format-text-color.png");
        fntColorBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color result = JColorChooser.showDialog(editor, "Font Color", Color.BLACK);
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setForeground(attr, result);
                editor.setCharacterAttributes(attr, false);
            }
        });
        toolbar.add((Component)fntColorBut, "cmdFontColor");
        toolbar.setActionListener(new ActionHandler(){

            @Override
            public void processGUIAction(GUIAction incomingAction) {
                System.out.println("Hi There " + incomingAction.getCommand());
                editor.serviceCommand(FormatCommand.valueOf(incomingAction.getCommand()));
            }
        });
        frame.setToolbar(toolbar);
    }

    private static SMYLDButton createButton(String actionCommand, String iconName) {
        return SMYLDTextEditor.createButton(actionCommand, iconName, null);
    }

    private static SMYLDButton createButton(String actionCommand, String iconName, Action butAction) {
        GUIAction action = new GUIAction();
        action.setCommand(actionCommand);
        SMYLDButton newBut = new SMYLDButton(action, "", Resource.getInstance().getImageIcon(iconName));
        if (butAction != null) {
            newBut.setActionCommand("Name");
            newBut.addActionListener(butAction);
        }
        return newBut;
    }

    public static void main(String[] args) {
        SMYLDTextEditor.testComponent();
    }

    static {
        WORD_SEPARATORS = new char[]{' ', '\n', '\t', '.', ',', ';', '!', '?', '\'', '(', ')', '[', ']', '\"', '{', '}', '/', '\\', '<', '>'};
    }

    static enum EditorCommand {
        Cursor,
        Others;


        public static EditorCommand evaluate(String value) {
            if (value != null && value.equals("cursor")) {
                return Cursor;
            }
            return Others;
        }
    }

    static enum EditMode {
        Formula,
        Normal,
        Popup,
        Template;

    }

    static enum FormatCommand {
        AlignLeft,
        AlignCenter,
        AlignRight,
        Fill,
        FontSize,
        FontColor,
        FontFace,
        Bold,
        Italic;

    }

    static enum PopupCategory {
        User,
        Formula,
        Editor,
        Others;


        public static PopupCategory evaluate(String value) {
            if (value != null) {
                if (value.equals("user")) {
                    return User;
                }
                if (value.equals("formula")) {
                    return Formula;
                }
                if (value.equals("edit")) {
                    return Editor;
                }
            }
            return Others;
        }
    }

    private class Word {
        private int theWordStart = -1;
        private int theWordLength = 0;

        public void setBounds(int aStart, int aLength) {
            this.theWordStart = Math.max(-1, aStart);
            this.theWordLength = Math.max(0, aLength);
            if (this.theWordStart == -1) {
                this.theWordLength = 0;
            }
            if (this.theWordLength == 0) {
                this.theWordStart = -1;
            }
        }

        public void increaseLength(int newCharLength) {
            int max = SMYLDTextEditor.this.instance.getText().length() - this.theWordStart;
            this.theWordLength = Math.min(max, this.theWordLength + newCharLength);
            if (this.theWordLength == 0) {
                this.theWordStart = -1;
            }
        }

        public void decreaseLength(int removedCharLength) {
            this.theWordLength = Math.max(0, this.theWordLength - removedCharLength);
            if (this.theWordLength == 0) {
                this.theWordStart = -1;
            }
        }

        public int getStart() {
            return this.theWordStart;
        }

        public int getLength() {
            return this.theWordLength;
        }

        public int getEnd() {
            return this.theWordStart + this.theWordLength;
        }

        public String toString() {
            String toReturn = null;
            try {
                toReturn = SMYLDTextEditor.this.instance.getText(this.theWordStart, this.theWordLength);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (toReturn == null) {
                toReturn = "";
            }
            return toReturn;
        }
    }
}

