/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import org.smyld.gui.SMYLDPopupMenu;
import org.smyld.gui.event.ActionHandler;
import org.smyld.gui.tree.SMYLDTreeCellRenderer;
import org.smyld.gui.tree.SMYLDTreeModel;
import org.smyld.gui.tree.SMYLDTreeNode;

public class SMYLDTree
extends JTree {
    private static final long serialVersionUID = 5886670601013061210L;
    SMYLDTreeCellRenderer smyldCellRenderer;
    SMYLDTreeModel smyldModel;
    Color selectionColor;
    ActionHandler actionHandler;
    SMYLDTree instance;
    SMYLDPopupMenu popupMenu;
    int actionClicksNo = 2;

    public SMYLDTree() {
        this.init();
    }

    public SMYLDTree(SMYLDTreeModel model) {
        this.init(model);
    }

    public SMYLDTree(SMYLDTreeModel model, ActionHandler handler) {
        this.actionHandler = handler;
        this.init(model);
    }

    public SMYLDTree(SMYLDTreeNode treeNode, ActionHandler treeActionHandler) {
        this.actionHandler = treeActionHandler;
        this.init(treeNode);
    }

    public SMYLDTree(SMYLDTreeNode treeNode, ActionHandler treeActionHandler, SMYLDPopupMenu treePopupMenu) {
        this.popupMenu = treePopupMenu;
        this.actionHandler = treeActionHandler;
        this.init(treeNode);
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void collapsAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.collapseRow(i);
        }
    }

    private void init(SMYLDTreeModel model) {
        this.setModel(model);
        this.smyldModel = model;
        DefaultTreeSelectionModel treeSelector = new DefaultTreeSelectionModel();
        treeSelector.setSelectionMode(4);
        this.setSelectionModel(treeSelector);
        this.smyldCellRenderer = new SMYLDTreeCellRenderer();
        this.setCellRenderer(this.smyldCellRenderer);
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        this.instance = this;
        if (this.actionHandler != null) {
            this.activateActionHandler();
        }
    }

    public void activateActionHandler() {
        if (this.actionHandler != null) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    TreePath selectionPath;
                    if (evt.getClickCount() == SMYLDTree.this.actionClicksNo && (selectionPath = SMYLDTree.this.instance.getSelectionPath()) != null) {
                        SMYLDTreeNode current = (SMYLDTreeNode)selectionPath.getLastPathComponent();
                        if (SMYLDTree.this.actionHandler != null && current != null && current.getGUIAction() != null) {
                            SMYLDTree.this.actionHandler.processGUIAction(current.getGUIAction());
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.getButton() == 3) {
                        SMYLDTreeNode selectedNode = SMYLDTree.this.getSelectedItem();
                        if (selectedNode != null && selectedNode.getPopupMenu() != null) {
                            selectedNode.getPopupMenu().show((Component)evt.getSource(), evt.getX(), evt.getY());
                        }
                        if (SMYLDTree.this.popupMenu != null) {
                            SMYLDTree.this.popupMenu.show(SMYLDTree.this.instance, evt.getX(), evt.getY());
                        }
                    }
                }
            });
        }
    }

    public void setActionHandler(ActionHandler newActionHandler) {
        this.actionHandler = newActionHandler;
        this.activateActionHandler();
    }

    public void setActionHandler(ActionHandler newActionHandler, int clicksNo) {
        this.actionClicksNo = clicksNo;
        this.setActionHandler(newActionHandler);
    }

    public void setActionFiringClicks(int clicksNo) {
        this.actionClicksNo = clicksNo;
    }

    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    public SMYLDTreeNode getSelectedItem() {
        TreePath selectionPath = this.instance.getSelectionPath();
        SMYLDTreeNode current = null;
        if (selectionPath != null) {
            current = (SMYLDTreeNode)selectionPath.getLastPathComponent();
        }
        return current;
    }

    private void init() {
        SMYLDTreeNode rootNode = new SMYLDTreeNode("root", "Root");
        this.init(rootNode);
    }

    private void init(SMYLDTreeNode treeNode) {
        SMYLDTreeModel model = new SMYLDTreeModel(treeNode);
        this.init(model);
    }

    public void setRootNode(SMYLDTreeNode treeNode) {
        this.smyldModel.setRoot(treeNode);
    }

    public SMYLDTreeNode getRootNode() {
        return (SMYLDTreeNode)this.getModel().getRoot();
    }

    public void setSelectionBackGroundColor(Color color) {
        this.smyldCellRenderer.setSelBGColor(color);
    }

    public void setSelectionForGroundColor(Color color) {
        this.smyldCellRenderer.setSelFGColor(color);
    }

    public void addChild(SMYLDTreeNode parentNode, SMYLDTreeNode childNode) {
        childNode.applyComponentOrientation(this.getComponentOrientation());
        this.smyldModel.addChild(parentNode, childNode);
        super.scrollPathToVisible(new TreePath(childNode.getPathToRoot()));
    }

    public void removeChild(SMYLDTreeNode childNode) {
        this.smyldModel.removeNode(childNode);
    }

    public void setNormalBackGroundColor(Color color) {
        this.smyldCellRenderer.setNorBGColor(color);
    }

    public void setNormalForGroundColor(Color color) {
        this.smyldCellRenderer.setNorFGColor(color);
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(157, 300));
    }

    public SMYLDTreeNode getNode(String nodeID) {
        SMYLDTreeNode targetNode = null;
        if (this.getRootNode() != null) {
            if (this.getRootNode().getNodeID().equals(nodeID)) {
                return this.getRootNode();
            }
            targetNode = this.search(nodeID, this.getRootNode());
        }
        return targetNode;
    }

    private SMYLDTreeNode search(String nodeID, SMYLDTreeNode node) {
        Enumeration<SMYLDTreeNode> enums = node.children();
        while (enums.hasMoreElements()) {
            SMYLDTreeNode result;
            SMYLDTreeNode curNode = enums.nextElement();
            if (curNode.getNodeID().equals(nodeID)) {
                return curNode;
            }
            if (curNode.getChildCount() <= 0 || (result = this.search(nodeID, curNode)) == null) continue;
            return result;
        }
        return null;
    }
}

