/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui.panels;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Popup;
import org.smyld.gui.DateControl;
import org.smyld.gui.SMYLDPanel;
import org.smyld.resources.Resource;
import org.smyld.text.TextUtil;
import org.smyld.util.SMYLDDate;

public class DatePanel
extends SMYLDPanel {
    private static final long serialVersionUID = 1L;
    Image square;
    Image selSquare;
    Image rightArrow;
    Image leftArrow;
    Image rightOArrow;
    Image leftOArrow;
    Graphics2D g;
    int mouseX;
    int mouseY;
    int selX;
    int selY;
    int curSelection = -1;
    int firstDay;
    int maxDays;
    int curMonthDay;
    Dimension origSize;
    Point origPoint;
    Color bgColor;
    Color mouseOverColor;
    Color daysForegroundColor;
    Color daysSelectedColor;
    Color dayNamesFRColor;
    Color selBgColor;
    Color daysBgColor;
    Color headerBG;
    Color minimizedBGColor;
    boolean inSelect;
    boolean draw3D;
    boolean isPopedUp = false;
    boolean localResize = false;
    boolean localRelocated = false;
    boolean paintDown = true;
    boolean showAsCombo = true;
    boolean showDate = false;
    String[] days = new String[]{"Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"};
    GregorianCalendar cal;
    SMYLDDate date;
    String[] dayNames;
    String[] monthNames;
    Popup popWindow;
    DateControl origController;

    public DatePanel(SMYLDDate startDate) {
        this.date = startDate;
        this.init();
    }

    public DatePanel(SMYLDDate startDate, DateControl parentController) {
        this.showDate = true;
        this.date = startDate;
        this.origController = parentController;
        this.init();
    }

    public DatePanel() {
        this.init();
    }

    private void init() {
        System.out.println("Date Panel version 1.002");
        this.initDate();
        Resource resource = new Resource();
        this.bgColor = new Color(31, 120, 247);
        this.selBgColor = new Color(97, 7, 16);
        this.mouseOverColor = new Color(97, 7, 16);
        this.daysForegroundColor = new Color(6, 3, 24);
        this.daysSelectedColor = Color.yellow;
        this.daysBgColor = new Color(255, 255, 255, 20);
        this.minimizedBGColor = Color.WHITE;
        this.dayNamesFRColor = Color.WHITE;
        this.headerBG = new Color(31, 64, 174);
        this.square = resource.getImage("square_3d_w.png");
        this.selSquare = resource.getImage("square_3d_dr.png");
        this.rightArrow = resource.getImage("arrowr_3d_w.png");
        this.rightOArrow = resource.getImage("arrowr_3d_dr.png");
        this.leftArrow = resource.getImage("arrowl_3d_w.png");
        this.leftOArrow = resource.getImage("arrowl_3d_dr.png");
        this.setBackground(this.minimizedBGColor);
        this.setForeground(this.daysForegroundColor);
        if (!this.showDate && this.origSize == null) {
            this.origSize = this.getComboSize();
        } else if (this.showDate) {
            this.origSize = this.getPopSize();
        }
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                DatePanel.this.mouseX = evt.getX();
                DatePanel.this.mouseY = evt.getY();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DatePanel.this.selX = evt.getX();
                DatePanel.this.selY = evt.getY();
                DatePanel.this.inSelect = true;
                DatePanel.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DatePanel.this.selX = -1;
                DatePanel.this.selY = -1;
                DatePanel.this.isPopedUp = false;
                DatePanel.this.doHideMe();
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
            }
        });
    }

    private void doHideMe() {
        this.origController.isPopedUp = false;
    }

    private void initDate() {
        if (this.date == null) {
            this.date = new SMYLDDate("MMM");
        }
        this.cal = (GregorianCalendar)Calendar.getInstance();
        this.cal.setTime((Date)this.date);
        this.refreshDate();
    }

    private void refreshDate() {
        this.curSelection = this.cal.get(5);
        this.cal.set(5, 1);
        this.firstDay = this.cal.get(7);
        this.maxDays = this.cal.getActualMaximum(5);
    }

    @Override
    public void setSize(int width, int height) {
        if (!this.localResize) {
            this.origSize = new Dimension(width, height);
        }
        this.localResize = false;
    }

    @Override
    public void setSize(Dimension newSize) {
        if (!this.localResize) {
            this.origSize = newSize;
        }
        this.localResize = false;
    }

    @Override
    public void paintComponent(Graphics gr) {
        if (this.origPoint == null) {
            this.origPoint = this.getLocation();
        }
        this.g = (Graphics2D)gr;
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (this.isShowAsCombo()) {
            if (this.showDate || this.isPopedUp) {
                this.paintPoped();
            } else if (!this.isPopedUp) {
                this.paintUnPoped();
            }
        } else {
            this.paintUnPoped();
        }
        this.g.setStroke(new BasicStroke(2.1f, 1, 1));
        this.g.drawRoundRect(0, 0, this.getWidth(), this.getHeight(), 5, 5);
    }

    @Override
    public void setLocation(Point newPoint) {
        if (!this.localRelocated) {
            this.origPoint = newPoint;
        }
        super.setLocation(newPoint);
        this.localRelocated = false;
    }

    @Override
    public void setLocation(int x, int y) {
        if (!this.localRelocated) {
            this.origPoint = new Point(x, y);
        }
        super.setLocation(x, y);
        this.localRelocated = false;
    }

    private void paintUnPoped() {
        this.setOpaque(false);
        this.curMonthDay = 0;
        if (this.origSize == null) {
            this.origSize = this.getComboSize();
        }
        this.setSize(this.origSize);
        this.g.clearRect(this.origPoint.x, this.origPoint.y, this.origSize.width, this.origSize.height);
        this.g.setColor(this.getBackground());
        this.g.fillRect(0, 0, this.origSize.width, this.origSize.height);
        this.g.setColor(this.getForeground());
        this.g.setFont(new Font("Arial", 1, 12));
        this.g.drawString(this.date.toString("dd-MMM-yy"), 10, 15);
        if (this.isMousePointing(this.origSize.width - 20, 0, 20, 20)) {
            this.g.drawImage(this.rightOArrow, this.origSize.width - 20, 0, 20, 20, this.headerBG, null);
        } else {
            this.g.drawImage(this.rightArrow, this.origSize.width - 20, 0, 20, 20, this.headerBG, null);
        }
    }

    private Dimension getComboSize() {
        return new Dimension(100, 20);
    }

    private Dimension getPopSize() {
        return new Dimension(224, 256);
    }

    private void paintPoped() {
        if (this.showDate) {
            this.setOpaque(true);
            this.curMonthDay = 0;
            this.localResize = true;
            this.setSize(this.getPopSize());
            this.g.setColor(this.daysForegroundColor);
            this.g.setFont(new Font("Arial", 1, 12));
            int count = 0;
            for (int w = 0; w < 8; ++w) {
                if (w == 0) {
                    this.paintCalendarHeader();
                    continue;
                }
                block5: for (int d = 0; d < 7; ++d) {
                    switch (w) {
                        case 0: {
                            continue block5;
                        }
                        case 1: {
                            this.draw3D = false;
                            this.paintOn(d * 32, w * 32, this.days[d], this.dayNamesFRColor, false);
                            continue block5;
                        }
                        default: {
                            this.draw3D = false;
                            String text = "";
                            if (++count >= this.firstDay && count < this.firstDay + this.maxDays) {
                                ++this.curMonthDay;
                                text = Integer.toString(this.curMonthDay);
                            }
                            this.paintOn(d * 32, w * 32, text, this.daysForegroundColor, true);
                        }
                    }
                }
            }
        }
    }

    private void paintCalendarHeader() {
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, Color.BLUE, 224.0f, 32.0f, Color.BLACK, true);
        this.g.setPaint(gp);
        this.g.fillRect(0, 0, 224, 32);
        this.paintBetweenArrows(this.date.toString(), 25, 0);
        this.paintBetweenArrows(Integer.toString(this.cal.get(1)), 115, 0);
        if (this.inSelect) {
            if (this.isInside(25, 6, 20, 20, this.selX, this.selY)) {
                int origMonth = this.cal.get(2);
                this.cal.set(2, origMonth - 1);
                this.refreshDate();
                this.date.setTime(this.cal.getTime().getTime());
            } else if (this.isInside(76, 6, 20, 20, this.selX, this.selY)) {
                int origMonth = this.cal.get(2);
                this.cal.set(2, origMonth + 1);
                this.refreshDate();
                this.date.setTime(this.cal.getTime().getTime());
            } else if (this.isInside(115, 6, 20, 20, this.selX, this.selY)) {
                int origYear = this.cal.get(1);
                this.cal.set(1, origYear - 1);
                this.refreshDate();
                this.date.setTime(this.cal.getTime().getTime());
            } else if (this.isInside(173, 6, 20, 20, this.selX, this.selY)) {
                int origYear = this.cal.get(1);
                this.cal.set(1, origYear + 1);
                this.refreshDate();
                this.date.setTime(this.cal.getTime().getTime());
            }
            this.inSelect = false;
        }
    }

    private void paintBetweenArrows(String text, int x, int y) {
        int icSize = 20;
        int ydif = 6;
        int textW = 7 * text.length() + 10;
        this.g.setColor(new Color(0, 0, 0, 0));
        if (this.isMousePointing(x, ydif, 20, 20)) {
            this.g.drawImage(this.leftOArrow, x, ydif, icSize, icSize, null);
        } else {
            this.g.drawImage(this.leftArrow, x, ydif, icSize, icSize, null);
        }
        this.g.setColor(this.dayNamesFRColor);
        this.g.drawString(text, x + 25, 20);
        if (this.isMousePointing(x + textW + 20, ydif, 20, 20)) {
            this.g.drawImage(this.rightOArrow, x + textW + 20, ydif, icSize, icSize, null);
        } else {
            this.g.drawImage(this.rightArrow, x + textW + 20, ydif, icSize, icSize, null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.origSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.origSize;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.origSize;
    }

    private void paintOn(int x, int y, int count, Color textColor, boolean enableMouse) {
        this.paintOn(x, y, Integer.toString(count), textColor, enableMouse);
    }

    private void paintOn(int x, int y, String text, Color textColor, boolean enableMouse) {
        if (this.draw3D) {
            this.g.drawImage(this.square, x, y, 32, 32, null);
        } else {
            if (TextUtil.isNumeric((String)text) || TextUtil.isEmpty((String)text)) {
                this.g.setColor(this.daysBgColor);
            } else {
                this.g.setColor(this.bgColor);
            }
            this.g.fillRect(x, y, 32, 32);
        }
        if (enableMouse) {
            if (this.isSelected(x + 1, y + 1, 30, 30, text)) {
                this.g.setColor(this.selBgColor);
                if (this.draw3D) {
                    this.g.drawImage(this.selSquare, x, y, 32, 32, null);
                } else {
                    this.g.setColor(Color.BLACK);
                    this.g.fillOval(x + 1, y + 6, 31, 20);
                    this.g.setColor(this.selBgColor);
                    this.g.fillOval(x + 4, y + 9, 26, 14);
                }
                this.g.setColor(this.daysSelectedColor);
            } else if (this.isMousePointing(x + 1, y + 1, 30, 30)) {
                this.g.setColor(this.mouseOverColor);
            } else {
                this.g.setColor(textColor);
            }
        } else {
            this.g.setColor(textColor);
        }
        int pos = 13;
        if (text.length() == 2) {
            pos = 10;
        } else if (text.length() == 3) {
            pos = 5;
        }
        this.g.drawString(text, x + pos, y + 20);
    }

    private boolean isMousePointing(int x, int y, int w, int h) {
        return this.isInside(x, y, w, h, this.mouseX, this.mouseY);
    }

    private boolean isSelected(int x, int y, int w, int h, String text) {
        if (!this.isInside(x, y, w, h, this.selX, this.selY)) {
            if (TextUtil.isNumeric((String)text)) {
                return this.curSelection == Integer.parseInt(text);
            }
        } else if (TextUtil.isNumeric((String)text)) {
            this.curSelection = Integer.parseInt(text);
            this.cal.set(5, this.curSelection);
            this.date.setTime(this.cal.getTimeInMillis());
            this.refreshDate();
            return true;
        }
        return false;
    }

    private boolean isInside(int x, int y, int w, int h, int testX, int testY) {
        if (testX >= x && testX <= x + w) {
            return testY >= y && testY <= y + h;
        }
        return false;
    }

    public Date getSelectedDate() {
        return this.date;
    }

    public String[] getDayNames() {
        return this.dayNames;
    }

    public void setDayNames(String[] dayNames) {
        this.dayNames = dayNames;
    }

    public String[] getMonthNames() {
        return this.monthNames;
    }

    public void setMonthNames(String[] monthNames) {
        this.monthNames = monthNames;
    }

    public boolean isShowAsCombo() {
        return this.showAsCombo;
    }

    public void setShowAsCombo(boolean showAsCombo) {
        this.showAsCombo = showAsCombo;
    }
}

