/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JScrollPane;
import org.smyld.gui.SMYLDButton;
import org.smyld.gui.SMYLDEditorPane;
import org.smyld.gui.SMYLDPanel;
import org.smyld.gui.event.PageNavigationListener;
import org.smyld.resources.Resource;

public class InternetPanel
extends SMYLDPanel
implements PageNavigationListener {
    private static final long serialVersionUID = 1L;
    private URL homePage = null;
    private BorderLayout borderLayout1 = new BorderLayout();
    private FlowLayout flowLayout1 = new FlowLayout();
    private SMYLDPanel navigation = new SMYLDPanel();
    private SMYLDButton forwardBut = new SMYLDButton();
    private SMYLDButton backwardBut = new SMYLDButton();
    private SMYLDButton homeBut = new SMYLDButton();
    private JScrollPane container = new JScrollPane();
    private SMYLDEditorPane pane = new SMYLDEditorPane();

    public InternetPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public InternetPanel(URL page) {
        try {
            this.pane = new SMYLDEditorPane(page);
            this.setHomePage(page);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        Resource res = new Resource();
        this.pane.setActivateNavigation(true);
        this.pane.addPageListener(this);
        this.flowLayout1.setAlignment(0);
        this.backwardBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternetPanel.this.pane.goBack();
            }
        });
        this.forwardBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternetPanel.this.pane.goForward();
            }
        });
        this.homeBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternetPanel.this.pane.openPage(InternetPanel.this.getHomePage());
            }
        });
        this.forwardBut.setIcon(res.getImageIcon("arrow_right.gif"));
        this.forwardBut.setEnabled(false);
        this.backwardBut.setIcon(res.getImageIcon("arrow_left.gif"));
        this.homeBut.setIcon(res.getImageIcon("home.gif"));
        this.backwardBut.setEnabled(false);
        this.navigation.add(this.backwardBut);
        this.navigation.add(this.forwardBut);
        this.navigation.add(this.homeBut);
        this.navigation.setLayout(this.flowLayout1);
        this.setLayout(this.borderLayout1);
        this.container.setViewportView(this.pane);
        this.add((Component)this.container, "Center");
        this.add((Component)this.navigation, "North");
    }

    public void openPage(URL page) {
        this.pane.openPage(page);
        if (this.getHomePage() == null) {
            this.setHomePage(page);
        }
    }

    public void openPage(String page) {
        this.pane.openPage(page);
    }

    @Override
    public void pageNavigated(URL pageURL) {
        this.updateGUIStatus();
    }

    @Override
    public void pageForwarded(URL pageURL) {
        this.updateGUIStatus();
    }

    @Override
    public void pageBackwarded(URL pageURL) {
        this.updateGUIStatus();
    }

    private void updateGUIStatus() {
        if (this.pane.getHistorySize() > 0) {
            if (this.pane.getCurrentPageIndexInHistory() == 0) {
                this.forwardBut.setEnabled(true);
                this.backwardBut.setEnabled(false);
            } else if (this.pane.getCurrentPageIndexInHistory() == this.pane.getHistorySize() - 1) {
                this.forwardBut.setEnabled(false);
                this.backwardBut.setEnabled(true);
            } else {
                this.forwardBut.setEnabled(true);
                this.backwardBut.setEnabled(true);
            }
        } else {
            this.forwardBut.setEnabled(false);
            this.backwardBut.setEnabled(false);
        }
    }

    public URL getHomePage() {
        return this.homePage;
    }

    public void setHomePage(URL homePage) {
        this.homePage = homePage;
    }
}

