/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui.tree;

import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.smyld.gui.tree.SMYLDTreeNode;

public class SMYLDTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;
    protected boolean filterIsActive;

    public SMYLDTreeModel(TreeNode root) {
        this(root, false);
    }

    public SMYLDTreeModel(TreeNode root, boolean asksAllowsChildren) {
        this(root, false, false);
    }

    public SMYLDTreeModel(TreeNode root, boolean asksAllowsChildren, boolean filterIsActive) {
        super(root, asksAllowsChildren);
        ((SMYLDTreeNode)root).setModel(this);
        this.filterIsActive = filterIsActive;
    }

    public void insertNodeInto(SMYLDTreeNode newChild, SMYLDTreeNode parent, int index) {
        parent.insertNodeInto(newChild, index);
        int[] newIndexs = new int[]{index};
        this.nodesWereInserted(parent, newIndexs);
    }

    public void activateFilter(boolean newValue) {
        this.filterIsActive = newValue;
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((SMYLDTreeNode)node).isLeaf();
    }

    public boolean isActivatedFilter() {
        return this.filterIsActive;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        Object target = null;
        TreeNode parentNode = (TreeNode)parent;
        int targetIndex = parentNode.getIndex((TreeNode)child);
        return targetIndex;
    }

    @Override
    public Object getChild(Object parent, int index) {
        TreeNode target = null;
        if (this.filterIsActive && parent instanceof SMYLDTreeNode) {
            target = ((SMYLDTreeNode)parent).getChildAt(index, this.filterIsActive);
        }
        target = ((TreeNode)parent).getChildAt(index);
        return target;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        SMYLDTreeNode aNode = (SMYLDTreeNode)path.getLastPathComponent();
        aNode.setUserObject(newValue);
    }

    public void addChild(SMYLDTreeNode parentNode, SMYLDTreeNode childNode) {
        if (parentNode == null) {
            parentNode = (SMYLDTreeNode)this.getRoot();
        }
        int insertedIndex = parentNode.add(childNode);
        int[] newIndexs = new int[]{insertedIndex};
        this.nodesWereInserted(parentNode, newIndexs);
    }

    public void removeNode(SMYLDTreeNode node) {
        SMYLDTreeNode parent = (SMYLDTreeNode)node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int[] childIndex = new int[1];
        Object[] removedArray = new Object[1];
        childIndex[0] = parent.getIndex(node);
        parent.remove(childIndex[0]);
        removedArray[0] = node;
        this.nodesWereRemoved(parent, childIndex, removedArray);
    }

    @Override
    public int getChildCount(Object parent) {
        int count = 0;
        if (this.filterIsActive && parent instanceof SMYLDTreeNode) {
            count = ((SMYLDTreeNode)parent).getChildCount(this.filterIsActive);
        }
        count = ((TreeNode)parent).getChildCount();
        return count;
    }
}

