/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui.util;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.smyld.SMYLDObject;
import org.smyld.gui.dnd.DragableTransfereHandler;
import org.smyld.gui.event.DragableComponentListener;
import org.smyld.gui.panels.DockableContainer;

public class SMYLDGUIUtil
extends SMYLDObject {
    private static final long serialVersionUID = 1L;

    public static void setDragableComponent(JComponent component, DockableContainer container) {
        SMYLDGUIUtil.setDragableComponent(component, container, true);
    }

    public static void setDragableComponent(JComponent component, DockableContainer container, boolean isInternal) {
        final JComponent comp = component;
        final DockableContainer cont = container;
        final boolean internal = isInternal;
        comp.setTransferHandler(new DragableTransfereHandler(new DragableComponentListener(){

            @Override
            public void dragStarted() {
                cont.registerDragOperation(this);
            }

            @Override
            public void dragEnded() {
                cont.dropComponent(comp);
            }

            @Override
            public JComponent getComponent() {
                return comp;
            }

            @Override
            public boolean isInternal() {
                return internal;
            }
        }));
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                comp.getTransferHandler().exportAsDrag(comp, evt, 1);
            }
        });
    }

    public static Color getMiddleColor(Color col1, Color col2) {
        int resRed = (col1.getRed() + col2.getRed()) / 2;
        int resGreen = (col1.getGreen() + col2.getGreen()) / 2;
        int resBlue = (col1.getBlue() + col2.getBlue()) / 2;
        int resAlpha = (col1.getAlpha() + col2.getAlpha()) / 2;
        return new Color(resRed, resGreen, resBlue, resAlpha);
    }
}

