/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import org.smyld.SMYLDObject;
import org.smyld.gui.layout.SMYLDXYConstraints;

public class SMYLDXYLayout
extends SMYLDObject
implements LayoutManager2 {
    private static final long serialVersionUID = 3321184658198901341L;
    Container parentContainer;
    Insets borders;
    Dimension componentArea;
    HashMap<Component, Object> components = new HashMap();
    ComponentOrientation compOrient = ComponentOrientation.LEFT_TO_RIGHT;

    @Override
    public void removeLayoutComponent(Component comp) {
        this.components.remove(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getComponentsArea();
    }

    public void setComponentOrientation(ComponentOrientation orient) {
        this.compOrient = orient;
    }

    public ComponentOrientation getComponentOrientation() {
        return this.compOrient;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getComponentsArea();
    }

    private Dimension getComponentsArea() {
        int smallWidth = 0;
        int bigWidth = 0;
        int smallHeight = 0;
        int bigHeight = 0;
        for (Object curObject : this.components.values()) {
            SMYLDXYConstraints currPos = (SMYLDXYConstraints)((Object)curObject);
            if (currPos.getX() < smallWidth) {
                smallWidth = currPos.getX();
            }
            if (currPos.getX() + currPos.getWidth() > bigWidth) {
                bigWidth = currPos.getX() + currPos.getWidth();
            }
            if (currPos.getY() < smallHeight) {
                smallHeight = currPos.getY();
            }
            if (currPos.getY() + currPos.getHeight() <= bigHeight) continue;
            bigHeight = currPos.getY() + currPos.getHeight();
        }
        return new Dimension(bigWidth - smallWidth, bigHeight - smallHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.parentContainer = parent;
            this.borders = this.parentContainer.getInsets();
            for (Component currCmp : this.components.keySet()) {
                SMYLDXYConstraints currPos = (SMYLDXYConstraints)((Object)this.components.get(currCmp));
                this.allignComponent(currPos);
                currCmp.setBounds(this.allignComponent(currPos), currPos.getY(), currPos.getWidth(), currPos.getHeight());
            }
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof SMYLDXYConstraints) {
            SMYLDXYConstraints xyConst = (SMYLDXYConstraints)((Object)constraints);
            this.components.put(comp, (Object)xyConst);
        }
    }

    private int allignComponent(SMYLDXYConstraints constraints) {
        int result = constraints.getX();
        if (!this.compOrient.isLeftToRight()) {
            result = this.parentContainer.getWidth() - constraints.getX() - constraints.getWidth();
        }
        return result;
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.getComponentsArea();
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }
}

