/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui.edit;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.smyld.gui.SMYLDTextEditor;
import org.smyld.gui.edit.EditorPopupItem;
import org.smyld.gui.edit.EditorPopupItemCategory;
import org.smyld.gui.edit.EditorPopupModel;

public class EditorPopupPanel
extends JPanel {
    private SMYLDTextEditor parentComp;
    private PopList list;
    private MyScroll sp;
    private EditorPopupModel model;

    public EditorPopupPanel() {
        this.init();
    }

    public EditorPopupPanel(SMYLDTextEditor comp, EditorPopupModel model) {
        this.parentComp = comp;
        this.model = model;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 0));
        this.sp = new MyScroll();
        this.list = new PopList();
        this.sp.getViewport().add(this.list);
        this.sp.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.add((Component)this.sp, "Center");
        this.setVisible(false);
    }

    @Override
    public void paintComponent(Graphics gr) {
        super.paintComponent(gr);
    }

    public void setSelectedIndex(int index) {
        this.list.setSelectedIndex(index);
    }

    public Object getSelected() {
        return this.list.getSelectedValue();
    }

    public void scrollOnSearchText(String text) {
        this.list.scrollToSearch(text);
    }

    public void moveDown() {
        if (this.list.getSelectedIndex() < this.list.getModel().getSize() - 1) {
            this.setSelectedItem(this.list.getSelectedIndex() + 1);
        } else {
            this.setSelectedItem(0);
        }
    }

    private void setSelectedItem(int id) {
        this.list.setSelectedIndex(id);
        this.list.ensureIndexIsVisible(id);
    }

    public void moveUp() {
        if (this.list.getSelectedIndex() > 0) {
            this.setSelectedItem(this.list.getSelectedIndex() - 1);
        } else {
            this.setSelectedItem(this.list.getModel().getSize() - 1);
        }
    }

    public void movePageDown() {
        int vis = this.list.getVisibleRowCount();
        if (vis > 0) {
            if (this.list.getSelectedIndex() + vis <= this.list.getModel().getSize() - 1) {
                this.setSelectedItem(this.list.getSelectedIndex() + vis);
            } else {
                this.setSelectedItem(this.list.getModel().getSize() - 1);
            }
        }
    }

    public void movePageUp() {
        int vis = this.list.getVisibleRowCount();
        if (vis > 0) {
            if (this.list.getSelectedIndex() - vis >= 0) {
                this.setSelectedItem(this.list.getSelectedIndex() - vis);
            } else {
                this.setSelectedItem(0);
            }
        }
    }

    public class PopList
    extends JList {
        Composite alphComp = AlphaComposite.getInstance(3, 0.8f);
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 0), 0.0f, this.getHeight(), new Color(0, 0, 120));
        BasicStroke stroke = new BasicStroke(2.0f, 1, 1);

        public PopList() {
            this.init();
        }

        private void init() {
            super.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    PopList.this.setCursor(new Cursor(0));
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        EditorPopupPanel.this.parentComp.itemSelected(EditorPopupPanel.this.list.getSelectedValue());
                    }
                }
            });
            this.setCellRenderer(new MyListRenderer());
            this.setModel(new MyListModel(EditorPopupPanel.this.model));
        }

        public void scrollToSearch(String searchKey) {
            for (int i = 0; i < this.getModel().getSize(); ++i) {
                EditorPopupItem curItem = (EditorPopupItem)this.getModel().getElementAt(i);
                if (curItem == null || !curItem.getName().toLowerCase().matches("^" + searchKey.toLowerCase() + ".*")) continue;
                this.setSelectedIndex(i);
                this.ensureIndexIsVisible(i);
                break;
            }
        }

        @Override
        public void paintComponent(Graphics gr) {
            Graphics2D g = (Graphics2D)gr;
            Composite old = g.getComposite();
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            g.setComposite(this.alphComp);
            g.setPaint(this.paint);
            g.setColor(Color.BLACK);
            g.fillRect(1, 1, this.getWidth() - 1, this.getHeight() - 1);
            g.setStroke(this.stroke);
            g.drawRect(1, 1, this.getWidth() - 1, this.getHeight() - 1);
            this.setForeground(Color.WHITE);
            super.paintComponent(gr);
        }
    }

    class MyListRenderer
    extends DefaultListCellRenderer {
        MyListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof EditorPopupItem) {
                EditorPopupItem curItem = (EditorPopupItem)value;
                EditorPopupItemCategory curCateg = curItem.getCategory();
                this.setText(curItem.getName());
                if (curItem.getIcon() != null) {
                    this.setIcon(curItem.getIcon());
                } else if (curCateg.getIcon() != null) {
                    this.setIcon(curCateg.getIcon());
                }
                this.setForeground(isSelected ? Color.YELLOW : Color.WHITE);
                this.setBackground(isSelected ? new Color(0, 0, 120) : new Color(0, 0, 50));
                this.revalidate();
                return this;
            }
            return this;
        }
    }

    class MyListModel
    extends DefaultListModel {
        EditorPopupModel myModel;

        public MyListModel(EditorPopupModel popModel) {
            this.myModel = popModel;
            this.init();
        }

        private void init() {
            for (int i = 0; i < this.myModel.getItemsCount(); ++i) {
                super.add(i, this.myModel.getItemAt(i));
            }
        }
    }

    class MyScroll
    extends JScrollPane {
        public MyScroll() {
            this.init();
        }

        private void init() {
            super.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    MyScroll.this.setCursor(new Cursor(12));
                }
            });
        }
    }
}

