/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui.tree;

import java.awt.ComponentOrientation;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.tree.TreeNode;
import org.smyld.SMYLDObject;
import org.smyld.gui.GUIAction;
import org.smyld.gui.SMYLDButton;
import org.smyld.gui.SMYLDLabel;
import org.smyld.gui.SMYLDMenuClass;
import org.smyld.gui.SMYLDPopupMenu;
import org.smyld.gui.event.ActionHandler;
import org.smyld.gui.tree.SMYLDTreeModel;

public class SMYLDTreeNode
extends SMYLDObject
implements TreeNode,
SMYLDMenuClass {
    private static final long serialVersionUID = 2187133357488282035L;
    Vector<SMYLDTreeNode> items;
    String nodeLable;
    String nodeID;
    String ActionCommand;
    String toolTipText;
    ActionHandler actHandler;
    GUIAction guiAction;
    ImageIcon nodeIcon;
    SMYLDLabel guiItem;
    Object userObject;
    SMYLDPopupMenu popUp;
    private int[] visibles;
    boolean visible = true;
    boolean enabled = true;
    boolean allowChildren = true;
    public boolean debug = false;
    ComponentOrientation cmpOrient;
    SMYLDTreeNode parent;
    SMYLDTreeModel model;
    int level;

    public SMYLDTreeNode() {
    }

    public SMYLDTreeNode(String ID, String NodeLable) {
        this();
        this.nodeID = ID;
        this.nodeLable = NodeLable;
    }

    public SMYLDTreeNode(String ID, String NodeLable, SMYLDObject UserObject) {
        this(ID, NodeLable);
        this.userObject = UserObject;
    }

    public SMYLDTreeNode(String ID, boolean AllowChildren, String NodeLable) {
        this(ID, NodeLable);
        this.allowChildren = AllowChildren;
    }

    public SMYLDTreeNode(String ID, String NodeLable, ImageIcon NodeIcon) {
        this(ID, NodeLable);
        this.nodeIcon = NodeIcon;
    }

    public SMYLDTreeNode(String ID, String NodeLable, String tooltipText, ImageIcon NodeIcon) {
        this(ID, NodeLable);
        this.toolTipText = tooltipText;
        this.nodeIcon = NodeIcon;
    }

    public SMYLDTreeNode(String ID, String NodeLable, ImageIcon NodeIcon, String Action2) {
        this(ID, NodeLable, NodeIcon);
        this.setActionCommand(Action2);
    }

    public SMYLDTreeNode(GUIAction itemAction) {
        this(itemAction.getID(), itemAction.getLabel());
        this.guiAction = itemAction;
    }

    public SMYLDTreeNode(GUIAction itemAction, String ID, String NodeLabel, ImageIcon NodeIcon) {
        this(ID, NodeLabel, NodeIcon);
        this.guiAction = itemAction;
    }

    public SMYLDTreeNode(GUIAction itemAction, String ID, String NodeLabel) {
        this(ID, NodeLabel);
        this.guiAction = itemAction;
    }

    public SMYLDTreeNode(GUIAction itemAction, String ID) {
        this(ID, itemAction.getLabel());
        this.guiAction = itemAction;
    }

    public SMYLDTreeNode(String ID, ImageIcon NodeIcon, GUIAction itemAction) {
        this(ID, itemAction.getLabel(), NodeIcon);
        this.guiAction = itemAction;
    }

    public void add(SMYLDMenuClass menuClass) {
        if (menuClass == null) {
            return;
        }
        if (menuClass instanceof SMYLDTreeNode) {
            this.add((SMYLDTreeNode)menuClass);
        }
    }

    public int add(SMYLDTreeNode newChildNode) {
        this.setChildInfo(newChildNode);
        if (this.items.add(newChildNode)) {
            return this.items.indexOf(newChildNode);
        }
        return -1;
    }

    public void insertNodeInto(SMYLDTreeNode newChildNode, int index) {
        this.setChildInfo(newChildNode);
        this.items.add(index, newChildNode);
    }

    private void setChildInfo(SMYLDTreeNode newChildNode) {
        if (this.items == null) {
            this.items = new Vector();
        }
        newChildNode.setParent(this);
        newChildNode.setLevel(this.getLevel() + 1);
        if (this.getModel() != null) {
            newChildNode.setModel(this.getModel());
        }
    }

    public TreeNode[] getPathToRoot() {
        if (this.getLevel() < 0) {
            return null;
        }
        int pathLength = this.getLevel() + 1;
        TreeNode[] path = new TreeNode[pathLength];
        SMYLDTreeNode curNode = this;
        for (int i = 0; i < pathLength; ++i) {
            path[pathLength - 1 - i] = curNode;
            curNode = (SMYLDTreeNode)curNode.getParent();
        }
        return path;
    }

    public void setPopupMenu(SMYLDPopupMenu menu) {
        this.popUp = menu;
        if (this.guiItem == null) {
            this.createGUI();
        }
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        SMYLDTreeNode target = null;
        if (this.items != null && this.items.size() > childIndex) {
            target = this.items.get(childIndex);
        }
        return target;
    }

    public TreeNode getChild(String nodeID) {
        Enumeration<SMYLDTreeNode> enums = this.children();
        while (enums.hasMoreElements()) {
            SMYLDTreeNode curNode = enums.nextElement();
            if (curNode.getNodeID() == null || !curNode.getNodeID().equals(nodeID)) continue;
            return curNode;
        }
        return null;
    }

    @Override
    public int getChildCount() {
        int count = 0;
        if (this.items != null) {
            count = this.items.size();
        }
        return count;
    }

    @Override
    public TreeNode getParent() {
        String parentText = "null";
        if (this.parent != null) {
            parentText = this.parent.getText();
        }
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        int index = this.items.indexOf(node);
        return index;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.allowChildren;
    }

    public ImageIcon getNodeImage() {
        return this.nodeIcon;
    }

    public void setNodeImage(ImageIcon NodeIcon) {
        this.nodeIcon = NodeIcon;
    }

    @Override
    public String getText() {
        return this.getGuiItem().getText();
    }

    @Override
    public void setText(String newLabel) {
        this.nodeLable = newLabel;
        if (this.guiItem != null) {
            this.guiItem.setText(newLabel);
            this.refreshGUI();
        }
    }

    private void refreshGUI() {
        this.guiItem.refresh();
        if (this.model != null) {
            this.model.nodeChanged(this);
        }
    }

    public void remove(int childIndex) {
        SMYLDTreeNode child = (SMYLDTreeNode)this.getChildAt(childIndex);
        this.items.removeElementAt(childIndex);
        child.setParent(null);
    }

    public void removeChildren() {
        if (this.items != null) {
            this.items.removeAllElements();
            int[] indices = new int[this.items.size()];
            for (int i = 0; i < this.items.size(); ++i) {
                indices[i] = i;
            }
            this.model.nodesWereRemoved(this, indices, this.items.toArray());
        }
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public Enumeration<SMYLDTreeNode> children() {
        if (this.items != null) {
            return this.items.elements();
        }
        return null;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
        if (this.guiItem != null) {
            this.guiItem.setText(nodeID);
            this.refreshGUI();
        } else {
            this.createGUI();
        }
    }

    public SMYLDLabel getGuiItem() {
        if (this.guiItem == null) {
            this.createGUI();
        }
        return this.guiItem;
    }

    private void createGUI() {
        this.guiItem = new SMYLDLabel(this.nodeLable, this.getNodeImage());
        this.guiItem.setOpaque(true);
        this.guiItem.setEnabled(this.enabled);
        this.guiItem.setToolTipText(this.getToolTipText());
        if (this.cmpOrient != null) {
            this.guiItem.applyComponentOrientation(this.cmpOrient);
        }
    }

    public String getActionCommand() {
        return this.ActionCommand;
    }

    public SMYLDPopupMenu getPopupMenu() {
        return this.popUp;
    }

    public void setActionCommand(String newActionCommand) {
        this.ActionCommand = newActionCommand;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.getGuiItem().setVisible(this.visible);
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o) {
        this.cmpOrient = o;
        if (this.guiItem != null) {
            this.guiItem.applyComponentOrientation(this.cmpOrient);
        }
    }

    public HashMap<String, SMYLDTreeNode> getChildrenByLabel() {
        if (!this.allowChildren) {
            return null;
        }
        HashMap<String, SMYLDTreeNode> retval = new HashMap<String, SMYLDTreeNode>();
        for (int i = 0; i < this.items.size(); ++i) {
            SMYLDTreeNode node = this.items.get(i);
            retval.put(node.getText(), node);
        }
        return retval;
    }

    public TreeNode getChildAt(int index, boolean filterIsActive) {
        if (!filterIsActive) {
            return this.getChildAt(index);
        }
        if (this.items == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        int realindex = this.visibles[index];
        return this.getChildAt(realindex);
    }

    public int getChildCount(boolean filterIsActive) {
        if (!filterIsActive) {
            return this.getChildCount();
        }
        if (this.items == null) {
            return 0;
        }
        int count = 0;
        this.visibles = new int[this.getChildCount()];
        for (SMYLDTreeNode node : this.items) {
            if (!node.isVisible()) continue;
            this.visibles[count] = this.getIndex(node);
            ++count;
        }
        return count;
    }

    @Override
    public GUIAction getGUIAction() {
        return this.guiAction;
    }

    @Override
    public void setIcon(ImageIcon nodeIcon) {
        this.nodeIcon = nodeIcon;
        if (this.guiItem != null) {
            this.guiItem.setIcon(nodeIcon);
            this.refreshGUI();
        } else {
            this.createGUI();
        }
    }

    public ImageIcon getIcon() {
        return this.nodeIcon;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    @Override
    public void setTooltipText(String toolTipText) {
        this.toolTipText = toolTipText;
        if (this.guiItem != null) {
            this.guiItem.setToolTipText(toolTipText);
            this.refreshGUI();
        } else {
            this.createGUI();
        }
    }

    public void setParent(SMYLDTreeNode parent) {
        this.parent = parent;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    private void doPrint(String text) {
        if (this.debug) {
            System.out.println(text);
        }
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public SMYLDTreeModel getModel() {
        return this.model;
    }

    public void setModel(SMYLDTreeModel model) {
        this.model = model;
        if (this.getChildCount() > 0) {
            for (SMYLDTreeNode curNode : this.items) {
                curNode.setModel(model);
            }
        }
    }

    @Override
    public void setGUIAction(GUIAction newAction) {
        this.guiAction = newAction;
    }

    @Override
    public JMenuItem getParentClass() {
        return null;
    }

    @Override
    public SMYLDButton getToolbarButton() {
        return null;
    }

    @Override
    public void setAccelerator(String newAccelerator) {
    }

    @Override
    public void setActionListener(ActionHandler Handler2) {
    }

    @Override
    public void setToolbarButton(String lable, ImageIcon toolbarIcon) {
    }

    @Override
    public void setToolbarIcon(ImageIcon toolbarIcon) {
    }
}

