/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.smyld.gui.GUIAction;
import org.smyld.gui.SMYLDPanel;
import org.smyld.gui.SMYLDToolbar;
import org.smyld.gui.event.ActionHandler;

public class SMYLDFrame
extends JFrame
implements ActionHandler {
    private static final long serialVersionUID = -1685744892361638762L;
    protected BorderLayout layoutMain;
    protected HashMap<String, Component> compRef;
    private SMYLDToolbar toolbar;

    public SMYLDFrame() {
        this.doInit();
    }

    public SMYLDFrame(String title) {
        super(title);
        this.doInit();
    }

    public void doInit() {
        SMYLDFrame.setDefaultLookAndFeelDecorated(true);
    }

    public void centerWindowInScreen() {
        SMYLDFrame.centerComponentInScreen(this);
    }

    public static void centerComponentInScreen(Component component) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = component.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        component.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public void setToMaximum() {
        this.maximizeFrame();
        this.setLocation(0, 0);
    }

    public void maximizeWidth(int height) {
        this.setSize(Toolkit.getDefaultToolkit().getScreenSize().width, height);
    }

    public void maximizeHeight(int width) {
        this.setSize(width, Toolkit.getDefaultToolkit().getScreenSize().height);
    }

    public void maximizeFrame() {
        this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
    }

    public void setBGColor(String newColor) {
        try {
            this.setBackground(Color.decode(newColor));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addComponent(String refName, Component newComp) {
        this.addNewComponentToList(refName, newComp);
        this.getContentPane().add(newComp);
    }

    protected void addNewComponentToList(String refName, Component newComp) {
        if (this.compRef == null) {
            this.compRef = new HashMap();
        }
        this.compRef.put(refName, newComp);
    }

    public Component getComponent(String compID) {
        return this.compRef.get(compID);
    }

    public void close() {
        System.exit(-1);
    }

    private void closeWindow() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                SMYLDFrame.this.close();
            }
        });
    }

    public void setIcon(ImageIcon newIcon) {
        if (newIcon != null) {
            this.setIconImage(newIcon.getImage());
        }
    }

    public void setToolbar(SMYLDToolbar newToolbar) {
        this.setBorderLayout();
        this.toolbar = newToolbar;
        this.getContentPane().add((Component)newToolbar, "North");
    }

    public SMYLDToolbar getToolbar() {
        return this.toolbar;
    }

    public void setStatusBar(SMYLDPanel statusPanel) {
        this.setBorderLayout();
        this.getContentPane().add((Component)statusPanel, "South");
    }

    protected void setBorderLayout() {
        if (this.getContentPane().getLayout() == null) {
            this.layoutMain = new BorderLayout();
            this.getContentPane().setLayout(this.layoutMain);
        }
    }

    @Override
    public void processGUIAction(GUIAction incomingAction) {
    }
}

