/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.smyld.gui.GUIConstants;
import org.smyld.gui.SMYLDComboBox;
import org.smyld.gui.SMYLDRCLayout;
import org.smyld.gui.SMYLDTextArea;
import org.smyld.gui.SMYLDTextField;
import org.smyld.gui.event.SMYLDChangeListener;

public abstract class SMYLDLabeledComponent
extends JPanel
implements GUIConstants {
    JLabel lblField;
    JComponent mainComponent;
    String label;
    JScrollPane scrollPane;
    int labelPosition;
    protected int mainComponentWidth;

    public SMYLDLabeledComponent() {
    }

    public SMYLDLabeledComponent(String Label) {
        this.setLabel(Label);
    }

    public void setScrollable(boolean scrol) {
    }

    protected void init() {
        this.labelPosition = 40;
        this.setLayout(null);
        this.mainComponent = this.createMainComponent();
        this.add(this.mainComponent);
        this.lblField = new JLabel(this.getLabel());
        this.lblField.setVerticalAlignment(1);
        this.lblField.setHorizontalAlignment(2);
        this.addLabelField();
        this.lblField.setLabelFor(this.mainComponent);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
                SMYLDLabeledComponent.this.mainComponent.requestFocusInWindow();
            }

            @Override
            public void focusLost(FocusEvent evt) {
            }
        });
    }

    public JComponent getMainComponent() {
        return this.mainComponent;
    }

    public JComponent getLabelComponent() {
        return this.lblField;
    }

    protected abstract JComponent createMainComponent();

    public String getLabel() {
        return this.label;
    }

    public void setVerticalLabelAlignment(int position) {
        this.lblField.setVerticalAlignment(position);
    }

    public void addSMYLDChangeListener(SMYLDChangeListener listener) {
        if (this.mainComponent == null || listener == null) {
            return;
        }
        if (this.mainComponent instanceof SMYLDComboBox) {
            SMYLDComboBox combo = (SMYLDComboBox)this.mainComponent;
            combo.addSMYLDChangeListener(listener);
        } else if (this.mainComponent instanceof SMYLDTextField) {
            SMYLDTextField text = (SMYLDTextField)this.mainComponent;
            text.addSMYLDChangeListener(listener);
        } else if (this.mainComponent instanceof SMYLDTextArea) {
            SMYLDTextArea texta = (SMYLDTextArea)this.mainComponent;
            texta.addSMYLDChangeListener(listener);
        }
    }

    public void setHorizintalLabelAlignment(int position) {
        this.lblField.setHorizontalAlignment(position);
    }

    public void setLabel(String label) {
        this.label = label;
        if (this.lblField != null) {
            this.lblField.setText(label);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        this.lblField.setEnabled(enable);
        this.mainComponent.setEnabled(enable);
        if (this.scrollPane != null) {
            this.scrollPane.setEnabled(enable);
        }
    }

    public void setIcon(ImageIcon newIcon) {
        this.lblField.setIcon(newIcon);
    }

    @Override
    public void setComponentOrientation(ComponentOrientation orient) {
        super.setComponentOrientation(orient);
        if (this.lblField != null) {
            this.lblField.setComponentOrientation(orient);
        }
        if (this.mainComponent != null) {
            this.mainComponent.setComponentOrientation(orient);
        }
    }

    private void addLabelField() {
        this.add(this.lblField);
    }

    @Override
    public void setAutoscrolls(boolean scrollable) {
        this.mainComponent.setAutoscrolls(true);
        if (scrollable) {
            this.scrollPane = new JScrollPane(this.mainComponent);
            this.remove(this.mainComponent);
            this.add((Component)this.scrollPane, "Center");
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int realMainCompWidth = this.mainComponentWidth;
        LayoutManager ly = super.getParent().getLayout();
        if (ly != null && ly instanceof SMYLDRCLayout) {
            realMainCompWidth = this.mainComponentWidth * 12;
        }
        if (this.mainComponentWidth == 0) {
            realMainCompWidth = (int)((float)width * 0.66f);
        }
        if (this.label == null || this.label.isEmpty()) {
            realMainCompWidth = width;
        }
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        this.lblField.setComponentOrientation(this.getComponentOrientation());
        this.mainComponent.setComponentOrientation(this.getComponentOrientation());
        int lblH = (int)this.lblField.getPreferredSize().getHeight();
        switch (this.labelPosition) {
            case 1: {
                this.lblField.setLocation(0, 0);
                this.lblField.setSize(width, lblH);
                this.mainComponent.setLocation(0, lblH);
                this.mainComponent.setSize(width, height - lblH);
                break;
            }
            case 3: {
                this.lblField.setLocation(0, height - lblH);
                this.lblField.setSize(width, lblH);
                this.mainComponent.setLocation(0, 0);
                this.mainComponent.setSize(width, height - lblH);
                break;
            }
            default: {
                if (ltr) {
                    this.lblField.setLocation(0, 0);
                    this.lblField.setSize(width - realMainCompWidth, height);
                    this.mainComponent.setLocation(width - realMainCompWidth, 0);
                    this.mainComponent.setSize(realMainCompWidth, height);
                    break;
                }
                this.lblField.setLocation(width - realMainCompWidth, 0);
                this.lblField.setSize(width - realMainCompWidth, height);
                this.mainComponent.setLocation(0, 0);
                this.mainComponent.setSize(realMainCompWidth, height);
            }
        }
        super.setBounds(x, y, width, height);
    }

    public void setLabelPosition(String newPosition) {
        if (newPosition.equals("top")) {
            this.setLabelPosition(1);
        } else if (newPosition.equals("bottom")) {
            this.setLabelPosition(3);
        } else if (newPosition.equals("side")) {
            this.setLabelPosition(40);
        }
    }

    public void setLabelPosition(int newPosition) {
        if (this.labelPosition != newPosition) {
            this.remove(this.lblField);
            switch (newPosition) {
                case 1: {
                    this.add((Component)this.lblField, "North");
                    this.setHorizintalLabelAlignment(0);
                    break;
                }
                case 3: {
                    this.add((Component)this.lblField, "South");
                    this.setHorizintalLabelAlignment(0);
                    break;
                }
                default: {
                    this.addLabelField();
                }
            }
            this.labelPosition = newPosition;
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (this.mainComponent != null) {
            this.mainComponent.addMouseListener(mouseListener);
        }
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        if (this.mainComponent != null) {
            this.mainComponent.addFocusListener(focusListener);
        }
    }

    public int getMainComponentWidth() {
        return this.mainComponentWidth;
    }

    public void setMainComponentWidth(int mainComponentWidth) {
        this.mainComponentWidth = mainComponentWidth;
    }

    public void setBGColor(String newColor) {
        try {
            Color targetColor = Color.decode(newColor);
            this.setBackground(targetColor);
            this.mainComponent.setBackground(targetColor);
            this.lblField.setBackground(targetColor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

