/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.smyld.gui.SMYLDButton;
import org.smyld.gui.SMYLDDialog;
import org.smyld.gui.SMYLDLabel;
import org.smyld.gui.SMYLDLabeledPasswordField;
import org.smyld.gui.SMYLDLabeledTextField;
import org.smyld.gui.SMYLDPanel;

public class SMYLDLoginDialog
extends SMYLDDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private SMYLDPanel mainPanel;
    protected SMYLDLabeledTextField userField;
    protected SMYLDLabeledPasswordField pwdField;
    protected SMYLDButton ok;
    protected SMYLDButton cancel;
    protected SMYLDButton reset;
    private static int attempts = 0;

    public SMYLDLoginDialog(JFrame owner) {
        super(owner);
        this.jbinit();
        this.closeWindow();
    }

    private void jbinit() {
        this.userField = new SMYLDLabeledTextField("User Name", 40);
        this.pwdField = new SMYLDLabeledPasswordField("User Password", 40);
        this.initButtons();
        this.initPanels();
        this.mainPanel.setBorder(BorderFactory.createTitledBorder("Login Info "));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.setResizable(false);
        this.setSize(450, 200);
        this.setModal(true);
        this.centerWindow();
    }

    private void initButtons() {
        this.ok = new SMYLDButton("OK");
        this.cancel = new SMYLDButton("Cancel");
        this.reset = new SMYLDButton("Reset");
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.reset.addActionListener(this);
    }

    private void initPanels() {
        SMYLDPanel pane1 = new SMYLDPanel();
        pane1.setLayout(new BoxLayout(pane1, 0));
        pane1.add(new SMYLDLabel("User name: "));
        pane1.add(Box.createRigidArea(new Dimension(10, 0)));
        pane1.add(this.userField);
        SMYLDPanel pane2 = new SMYLDPanel();
        pane2.setLayout(new BoxLayout(pane2, 0));
        pane2.add(new SMYLDLabel("Password: "));
        pane2.add(Box.createRigidArea(new Dimension(13, 0)));
        pane2.add(this.pwdField);
        SMYLDPanel btnPane = new SMYLDPanel();
        btnPane.setLayout(new BoxLayout(btnPane, 0));
        btnPane.add(this.ok);
        btnPane.add(Box.createRigidArea(new Dimension(3, 0)));
        btnPane.add(this.cancel);
        btnPane.add(Box.createRigidArea(new Dimension(3, 0)));
        btnPane.add(this.reset);
        this.mainPanel = new SMYLDPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.add(pane1);
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 3)));
        this.mainPanel.add(pane2);
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.mainPanel.add(btnPane);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.checkAttempts(e);
        if (e.getSource() == this.ok) {
            this.actionPerformed_ok();
        } else if (e.getSource() == this.cancel) {
            this.actionPerformed_cancel();
        } else if (e.getSource() == this.reset) {
            this.actionPerformed_reset();
        }
    }

    protected void actionPerformed_ok() {
    }

    protected void actionPerformed_reset() {
        this.userField.getSMYLDTextField().reset();
        this.pwdField.getSMYLDPasswordField().reset();
    }

    protected void actionPerformed_cancel() {
        System.exit(1);
    }

    private void closeWindow() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                System.exit(-1);
            }
        });
    }

    private void checkAttempts(ActionEvent e) {
        if (++attempts <= 3) {
            return;
        }
        e.setSource(this.cancel);
        JOptionPane.showMessageDialog(this, "Maximum number of attempts exceeded", "Failure", 0);
    }
}

