/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.smyld.gui.SMYLDLabel;
import org.smyld.gui.SMYLDPanel;
import org.smyld.gui.SMYLDTabbedPane;
import org.smyld.gui.dnd.DragableTransfereHandler;
import org.smyld.gui.event.DockablePanelListener;
import org.smyld.gui.event.DragableComponentListener;
import org.smyld.gui.panels.DockableComponent;
import org.smyld.gui.panels.DockableConstants;
import org.smyld.gui.util.SMYLDGUIUtil;
import org.smyld.resources.Resource;

public class DockablePanel
extends SMYLDPanel
implements Serializable,
DockableConstants,
DragableComponentListener {
    private static final long serialVersionUID = 1L;
    private String pnlRSColor = "wt";
    private DockablePanelListener listener;
    private BorderLayout borderLayout1 = new BorderLayout();
    private SMYLDPanel contentPanel = new SMYLDPanel();
    private SMYLDPanel topPanel = new SMYLDPanel(){
        Color lightSide = new Color(120, 179, 236);
        Color darkSide = new Color(88, 154, 219);
        Color midColor = SMYLDGUIUtil.getMiddleColor(this.darkSide, this.lightSide);
        Color lightMiddleSide = new Color(105, 167, 228);
        Color darkMiddleSide = new Color(102, 164, 227);

        @Override
        public void setBackground(Color bg) {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D gd = (Graphics2D)g;
            gd.setPaint(new GradientPaint(this.getWidth() / 2, 0.0f, this.lightSide, this.getWidth() / 2, this.getHeight() / 2, this.midColor));
            gd.fillRect(0, 0, this.getWidth(), this.getHeight() / 2);
            gd.setPaint(new GradientPaint(this.getWidth() / 2, this.getHeight() / 2, this.darkSide, this.getWidth() / 2, this.getHeight(), this.midColor));
            gd.fillRect(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
            gd.drawString("This is my test", 0, 20);
        }
    };
    private SMYLDPanel titleRPanel = new SMYLDPanel();
    private SMYLDPanel titleLPanel = new SMYLDPanel();
    private SMYLDLabel minimizedLabel;
    private String label;
    private Resource res;
    JLabel title = new JLabel("Title");
    JLabel panelIcon;
    SMYLDLabel hideLabel;
    SMYLDLabel closeLabel;
    private SMYLDTabbedPane tabPane;
    private DockableComponent firstComponent;
    private HashMap<JComponent, DockableComponent> childComponents;
    private DockablePanel instance = this;
    private int status;
    private int dockLocation;
    public static final int STATUS_SHOWN = 1;
    public static final int STATUS_MINIMIZED = 2;
    public static final int STATUS_DRAGGED = 3;
    public static final int STATUS_DROPPED = 4;
    public static final int STATUS_CLOSED = 5;
    String id;

    public DockablePanel() {
        this.init();
    }

    public static void main(String[] args) {
        TreeSet<String> sort = new TreeSet<String>();
        for (Object k : UIManager.getLookAndFeelDefaults().keySet()) {
            sort.add(k.toString());
        }
        for (Object object : sort) {
            System.out.println(object.toString());
        }
    }

    private void init() {
        this.res = new Resource();
        this.childComponents = new HashMap();
        this.setLayout(this.borderLayout1);
        this.panelIcon = new JLabel(this.res.getImageIcon("parser_sm.gif"));
        this.initTitle();
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.contentPanel, "Center");
        this.minimizedLabel = this.createLabel();
    }

    public void addListener(DockablePanelListener dockabelListener) {
        this.listener = dockabelListener;
    }

    public void setContent(JComponent newComponent, String title, ImageIcon icon, boolean showTabTitle, boolean showTabIcon) {
        DockableComponent newDockComp = null;
        if (!this.childComponents.containsKey(newComponent)) {
            newDockComp = new DockableComponent(newComponent, title, icon, showTabTitle, showTabIcon);
            if (this.childComponents.size() == 0) {
                this.setSingleComponent(newDockComp);
            } else {
                if (this.firstComponent != null && newComponent.equals(this.firstComponent.getComponent())) {
                    return;
                }
                if (this.tabPane == null || this.childComponents.size() == 1) {
                    this.initTab();
                }
                this.setIcon(icon);
                this.setLabel(title);
                this.addTab(newDockComp);
                this.tabPane.setSelectedComponent(newDockComp.getScroller());
                this.add((Component)this.tabPane, "Center");
            }
        }
        this.revalidate();
        this.childComponents.put(newComponent, newDockComp);
    }

    private void addTab(DockableComponent newComp) {
        if (newComp.isShowTabIcon() && newComp.isShowTabTitle()) {
            this.tabPane.addTab(newComp.getTitle(), newComp.getIcon(), newComp.getScroller());
        } else if (newComp.isShowTabTitle()) {
            this.tabPane.addTab(newComp.getTitle(), newComp.getScroller());
        } else if (newComp.isShowTabIcon()) {
            this.tabPane.addTab("", newComp.getIcon(), newComp.getScroller());
        } else {
            this.tabPane.addTab("", newComp.getScroller());
        }
    }

    private void setSingleComponent(DockableComponent newComp) {
        this.setIcon(newComp.getIcon());
        this.setLabel(newComp.getTitle());
        this.add((Component)newComp.getScroller(), "Center");
        this.firstComponent = newComp;
        this.setLabelInfo();
    }

    private void initTab() {
        if (this.tabPane == null) {
            this.tabPane = new SMYLDTabbedPane();
            this.tabPane.applyComponentOrientation(this.getComponentOrientation());
            this.tabPane.setBorder(BorderFactory.createEmptyBorder());
            this.tabPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    int sel = DockablePanel.this.tabPane.getSelectedIndex();
                    if (sel >= 0) {
                        JComponent selectedComp = DockablePanel.this.extractComponent((JScrollPane)DockablePanel.this.tabPane.getComponentAt(sel));
                        DockableComponent selDock = (DockableComponent)((Object)DockablePanel.this.childComponents.get(selectedComp));
                        if (selDock != null) {
                            DockablePanel.this.setIcon(selDock.getIcon());
                            DockablePanel.this.setLabel(selDock.getTitle());
                            DockablePanel.this.setLabelInfo();
                        }
                    }
                }
            });
            this.tabPane.setTabPlacement(3);
        }
        this.addTab(this.firstComponent);
    }

    private void initTitle() {
        this.topPanel.setLayout(new BorderLayout(2, 1));
        this.titleRPanel.setLayout(new FlowLayout());
        this.titleLPanel.setLayout(new FlowLayout());
        this.titleLPanel.setOpaque(false);
        this.titleRPanel.setOpaque(false);
        this.closeLabel = new SMYLDLabel(null, this.res.getImageIcon("close_" + this.pnlRSColor + ".gif"));
        this.closeLabel.setBorder(null);
        this.closeLabel.setRolloverIcon(this.res.getImageIcon("close_" + this.pnlRSColor + "_o.gif"));
        this.closeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DockablePanel.this.handelCloseAction();
            }
        });
        this.hideLabel = new SMYLDLabel(null, this.res.getImageIcon("hide_off_" + this.pnlRSColor + ".gif"));
        this.hideLabel.setBorder(null);
        this.hideLabel.setRolloverIcon(this.res.getImageIcon("hide_off_" + this.pnlRSColor + "_o.gif"));
        this.hideLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (DockablePanel.this.listener != null) {
                    DockablePanel.this.status = 2;
                    DockablePanel.this.listener.panelHidden(DockablePanel.this.instance);
                }
            }
        });
        this.setTitleBackground(Color.BLUE);
        this.title.setForeground(Color.WHITE);
        this.titleRPanel.add(this.hideLabel);
        this.titleRPanel.add(this.closeLabel);
        this.titleLPanel.add(this.panelIcon);
        this.titleLPanel.add(this.title);
        this.setPositions();
        this.instance.setTransferHandler(new DragableTransfereHandler(this));
        this.topPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DockablePanel.this.instance.getTransferHandler().exportAsDrag(DockablePanel.this.instance, evt, 1);
            }
        });
        this.topPanel.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
                System.out.println("Gained");
                DockablePanel.this.setTitleBackground(Color.BLUE);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                System.out.println("Lost");
                DockablePanel.this.setTitleBackground(Color.GRAY);
            }
        });
    }

    public void refresh() {
        this.hideLabel.refresh();
        this.closeLabel.refresh();
    }

    private void setPositions() {
        if (this.tabPane != null) {
            this.tabPane.applyComponentOrientation(this.getComponentOrientation());
        }
        this.titleRPanel.applyComponentOrientation(this.getComponentOrientation());
        this.titleLPanel.applyComponentOrientation(this.getComponentOrientation());
        this.topPanel.applyComponentOrientation(this.getComponentOrientation());
        this.topPanel.add((Component)this.titleRPanel, "West");
        this.topPanel.add((Component)this.titleLPanel, "East");
        if (this.getComponentOrientation().isLeftToRight()) {
            this.topPanel.add((Component)this.titleRPanel, "East");
            this.topPanel.add((Component)this.titleLPanel, "West");
        } else {
            this.topPanel.add((Component)this.titleRPanel, "West");
            this.topPanel.add((Component)this.titleLPanel, "East");
        }
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation orient) {
        super.applyComponentOrientation(orient);
        this.setPositions();
    }

    public void resetSize() {
        this.setSize(0, 0);
    }

    private void handelCloseAction() {
        if (this.tabPane != null && this.tabPane.getComponentCount() > 1) {
            this.childComponents.remove(this.extractComponent((JScrollPane)this.tabPane.getSelectedComponent()));
            this.tabPane.remove(this.tabPane.getSelectedIndex());
            if (this.tabPane.getComponentCount() == 1) {
                JScrollPane targetScroll = (JScrollPane)this.tabPane.getComponentAt(0);
                this.firstComponent = this.childComponents.get(this.extractComponent(targetScroll));
                this.tabPane.remove(targetScroll);
                this.instance.remove(this.tabPane);
                this.setSingleComponent(this.firstComponent);
                this.instance.revalidate();
            }
        } else if (this.childComponents.size() == 1) {
            this.childComponents.remove(this.firstComponent.getComponent());
            this.instance.remove(this.firstComponent.getScroller());
        }
        if (this.listener != null) {
            this.listener.panelClosed(this.instance);
        }
    }

    private JComponent extractComponent(JScrollPane targetScroll) {
        return (JComponent)targetScroll.getViewport().getView();
    }

    private JScrollPane extractScroll(JComponent targetComp) {
        return (JScrollPane)targetComp.getParent().getParent();
    }

    public int getComponentNumber() {
        return this.childComponents.size();
    }

    private void setTitleBackground(Color backColor) {
        this.topPanel.setBackground(backColor);
    }

    public String getLabel() {
        return this.label;
    }

    public void setIcon(ImageIcon windowIcon) {
        if (windowIcon != null) {
            this.panelIcon.setIcon(windowIcon);
        } else {
            this.panelIcon.setIcon(this.res.getImageIcon("object.gif"));
        }
    }

    public ImageIcon getIcon() {
        return (ImageIcon)this.panelIcon.getIcon();
    }

    public void setLabel(String label) {
        this.label = label;
        this.title.setText(label);
    }

    public void doClose() {
        this.status = 5;
        if (this.listener != null) {
            this.listener.panelClosed(this.instance);
        }
    }

    @Override
    public void dragStarted() {
        this.status = 3;
        if (this.listener != null) {
            this.listener.panelDragged(this.instance);
        }
    }

    @Override
    public void dragEnded() {
        this.status = 4;
        if (this.listener != null) {
            this.listener.panelDropped(this.instance);
        }
    }

    public void setStatus(int newStatus) {
        this.status = newStatus;
    }

    public int getStatus() {
        return this.status;
    }

    private SMYLDLabel createLabel() {
        SMYLDLabel panLable = new SMYLDLabel(this.getLabel(), this.getIcon());
        panLable.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        panLable.applyComponentOrientation(this.getComponentOrientation());
        panLable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (DockablePanel.this.listener != null) {
                    DockablePanel.this.listener.panelShown(DockablePanel.this.instance);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ((SMYLDLabel)evt.getSource()).setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ((SMYLDLabel)evt.getSource()).setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        });
        return panLable;
    }

    public SMYLDLabel getMinimizedLabel() {
        return this.minimizedLabel;
    }

    private void setLabelInfo() {
        this.minimizedLabel.setText(this.getLabel());
        this.minimizedLabel.setIcon(this.getIcon());
        this.minimizedLabel.applyComponentOrientation(this.getComponentOrientation());
    }

    public int getDockLocation() {
        return this.dockLocation;
    }

    public void setDockLocation(int dockLocation) {
        this.dockLocation = dockLocation;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public JComponent getComponent() {
        return this.instance;
    }

    @Override
    public boolean isInternal() {
        return true;
    }
}

