/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import org.smyld.gui.GUIAction;
import org.smyld.gui.SMYLDDesktopPane;
import org.smyld.gui.SMYLDLabel;
import org.smyld.gui.SMYLDPanel;
import org.smyld.gui.event.ActionHandler;
import org.smyld.gui.event.DockablePanelListener;
import org.smyld.gui.panels.DockableConstants;
import org.smyld.gui.panels.DockableContainer;
import org.smyld.gui.panels.DockablePanel;
import org.smyld.text.TextUtil;

public class DockableTemplate
extends SMYLDPanel
implements ActionHandler,
DockableConstants {
    private static final long serialVersionUID = 1L;
    private JSplitPane hSplit = new JSplitPane(1);
    private BorderLayout borderLayout1 = new BorderLayout();
    protected JComponent mainComponent = null;
    private DockableContainer deskTopCont = new DockableContainer();
    private SMYLDPanel leftPanel = new SMYLDPanel();
    private SMYLDPanel topPanel = new SMYLDPanel();
    private SMYLDPanel downPanel = new SMYLDPanel();
    private SMYLDPanel rightPanel = new SMYLDPanel();
    private FlowLayout topLayout = new FlowLayout(2);
    private FlowLayout leftLayout = new FlowLayout(2);
    private FlowLayout rightLayout = new FlowLayout(0);
    private FlowLayout downLayout = new FlowLayout(0);
    private HashMap<String, DockablePanel> compContainers = new HashMap();
    DockableTemplate instance;
    DockablePanel sidePanel;
    SMYLDLabel panLable;
    SMYLDDesktopPane defaultPanel = new SMYLDDesktopPane();
    public static final String LOCATE_SIDE = "side";
    public static final String LOCATE_DOWN = "down";
    public static final String LOCATE_MAIN = "main";

    public DockableTemplate(JComponent mainComponent) {
        this.mainComponent = mainComponent;
        this.init();
        this.instance = this;
    }

    public DockableTemplate() {
        this.mainComponent = this.defaultPanel;
        this.init();
        this.instance = this;
    }

    private void init() {
        this.setLayout(this.borderLayout1);
        this.topPanel.setLayout(this.topLayout);
        this.leftPanel.setLayout(this.leftLayout);
        this.rightPanel.setLayout(this.rightLayout);
        this.downPanel.setLayout(this.downLayout);
        this.topPanel.setSize(0, 0);
        this.downPanel.setSize(0, 0);
        this.leftPanel.setSize(0, 0);
        this.rightPanel.setSize(0, 0);
        this.deskTopCont.setMainComp(this.mainComponent);
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.leftPanel, "West");
        this.add((Component)this.downPanel, "South");
        this.add((Component)this.rightPanel, "East");
        this.add((Component)this.deskTopCont, "Center");
    }

    public void addToDown(JComponent newComp, String title, ImageIcon icon, boolean showTabTitle, boolean showTabIcon) {
        this.addComponent(newComp, title, icon, 4, showTabTitle, showTabIcon);
    }

    public void addToSide(JComponent newComp, String title, ImageIcon icon, boolean showTabTitle, boolean showTabIcon) {
        this.addComponent(newComp, title, icon, 5, showTabTitle, showTabIcon);
    }

    public void addComponent(JComponent newComp, String title, ImageIcon icon, int location, boolean showTabTitle, boolean showTabIcon) {
        boolean newCreated = false;
        String panelID = Integer.toString(location);
        if (!this.compContainers.containsKey(panelID)) {
            this.compContainers.put(panelID, this.initCompContainer(panelID));
            newCreated = true;
        }
        DockablePanel targetPanel = this.compContainers.get(panelID);
        if (newCreated) {
            targetPanel.setDockLocation(this.getComponentLocation(location));
        }
        targetPanel.setContent(newComp, title, icon, showTabTitle, showTabIcon);
        if (targetPanel.getStatus() == 2 || targetPanel.getStatus() == 5) {
            this.showPanel(targetPanel);
        } else if (newCreated) {
            this.deskTopCont.addComponent(targetPanel, this.getComponentLocation(location), false);
            targetPanel.setStatus(1);
        }
        this.revalidate();
        this.repaint();
    }

    private int getComponentLocation(int compLocation) {
        if (compLocation == 5) {
            if (this.getComponentOrientation().isLeftToRight()) {
                return 1;
            }
            return 3;
        }
        return compLocation;
    }

    private DockablePanel initCompContainer(String dockableID) {
        DockablePanel newPanel = new DockablePanel();
        newPanel.setId(dockableID);
        newPanel.applyComponentOrientation(this.getComponentOrientation());
        newPanel.addListener(new DockablePanelListener(){
            private static final long serialVersionUID = 1L;

            @Override
            public void panelClosed(DockablePanel panel) {
                if (panel.getComponentNumber() == 0) {
                    panel.setStatus(5);
                    panel.setDockLocation(DockableTemplate.this.getComponentLocation(Integer.parseInt(panel.getId())));
                    DockableTemplate.this.deskTopCont.removeComponent(panel);
                    DockableTemplate.this.instance.revalidate();
                    DockableTemplate.this.instance.repaint();
                }
            }

            @Override
            public void panelHidden(DockablePanel panel) {
                panel.setStatus(2);
                DockableTemplate.this.deskTopCont.removeComponent(panel);
                DockableTemplate.this.downPanel.add(panel.getMinimizedLabel());
                DockableTemplate.this.downPanel.repaint();
                DockableTemplate.this.instance.revalidate();
            }

            @Override
            public void panelShown(DockablePanel panel) {
                DockableTemplate.this.showPanel(panel);
            }

            @Override
            public void panelDragged(DockablePanel panel) {
                DockableTemplate.this.deskTopCont.registerDragOperation(panel);
            }

            @Override
            public void panelDropped(DockablePanel panel) {
                DockableTemplate.this.deskTopCont.dropComponent(panel);
            }
        });
        return newPanel;
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation newOrient) {
        super.applyComponentOrientation(newOrient);
        if (newOrient.isLeftToRight()) {
            this.topLayout.setAlignment(2);
            this.leftLayout.setAlignment(2);
            this.rightLayout.setAlignment(0);
            this.downLayout.setAlignment(0);
        } else {
            this.topLayout.setAlignment(0);
            this.leftLayout.setAlignment(0);
            this.rightLayout.setAlignment(2);
            this.downLayout.setAlignment(2);
        }
        if (this.compContainers != null && this.compContainers.size() > 0) {
            for (DockablePanel curPanel : this.compContainers.values()) {
                curPanel.applyComponentOrientation(newOrient);
            }
        }
        this.deskTopCont.applyComponentOrientation(newOrient);
    }

    private void showPanel(DockablePanel targetPanel) {
        this.downPanel.remove(targetPanel.getMinimizedLabel());
        targetPanel.refresh();
        this.deskTopCont.addComponent(targetPanel, targetPanel.getDockLocation(), false);
        targetPanel.setStatus(1);
        this.instance.revalidate();
        this.instance.repaint();
    }

    @Override
    public void processGUIAction(GUIAction incomingAction) {
        if (incomingAction != null) {
            if (TextUtil.doEqual((String)incomingAction.getCommand(), (String)"addComponent")) {
                JComponent newComp = (JComponent)incomingAction.getUserObject();
                if (TextUtil.doEqual((String)incomingAction.getParameters(), (String)LOCATE_DOWN)) {
                    this.addToDown(newComp, incomingAction.getLabel(), incomingAction.getIcon(), true, true);
                } else if (TextUtil.doEqual((String)incomingAction.getParameters(), (String)LOCATE_SIDE)) {
                    this.addToSide(newComp, incomingAction.getLabel(), incomingAction.getIcon(), true, true);
                } else {
                    this.deskTopCont.setFreeMainComponent(newComp);
                }
            } else if (this.mainComponent instanceof ActionHandler) {
                ((ActionHandler)((Object)this.mainComponent)).processGUIAction(incomingAction);
            } else {
                this.doProcessGUIAction(incomingAction);
            }
        }
    }

    public void setMainComponent(JComponent newMainComponent) {
        this.mainComponent = newMainComponent;
        this.deskTopCont.setMainComp(this.mainComponent);
    }

    public void setFreeComponent(JComponent newMainComponent) {
        this.deskTopCont.setFreeComponent(this.mainComponent);
    }

    public JComponent getMainComponent() {
        return this.mainComponent;
    }

    public void doProcessGUIAction(GUIAction incomingAction) {
    }
}

