/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui.tree;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.smyld.SMYLDObject;
import org.smyld.gui.SMYLDLabel;
import org.smyld.gui.tree.SMYLDTreeNode;

public class SMYLDTreeCellRenderer
extends SMYLDObject
implements TreeCellRenderer {
    private static final long serialVersionUID = 1L;
    Color selBGColor;
    Color selFGColor;
    Color norBGColor;
    Color norFGColor;
    SMYLDTreeNode currentNode;

    public SMYLDTreeCellRenderer() {
        this.init();
    }

    private void init() {
        this.norBGColor = Color.white;
        this.norFGColor = Color.black;
        this.selBGColor = new Color(0, 0, 150, 20);
        this.selFGColor = Color.blue;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        SMYLDLabel currentNode = ((SMYLDTreeNode)value).getGuiItem();
        if (selected) {
            currentNode.setBackground(this.getSelBGColor());
            currentNode.setForeground(this.getSelFGColor());
        } else {
            currentNode.setBackground(this.getNorBGColor());
            currentNode.setForeground(this.getNorFGColor());
        }
        currentNode.setSize(0, 0);
        currentNode.repaint();
        return currentNode;
    }

    public Color getNorBGColor() {
        return this.norBGColor;
    }

    public void setNorBGColor(Color newNorBGColor) {
        this.norBGColor = newNorBGColor;
    }

    public Color getNorFGColor() {
        return this.norFGColor;
    }

    public void setNorFGColor(Color newNorFGColor) {
        this.norFGColor = newNorFGColor;
    }

    public Color getSelBGColor() {
        return this.selBGColor;
    }

    public void setSelBGColor(Color newSelBGColor) {
        this.selBGColor = newSelBGColor;
    }

    public Color getSelFGColor() {
        return this.selFGColor;
    }

    public void setSelFGColor(Color newSelFGColor) {
        this.selFGColor = newSelFGColor;
    }
}

