/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import org.smyld.gui.SMYLDPanel;
import org.smyld.gui.panels.DatePanel;
import org.smyld.resources.Resource;
import org.smyld.text.TextUtil;
import org.smyld.util.SMYLDDate;

public class DateControl
extends SMYLDPanel {
    private static final long serialVersionUID = 1L;
    Image square;
    Image selSquare;
    Image rightArrow;
    Image leftArrow;
    Image rightOArrow;
    Image leftOArrow;
    Graphics2D g;
    int mouseX;
    int mouseY;
    int selX;
    int selY;
    int curSelection = -1;
    int firstDay;
    int maxDays;
    int curMonthDay;
    Dimension origSize;
    Point origPoint;
    Color bgColor;
    Color mouseOverColor;
    Color daysForegroundColor;
    Color daysSelectedColor;
    Color dayNamesFRColor;
    Color selBgColor;
    Color daysBgColor;
    Color headerBG;
    Color minimizedBGColor;
    boolean inSelect;
    boolean draw3D;
    public boolean isPopedUp = false;
    boolean localResize = false;
    boolean localRelocated = false;
    boolean paintDown = true;
    boolean showAsCombo = true;
    boolean showDate = false;
    String[] days = new String[]{"Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"};
    GregorianCalendar cal;
    SMYLDDate date;
    String[] dayNames;
    String[] monthNames;
    Popup popWindow;
    DatePanel popDate;

    public DateControl(SMYLDDate startDate) {
        this.date = startDate;
        this.init();
    }

    public DateControl() {
        this.init();
    }

    private void init() {
        System.out.println("Date Panel version 1.002");
        this.initDate();
        Resource resource = new Resource();
        this.bgColor = new Color(31, 120, 247);
        this.minimizedBGColor = Color.WHITE;
        this.rightArrow = resource.getImage("arrowr_3d_w.png");
        this.setBackground(this.minimizedBGColor);
        this.setForeground(this.daysForegroundColor);
        this.origSize = this.getComboSize();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DateControl.this.selX = evt.getX();
                DateControl.this.selY = evt.getY();
                DateControl.this.inSelect = true;
                DateControl.this.repaint();
            }
        });
    }

    private void initDate() {
        if (this.date == null) {
            this.date = new SMYLDDate("MMM");
        }
        this.cal = (GregorianCalendar)Calendar.getInstance();
        this.cal.setTime((Date)this.date);
        this.refreshDate();
    }

    private void refreshDate() {
        this.curSelection = this.cal.get(5);
        this.cal.set(5, 1);
        this.firstDay = this.cal.get(7);
        this.maxDays = this.cal.getActualMaximum(5);
    }

    @Override
    public void setSize(int width, int height) {
        if (!this.localResize) {
            this.origSize = new Dimension(width, height);
        }
        super.setSize(width, height);
        this.localResize = false;
    }

    @Override
    public void setSize(Dimension newSize) {
        if (!this.localResize) {
            this.origSize = newSize;
        }
        super.setSize(newSize);
        this.localResize = false;
    }

    @Override
    public void paint(Graphics g) {
        if (this.origPoint == null) {
            this.origPoint = this.getLocation();
        }
        this.g = (Graphics2D)g;
        if (this.isPopedUp) {
            this.paintPoped();
        } else if (this.popWindow != null) {
            this.popWindow.hide();
        } else {
            this.paintUnPoped();
        }
        this.g.setStroke(new BasicStroke(2.1f, 1, 1));
        g.drawRoundRect(0, 0, this.getWidth(), this.getHeight(), 5, 5);
    }

    @Override
    public void setLocation(Point newPoint) {
        if (!this.localRelocated) {
            this.origPoint = newPoint;
        }
        super.setLocation(newPoint);
        this.localRelocated = false;
    }

    @Override
    public void setLocation(int x, int y) {
        if (!this.localRelocated) {
            this.origPoint = new Point(x, y);
        }
        super.setLocation(x, y);
        this.localRelocated = false;
    }

    private void paintUnPoped() {
        this.setOpaque(false);
        this.curMonthDay = 0;
        if (this.origSize == null) {
            this.origSize = this.getComboSize();
        }
        this.setSize(this.origSize);
        this.g.clearRect(this.origPoint.x, this.origPoint.y, this.origSize.width, this.origSize.height);
        this.g.setColor(this.getBackground());
        this.g.fillRect(0, 0, this.origSize.width, this.origSize.height);
        this.g.setColor(this.getForeground());
        this.g.setFont(new Font("Arial", 1, 12));
        this.g.drawString(this.date.toString("dd-MMM-yy"), 10, 15);
        if (this.isMousePointing(this.origSize.width - 20, 0, 20, 20)) {
            this.g.drawImage(this.rightOArrow, this.origSize.width - 20, 0, 20, 20, this.headerBG, null);
        } else {
            this.g.drawImage(this.rightArrow, this.origSize.width - 20, 0, 20, 20, this.headerBG, null);
        }
        if (this.inSelect && this.isInside(this.origSize.width - 20, 0, 20, 20, this.selX, this.selY)) {
            this.isPopedUp = true;
            this.inSelect = false;
        }
    }

    private Dimension getComboSize() {
        return new Dimension(100, 20);
    }

    private Dimension getPopSize() {
        return new Dimension(224, 256);
    }

    private void paintPoped() {
        Point scrLoc = this.getLocationOnScreen();
        if (this.popDate == null) {
            this.popDate = new DatePanel(this.date, this);
        }
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.popWindow = popupFactory.getPopup(this, this.popDate, scrLoc.x, scrLoc.y);
        this.popWindow.show();
    }

    private void paintCalendarHeader() {
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, Color.BLUE, 224.0f, 32.0f, Color.BLACK, true);
        this.g.setPaint(gp);
        this.g.fillRect(0, 0, 224, 32);
        this.paintBetweenArrows(this.date.toString(), 25, 0);
        this.paintBetweenArrows(Integer.toString(this.cal.get(1)), 115, 0);
        if (this.inSelect) {
            if (this.isInside(25, 6, 20, 20, this.selX, this.selY)) {
                int origMonth = this.cal.get(2);
                this.cal.set(2, origMonth - 1);
                this.refreshDate();
                this.date.setTime(this.cal.getTime().getTime());
            } else if (this.isInside(76, 6, 20, 20, this.selX, this.selY)) {
                int origMonth = this.cal.get(2);
                this.cal.set(2, origMonth + 1);
                this.refreshDate();
                this.date.setTime(this.cal.getTime().getTime());
            } else if (this.isInside(115, 6, 20, 20, this.selX, this.selY)) {
                int origYear = this.cal.get(1);
                this.cal.set(1, origYear - 1);
                this.refreshDate();
                this.date.setTime(this.cal.getTime().getTime());
            } else if (this.isInside(173, 6, 20, 20, this.selX, this.selY)) {
                int origYear = this.cal.get(1);
                this.cal.set(1, origYear + 1);
                this.refreshDate();
                this.date.setTime(this.cal.getTime().getTime());
            }
            this.inSelect = false;
            this.repaint();
        }
    }

    private void paintBetweenArrows(String text, int x, int y) {
        int icSize = 20;
        int ydif = 6;
        int textW = 7 * text.length() + 10;
        this.g.setColor(new Color(0, 0, 0, 0));
        if (this.isMousePointing(x, ydif, 20, 20)) {
            this.g.drawImage(this.leftOArrow, x, ydif, icSize, icSize, null);
        } else {
            this.g.drawImage(this.leftArrow, x, ydif, icSize, icSize, null);
        }
        this.g.setColor(this.dayNamesFRColor);
        this.g.drawString(text, x + 25, 20);
        if (this.isMousePointing(x + textW + 20, ydif, 20, 20)) {
            this.g.drawImage(this.rightOArrow, x + textW + 20, ydif, icSize, icSize, null);
        } else {
            this.g.drawImage(this.rightArrow, x + textW + 20, ydif, icSize, icSize, null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.origSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.origSize;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.origSize;
    }

    private void paintOn(int x, int y, int count, Color textColor, boolean enableMouse) {
        this.paintOn(x, y, Integer.toString(count), textColor, enableMouse);
    }

    private void paintOn(int x, int y, String text, Color textColor, boolean enableMouse) {
        if (this.draw3D) {
            this.g.drawImage(this.square, x, y, 32, 32, null);
        } else {
            if (TextUtil.isNumeric((String)text) || TextUtil.isEmpty((String)text)) {
                this.g.setColor(this.daysBgColor);
            } else {
                this.g.setColor(this.bgColor);
            }
            this.g.fillRect(x, y, 32, 32);
        }
        if (enableMouse) {
            if (this.isSelected(x + 1, y + 1, 30, 30, text)) {
                this.g.setColor(this.selBgColor);
                if (this.draw3D) {
                    this.g.drawImage(this.selSquare, x, y, 32, 32, null);
                } else {
                    this.g.setColor(Color.BLACK);
                    this.g.fillOval(x + 1, y + 6, 31, 20);
                    this.g.setColor(this.selBgColor);
                    this.g.fillOval(x + 4, y + 9, 26, 14);
                }
                this.g.setColor(this.daysSelectedColor);
            } else if (this.isMousePointing(x + 1, y + 1, 30, 30)) {
                this.g.setColor(this.mouseOverColor);
            } else {
                this.g.setColor(textColor);
            }
        } else {
            this.g.setColor(textColor);
        }
        int pos = 13;
        if (text.length() == 2) {
            pos = 10;
        } else if (text.length() == 3) {
            pos = 5;
        }
        this.g.drawString(text, x + pos, y + 20);
    }

    private boolean isMousePointing(int x, int y, int w, int h) {
        return this.isInside(x, y, w, h, this.mouseX, this.mouseY);
    }

    private boolean isSelected(int x, int y, int w, int h, String text) {
        if (!this.isInside(x, y, w, h, this.selX, this.selY)) {
            if (TextUtil.isNumeric((String)text)) {
                return this.curSelection == Integer.parseInt(text);
            }
        } else if (TextUtil.isNumeric((String)text)) {
            this.curSelection = Integer.parseInt(text);
            this.cal.set(5, this.curSelection);
            this.date.setTime(this.cal.getTimeInMillis());
            this.refreshDate();
            return true;
        }
        return false;
    }

    private boolean isInside(int x, int y, int w, int h, int testX, int testY) {
        if (testX >= x && testX <= x + w) {
            return testY >= y && testY <= y + h;
        }
        return false;
    }

    public Date getSelectedDate() {
        return this.date;
    }

    public String[] getDayNames() {
        return this.dayNames;
    }

    public void setDayNames(String[] dayNames) {
        this.dayNames = dayNames;
    }

    public String[] getMonthNames() {
        return this.monthNames;
    }

    public void setMonthNames(String[] monthNames) {
        this.monthNames = monthNames;
    }

    public boolean isShowAsCombo() {
        return this.showAsCombo;
    }

    public void setShowAsCombo(boolean showAsCombo) {
        this.showAsCombo = showAsCombo;
    }
}

